/*
 * Decompiled with CFR 0.152.
 */
package de.xam.color;

import de.xam.color.HSLColor;
import de.xam.color.MPL_ColorTool;
import de.xam.color.RGBColor;
import java.util.Map;

public class ColorTool
extends MPL_ColorTool {
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double TWO_THIRDS = 0.6666666666666666;

    public static RGBColor brighter(RGBColor c, double f) {
        return new RGBColor(Math.min(c.getRed255() / f, 255.0), Math.min(c.getGreen255() / f, 255.0), Math.min(c.getBlue255() / f, 255.0), 0.0);
    }

    static final RGBColor hslToRgb(double h, double s, double v, double alpha) {
        double chroma = s * v;
        double hdash = h / 60.0;
        double x = chroma * (1.0 - Math.abs(hdash % 2.0 - 1.0));
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (hdash < 1.0) {
            r = chroma;
            g = x;
        } else if (hdash < 2.0) {
            r = x;
            g = chroma;
        } else if (hdash < 3.0) {
            g = chroma;
            b = x;
        } else if (hdash < 4.0) {
            g = x;
            b = chroma;
        } else if (hdash < 5.0) {
            r = x;
            b = chroma;
        } else if (hdash < 6.0) {
            r = chroma;
            b = x;
        }
        double min = v - chroma;
        return new RGBColor(r + min, g + min, b + min, alpha);
    }

    public static RGBColor hslToRgb(HSLColor hsl) {
        double hue = hsl.getHue1();
        double sat = hsl.getSaturation();
        double lum = hsl.getLuminance();
        if (sat == 0.0) {
            double gray = lum * 255.0;
            return new RGBColor(gray, gray, gray, hsl.getAlpha());
        }
        double m2 = lum < 0.5 ? lum * (1.0 + sat) : lum + sat - lum * sat;
        double m1 = 2.0 * lum - m2;
        double r = ColorTool.hueToRgb(m1, m2, hue + 0.3333333333333333);
        double g = ColorTool.hueToRgb(m1, m2, hue);
        double b = ColorTool.hueToRgb(m1, m2, hue - 0.3333333333333333);
        return new RGBColor(255.0 * r, 255.0 * g, 255.0 * b, hsl.getAlpha());
    }

    private static double hueToRgb(double m1, double m2, double hue) {
        double h = hue;
        if (h < 0.0) {
            h += 1.0;
        }
        if (h > 1.0) {
            h -= 1.0;
        }
        if (6.0 * h < 1.0) {
            return m1 + (m2 - m1) * 6.0 * h;
        }
        if (2.0 * h < 1.0) {
            return m2;
        }
        if (3.0 * h < 2.0) {
            return m1 + (m2 - m1) * ((0.6666666666666666 - h) * 6.0);
        }
        return m1;
    }

    public static void main(String[] args) {
        RGBColor red = ColorTool.parse("red");
        RGBColor fuchsia = ColorTool.parse("fuchsia");
        System.out.println(red.toHSL().toCssHSLA());
        System.out.println(fuchsia.toHSL().toCssHSLA());
        ColorTool.dumpDiff("red", "fuchsia");
    }

    public static RGBColor tryParse(String colorDef) {
        try {
            return ColorTool.parse(colorDef);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static RGBColor defineRGBA(double r, double g, double b, double alpha) {
        return new RGBColor(r, g, b, alpha);
    }

    public static HSLColor defineHSLA(double h, double s, double l, double alpha) {
        return new HSLColor(h, s / 100.0, l / 100.0, alpha / 100.0);
    }

    public static final HSLColor rgbToHsl(RGBColor rgb) {
        double red = rgb.getRed1();
        double green = rgb.getGreen1();
        double blue = rgb.getBlue1();
        double max = Math.max(red, Math.max(green, blue));
        double min = Math.min(red, Math.min(green, blue));
        double luminance = (max + min) / 2.0;
        double chroma = max - min;
        if (chroma == 0.0) {
            return new HSLColor(0.0, 0.0, luminance, rgb.getAlpha());
        }
        double saturation = 0.0;
        saturation = luminance < 0.5 ? chroma / (max + min) : chroma / (2.0 - max - min);
        double hue = 0.0;
        if (chroma == 0.0) {
            hue = 0.0;
        } else if (max == red) {
            hue = 0.0 + (green - blue) / chroma;
        } else if (max == green) {
            hue = 2.0 + (blue - red) / chroma;
        } else if (max == blue) {
            hue = 4.0 + (red - green) / chroma;
        }
        hue *= 60.0;
        if (hue < 0.0) {
            hue += 360.0;
        }
        return new HSLColor(hue, saturation, luminance, rgb.getAlpha());
    }

    public RGBColor darker(RGBColor c, double f) {
        return new RGBColor(Math.max(c.getRed255() * f, 0.0), Math.max(c.getGreen255() * f, 0.0), Math.max(c.getBlue255() * f, 0.0), 0.0);
    }

    public static String nameColor(RGBColor rgb) {
        HSLColor orig = rgb.toHSL();
        double prevDiff = 360.0;
        String prevName = null;
        double nextDiff = 360.0;
        String nextName = null;
        for (Map.Entry e : namedColors.entrySet()) {
            HSLColor comp = ((RGBColor)e.getValue()).toHSL();
            double diff = ColorTool.diff(orig, comp);
            if (comp.getHue360() < orig.getHue360()) {
                if (!(diff < prevDiff)) continue;
                prevDiff = diff;
                prevName = (String)e.getKey();
                System.out.println("Closer prev: " + (String)e.getKey());
                continue;
            }
            if (!(diff < nextDiff)) continue;
            nextDiff = diff;
            nextName = (String)e.getKey();
            System.out.println("Closer next: " + (String)e.getKey());
        }
        return prevName + "-" + nextName;
    }

    private static double diff(HSLColor a, HSLColor b) {
        double hueDiff = Math.abs(a.getHue1() - b.getHue1());
        double lumDiff = Math.abs(a.getLuminance() - b.getLuminance());
        double satDiff = Math.abs(a.getSaturation() - b.getSaturation());
        return hueDiff * hueDiff + lumDiff * lumDiff + satDiff * satDiff;
    }

    public static void dumpDiff(String color1, String color2) {
        RGBColor a1 = ColorTool.parse(color1);
        RGBColor a2 = ColorTool.parse(color2);
        HSLColor h1 = a1.toHSL();
        HSLColor h2 = a2.toHSL();
        HSLColor h3 = h1.minus(h2);
        System.out.println(h3.toCssHSLA());
    }

    public static HSLColor mix(double a, HSLColor colorA, double b, HSLColor colorB) {
        return new HSLColor(a * colorA.getHue360() + b * colorB.getHue360() / (a + b), a * colorA.getSaturation() + b * colorB.getSaturation() / (a + b), a * colorA.getLuminance() + b * colorB.getLuminance() / (a + b), a * colorA.getAlpha() + b * colorB.getAlpha() / (a + b));
    }
}

