/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.index;

import com.google.web.bindery.event.shared.EventBus;
import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.fact.CTriple;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.event.AttributeEvent;
import de.xam.itemset.event.ItemEvent;
import de.xam.itemset.event.PropertyEvent;
import de.xam.itemset.event.StatementEvent;
import de.xam.itemset.impl.ItemSetListeners;
import de.xam.itemset.index.IItemSetAttributeIndex;
import de.xam.itemset.index.IItemSetItemIndex;
import de.xam.itemset.index.IItemSetManagedIndex;
import de.xam.itemset.index.IItemSetPropertyIndex;
import de.xam.itemset.index.IItemSetStatementIndex;
import de.xam.itemset.index.IItemSetTripleIndex;
import de.xam.itemset.index.IRecomputableState;
import de.xam.itemset.index.IndexState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class IndexManager {
    private static final Logger log = LoggerFactory.getLogger(IndexManager.class);
    private final String debugName;
    private final Map<IItemSetManagedIndex, IndexState> index2state = new HashMap<IItemSetManagedIndex, IndexState>();
    private final Set<IndexState> indexStates = new HashSet<IndexState>();
    private transient IItemSet itemSet;
    private final Set<IndexState> nonUpdatingAttributeIndexStates = new HashSet<IndexState>();
    private final Set<IndexState> nonUpdatingItemIndexStates = new HashSet<IndexState>();
    private final Set<IndexState> nonUpdatingPropertyIndexStates = new HashSet<IndexState>();
    private final Set<IndexState> nonUpdatingStatementIndexStates = new HashSet<IndexState>();
    private final Set<IndexState> nonUpdatingTripleIndexStates = new HashSet<IndexState>();
    private final Set<IItemSetAttributeIndex> updatingAttributeIndex = new HashSet<IItemSetAttributeIndex>();
    private final Set<IItemSetItemIndex> updatingItemIndex = new HashSet<IItemSetItemIndex>();
    private final Set<IItemSetPropertyIndex> updatingPropertyIndex = new HashSet<IItemSetPropertyIndex>();
    private final Set<IItemSetStatementIndex> updatingStatementIndex = new HashSet<IItemSetStatementIndex>();
    private final Set<IItemSetTripleIndex> updatingTripleIndex = new HashSet<IItemSetTripleIndex>();

    public static IndexManager createWithoutItemSet(String debugName) {
        return new IndexManager(debugName);
    }

    private IndexManager(String debugName) {
        this.debugName = debugName;
    }

    public IndexManager(String debugName, IItemSet itemSet) {
        this(debugName);
        this.setItemSet(itemSet);
    }

    public void assertIndexesAre_computed_updating(Boolean computed, Boolean updating) {
        for (IndexState indexState : this.indexStates) {
            indexState.assertIs_computed_updating(computed, updating);
        }
    }

    public void clearAndMarkAsComputed() {
        for (IndexState indexState : this.indexStates) {
            indexState.getManagedIndex().clear();
            indexState.markAsComputed();
        }
    }

    public boolean ensureIndexIsComputed(IItemSetManagedIndex managedIndex, IIndexProgress indexProgress) {
        assert (this.index2state.containsKey(managedIndex));
        IndexState indexState = this.getIndexState(managedIndex);
        return indexState.ensureIsComputed(indexProgress);
    }

    public void exception(Exception e, String circumstances) {
        throw new RuntimeException(circumstances, e);
    }

    public IndexState getIndexState(IItemSetManagedIndex managedIndex) {
        return this.index2state.get(managedIndex);
    }

    public Collection<IndexState> list() {
        return this.indexStates;
    }

    public void markAsDirty() {
        log.info("Mark as stale (not computed) all indexes under " + this.debugName);
        for (IndexState indexState : this.indexStates) {
            indexState.markAsDirty();
        }
    }

    public boolean reCompute(IIndexProgress indexProgress) {
        return this.reCompute(this.indexStates, indexProgress);
    }

    boolean reCompute(Set<IndexState> indexStates, IIndexProgress indexProgress) {
        ArrayList<IndexState> reComputing = new ArrayList<IndexState>();
        ArrayList<IItemSetAttributeIndex> attributeIndexes = new ArrayList<IItemSetAttributeIndex>();
        ArrayList<IItemSetItemIndex> itemIndexes = new ArrayList<IItemSetItemIndex>();
        ArrayList<IItemSetPropertyIndex> propertyIndexes = new ArrayList<IItemSetPropertyIndex>();
        ArrayList<IItemSetStatementIndex> statementIndexes = new ArrayList<IItemSetStatementIndex>();
        ArrayList<IItemSetTripleIndex> tripleIndexes = new ArrayList<IItemSetTripleIndex>();
        ArrayList<IItemSetManagedIndex> reComputingSpecial = new ArrayList<IItemSetManagedIndex>();
        for (IndexState indexState : indexStates) {
            if (indexState.isComputed()) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Index " + indexState.getId() + " was still fresh");
                continue;
            }
            IItemSetManagedIndex index = indexState.getManagedIndex();
            log.info("Computing index " + indexState.getId() + " " + index.getClass().getCanonicalName());
            if (indexProgress != null) {
                indexProgress.reportStart(indexState);
            }
            reComputing.add(indexState);
            boolean updateFromItemSet = false;
            if (index instanceof IItemSetAttributeIndex) {
                attributeIndexes.add((IItemSetAttributeIndex)index);
                updateFromItemSet = true;
            }
            if (index instanceof IItemSetItemIndex) {
                itemIndexes.add((IItemSetItemIndex)index);
                updateFromItemSet = true;
            }
            if (index instanceof IItemSetPropertyIndex) {
                propertyIndexes.add((IItemSetPropertyIndex)index);
                updateFromItemSet = true;
            }
            if (index instanceof IItemSetStatementIndex) {
                statementIndexes.add((IItemSetStatementIndex)index);
                updateFromItemSet = true;
            }
            if (index instanceof IItemSetTripleIndex) {
                tripleIndexes.add((IItemSetTripleIndex)index);
                updateFromItemSet = true;
            }
            if (updateFromItemSet || !(index instanceof IRecomputableState)) continue;
            reComputingSpecial.add(index);
        }
        if (reComputing.isEmpty()) {
            return false;
        }
        for (IndexState indexState : reComputing) {
            log.info("Clearing index " + indexState.getId());
            indexState.getManagedIndex().clear();
        }
        boolean updateAttributes = !attributeIndexes.isEmpty();
        boolean updateItems = !itemIndexes.isEmpty();
        boolean updateProperties = !propertyIndexes.isEmpty();
        boolean updateStatements = !statementIndexes.isEmpty();
        boolean updateTriples = !tripleIndexes.isEmpty();
        boolean updateFromItemSet = updateAttributes || updateItems || updateProperties || updateStatements || updateTriples;
        int attributes = 0;
        int items = 0;
        int properties = 0;
        int statements = 0;
        int triples = 0;
        if (updateFromItemSet) {
            for (XId xId : this.itemSet) {
                IEntity entity = this.itemSet.getEntityById(xId);
                if (entity instanceof IItem) {
                    if (!updateAttributes && !updateItems) continue;
                    IItem item = (IItem)entity;
                    if (updateAttributes) {
                        Iterator attIt = item.attributes();
                        while (attIt.hasNext()) {
                            XId attId = (XId)attIt.next();
                            XValue attValue = item.getAttribute(attId);
                            for (IItemSetAttributeIndex attributeIndex : attributeIndexes) {
                                Set<XId> set = attributeIndex.getAttributeIdsToBeIndexed();
                                if (set != null && !set.contains(attId)) continue;
                                try {
                                    attributeIndex.onAttributeChange(xId, attId, null, attValue);
                                }
                                catch (Exception e) {
                                    this.exception(e, "reCompute attribute " + xId + "." + attId);
                                }
                            }
                        }
                        ++attributes;
                        if (indexProgress != null) {
                            indexProgress.reportProgress();
                        }
                    }
                    if (!updateItems) continue;
                    CBrowserRenderableContent newContent = item.getContent();
                    assert (newContent != null);
                    for (IItemSetItemIndex itemIndex : itemIndexes) {
                        try {
                            itemIndex.onItemChange(xId, null, newContent);
                        }
                        catch (Exception e) {
                            this.exception(e, "reCompute item " + xId);
                        }
                    }
                    ++items;
                    if (indexProgress == null) continue;
                    indexProgress.reportProgress();
                    continue;
                }
                if (entity instanceof IProperty) {
                    if (!updateProperties) continue;
                    IProperty property = (IProperty)entity;
                    for (IItemSetPropertyIndex propertyIndex : propertyIndexes) {
                        try {
                            propertyIndex.onPropertyAdd(property, property.getContent());
                        }
                        catch (Exception e) {
                            this.exception(e, "reCompute property " + xId);
                        }
                    }
                    ++properties;
                    if (indexProgress == null) continue;
                    indexProgress.reportProgress();
                    continue;
                }
                if (!(entity instanceof IStatement) || !updateStatements && !updateTriples) continue;
                IStatement statement = (IStatement)entity;
                if (updateStatements) {
                    for (IItemSetStatementIndex statementIndex : statementIndexes) {
                        try {
                            statementIndex.onStatementAdd(statement);
                        }
                        catch (Exception e) {
                            this.exception(e, "reCompute statement " + xId);
                        }
                    }
                    ++statements;
                    if (indexProgress != null) {
                        indexProgress.reportProgress();
                    }
                }
                if (!updateTriples) continue;
                CTriple triple = statement.getTriple();
                XId s = triple.s();
                XId p = triple.p();
                XId o = triple.o();
                for (IItemSetTripleIndex tripleIndex : tripleIndexes) {
                    try {
                        tripleIndex.onTripleAdd(s, p, o);
                    }
                    catch (Exception e) {
                        this.exception(e, "reCompute triple (" + s + "," + p + "," + o + ")");
                    }
                }
                ++triples;
                if (indexProgress == null) continue;
                indexProgress.reportProgress();
            }
        }
        for (IRecomputableState iRecomputableState : reComputingSpecial) {
            iRecomputableState.ensureIsComputed(indexProgress);
        }
        for (IndexState indexState : reComputing) {
            indexState.markAsComputed();
            if (indexProgress == null) continue;
            indexProgress.reportDone(indexState);
        }
        return true;
    }

    public IndexState register(IItemSetManagedIndex managedIndex, XId id, String label) {
        assert (this.getIndexState(managedIndex) == null);
        IndexState indexState = new IndexState(this, id, label, managedIndex);
        this.index2state.put(managedIndex, indexState);
        if (managedIndex instanceof IItemSetAttributeIndex) {
            this.updatingAttributeIndex.add((IItemSetAttributeIndex)managedIndex);
        }
        if (managedIndex instanceof IItemSetItemIndex) {
            this.updatingItemIndex.add((IItemSetItemIndex)managedIndex);
        }
        if (managedIndex instanceof IItemSetPropertyIndex) {
            this.updatingPropertyIndex.add((IItemSetPropertyIndex)managedIndex);
        }
        if (managedIndex instanceof IItemSetStatementIndex) {
            this.updatingStatementIndex.add((IItemSetStatementIndex)managedIndex);
        }
        if (managedIndex instanceof IItemSetTripleIndex) {
            this.updatingTripleIndex.add((IItemSetTripleIndex)managedIndex);
        }
        this.indexStates.add(indexState);
        return indexState;
    }

    public void setItemSet(IItemSet itemSet) {
        this.itemSet = itemSet;
        EventBus eventBus = this.itemSet.getEventBus();
        ItemSetListeners.addAttributeListener(eventBus, new ATTRIBUTE_EVENTS_HANDLER());
        ItemSetListeners.addItemListener(eventBus, new ITEM_EVENTS_HANDLER());
        ItemSetListeners.addPropertyListener(eventBus, new PROPERTY_EVENTS_HANDLER());
        ItemSetListeners.addStatementListener(eventBus, new STATEMENT_EVENTS_HANDLER());
    }

    public void setUpdating(boolean b) {
        log.info("Setting for all indexes " + this.debugName + " updating=" + b);
        for (IndexState indexState : this.indexStates) {
            if (indexState.isUpdating() == b) continue;
            indexState.setUpdating(b);
            IItemSetManagedIndex managedIndex = indexState.getManagedIndex();
            this.setUpdating(managedIndex, indexState, b);
        }
    }

    public void setUpdating(IItemSetManagedIndex index, boolean b) {
        IndexState indexState = this.getIndexState(index);
        this.setUpdating(index, indexState, b);
    }

    private void setUpdating(IItemSetManagedIndex managedIndex, IndexState indexState, boolean b) {
        indexState.setUpdating(b);
        if (b) {
            if (managedIndex instanceof IItemSetAttributeIndex) {
                this.nonUpdatingAttributeIndexStates.remove(indexState);
                this.updatingAttributeIndex.add((IItemSetAttributeIndex)managedIndex);
            }
            if (managedIndex instanceof IItemSetItemIndex) {
                this.nonUpdatingItemIndexStates.remove(indexState);
                this.updatingItemIndex.add((IItemSetItemIndex)managedIndex);
            }
            if (managedIndex instanceof IItemSetPropertyIndex) {
                this.nonUpdatingPropertyIndexStates.remove(indexState);
                this.updatingPropertyIndex.add((IItemSetPropertyIndex)managedIndex);
            }
            if (managedIndex instanceof IItemSetStatementIndex) {
                this.nonUpdatingStatementIndexStates.remove(indexState);
                this.updatingStatementIndex.add((IItemSetStatementIndex)managedIndex);
            }
            if (managedIndex instanceof IItemSetTripleIndex) {
                this.nonUpdatingTripleIndexStates.remove(indexState);
                this.updatingTripleIndex.add((IItemSetTripleIndex)managedIndex);
            }
        } else {
            if (managedIndex instanceof IItemSetAttributeIndex) {
                this.updatingAttributeIndex.remove(managedIndex);
                this.nonUpdatingAttributeIndexStates.add(indexState);
            }
            if (managedIndex instanceof IItemSetItemIndex) {
                this.updatingItemIndex.remove(managedIndex);
                this.nonUpdatingItemIndexStates.add(indexState);
            }
            if (managedIndex instanceof IItemSetPropertyIndex) {
                this.updatingPropertyIndex.remove(managedIndex);
                this.nonUpdatingPropertyIndexStates.add(indexState);
            }
            if (managedIndex instanceof IItemSetStatementIndex) {
                this.updatingStatementIndex.remove(managedIndex);
                this.nonUpdatingStatementIndexStates.add(indexState);
            }
            if (managedIndex instanceof IItemSetTripleIndex) {
                this.updatingTripleIndex.remove(managedIndex);
                this.nonUpdatingTripleIndexStates.add(indexState);
            }
        }
    }

    public String toString() {
        return this.debugName;
    }

    private class STATEMENT_EVENTS_HANDLER
    implements StatementEvent.StatementEventHandler {
        private STATEMENT_EVENTS_HANDLER() {
        }

        @Override
        public void onStatementEvent(StatementEvent event) {
            IStatement stmt = event.getStatement();
            switch (event.getChangeType()) {
                case Add: {
                    for (IItemSetStatementIndex statementIndex : IndexManager.this.updatingStatementIndex) {
                        try {
                            statementIndex.onStatementAdd(stmt);
                        }
                        catch (Exception e) {
                            IndexManager.this.exception(e, "addStatement " + stmt + " in " + IndexManager.this.getIndexState(statementIndex));
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingStatementIndexStates) {
                        indexState.markAsDirty();
                    }
                    if (!IndexManager.this.updatingTripleIndex.isEmpty()) {
                        CTriple t = stmt.getTriple();
                        XId s = t.s();
                        XId p = t.p();
                        XId o = t.o();
                        for (IItemSetTripleIndex tripleIndex : IndexManager.this.updatingTripleIndex) {
                            try {
                                tripleIndex.onTripleAdd(s, p, o);
                            }
                            catch (Exception e) {
                                IndexManager.this.exception(e, "addTriple " + stmt + " in " + IndexManager.this.getIndexState(tripleIndex));
                            }
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingTripleIndexStates) {
                        indexState.markAsDirty();
                    }
                    break;
                }
                case Change: {
                    for (IItemSetStatementIndex statementIndex : IndexManager.this.updatingStatementIndex) {
                        try {
                            statementIndex.onStatementChange(stmt);
                        }
                        catch (Exception e) {
                            IndexManager.this.exception(e, "changeStatement " + stmt + " in " + IndexManager.this.getIndexState(statementIndex));
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingStatementIndexStates) {
                        indexState.markAsDirty();
                    }
                    break;
                }
                case Remove: {
                    for (IItemSetStatementIndex statementIndex : IndexManager.this.updatingStatementIndex) {
                        try {
                            statementIndex.onStatementRemove(stmt);
                        }
                        catch (Exception e) {
                            IndexManager.this.exception(e, "removeStatement " + stmt + " in " + IndexManager.this.getIndexState(statementIndex));
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingStatementIndexStates) {
                        indexState.markAsDirty();
                    }
                    if (!IndexManager.this.updatingTripleIndex.isEmpty()) {
                        CTriple t = stmt.getTriple();
                        XId s = t.s();
                        XId p = t.p();
                        XId o = t.o();
                        for (IItemSetTripleIndex tripleIndex : IndexManager.this.updatingTripleIndex) {
                            try {
                                tripleIndex.onTripleRemove(s, p, o);
                            }
                            catch (Exception e) {
                                IndexManager.this.exception(e, "removeTriple " + stmt + " in " + IndexManager.this.getIndexState(tripleIndex));
                            }
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingTripleIndexStates) {
                        indexState.markAsDirty();
                    }
                    break;
                }
            }
        }
    }

    private class PROPERTY_EVENTS_HANDLER
    implements PropertyEvent.PropertyEventHandler {
        private PROPERTY_EVENTS_HANDLER() {
        }

        @Override
        public void onPropertyEvent(PropertyEvent event) {
            IProperty property = event.getProperty();
            switch (event.getChangeType()) {
                case Add: {
                    CBrowserRenderableContent newContent = event.getNewContent();
                    for (IItemSetPropertyIndex propertyIndex : IndexManager.this.updatingPropertyIndex) {
                        try {
                            propertyIndex.onPropertyAdd(property, newContent);
                        }
                        catch (Exception e) {
                            IndexManager.this.exception(e, "addProperty " + property + " in " + IndexManager.this.getIndexState(propertyIndex));
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingPropertyIndexStates) {
                        indexState.markAsDirty();
                    }
                    break;
                }
                case Change: {
                    CBrowserRenderableContent oldContent = event.getOldContent();
                    CBrowserRenderableContent newContent = event.getNewContent();
                    for (IItemSetPropertyIndex propertyIndex : IndexManager.this.updatingPropertyIndex) {
                        try {
                            propertyIndex.onPropertyChange(property, oldContent, newContent);
                        }
                        catch (Exception e) {
                            IndexManager.this.exception(e, "changeProperty " + property + " in " + IndexManager.this.getIndexState(propertyIndex));
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingPropertyIndexStates) {
                        indexState.markAsDirty();
                    }
                    break;
                }
                case Remove: {
                    CBrowserRenderableContent oldContent = event.getOldContent();
                    for (IItemSetPropertyIndex propertyIndex : IndexManager.this.updatingPropertyIndex) {
                        try {
                            propertyIndex.onPropertyRemove(property, oldContent);
                        }
                        catch (Exception e) {
                            IndexManager.this.exception(e, "removeProperty " + property + " in " + IndexManager.this.getIndexState(propertyIndex));
                        }
                    }
                    for (IndexState indexState : IndexManager.this.nonUpdatingPropertyIndexStates) {
                        indexState.markAsDirty();
                    }
                    break;
                }
            }
        }
    }

    private class ITEM_EVENTS_HANDLER
    implements ItemEvent.ItemEventHandler {
        private ITEM_EVENTS_HANDLER() {
        }

        @Override
        public void onItemEvent(ItemEvent event) {
            XId itemId = event.getItemId();
            CBrowserRenderableContent oldContent = event.getOldContent();
            CBrowserRenderableContent newContent = event.getNewContent();
            for (IItemSetItemIndex itemIndex : IndexManager.this.updatingItemIndex) {
                try {
                    itemIndex.onItemChange(itemId, oldContent, newContent);
                }
                catch (Exception e) {
                    IndexManager.this.exception(e, "item " + itemId + " in " + IndexManager.this.getIndexState(itemIndex));
                }
            }
            for (IndexState indexState : IndexManager.this.nonUpdatingItemIndexStates) {
                indexState.markAsDirty();
            }
        }
    }

    public static interface IIndexProgress {
        public void reportDone(IndexState var1);

        public void reportProgress();

        public void reportStart(IndexState var1);
    }

    private class ATTRIBUTE_EVENTS_HANDLER
    implements AttributeEvent.AttributeEventHandler {
        private ATTRIBUTE_EVENTS_HANDLER() {
        }

        @Override
        public void onAttributeEvent(AttributeEvent event) {
            XId entityId = event.getEntityId();
            XId attributeId = event.getAttributeId();
            XValue oldValue = event.getOldValue();
            XValue newValue = event.getNewValue();
            for (IItemSetAttributeIndex attributeIndex : IndexManager.this.updatingAttributeIndex) {
                Set<XId> set = attributeIndex.getAttributeIdsToBeIndexed();
                if (set != null && !set.contains(attributeId)) continue;
                try {
                    attributeIndex.onAttributeChange(entityId, attributeId, oldValue, newValue);
                }
                catch (Exception e) {
                    IndexManager.this.exception(e, "attribute " + entityId + "." + attributeId + " in " + IndexManager.this.getIndexState(attributeIndex));
                }
            }
            for (IndexState indexState : IndexManager.this.nonUpdatingAttributeIndexStates) {
                indexState.markAsDirty();
            }
        }
    }
}

