/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl.xydra;

import com.google.web.bindery.event.shared.EventBus;
import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.content.XydraContentType;
import de.xam.cmodel.content.impl.BrecNativeXydraValue;
import de.xam.cmodel.content.impl.MemoryBrec;
import de.xam.cmodel.fact.CFactory;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.IHasAttributes;
import de.xam.cmodel.fact.IHasReadableAttributes;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.cmodel.fact.impl.AttributeContentUtils;
import de.xam.cmodel.fact.impl.xydra.XyFactory;
import de.xam.cmodel.util.XydraUtils;
import de.xam.itemset.ConfParamsItemSet;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSetSource;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.Items;
import de.xam.itemset.impl.xydra.IHasTransaction;
import de.xam.itemset.impl.xydra.ItemSetXy;
import de.xam.itemset.impl.xydra.ItemXy;
import de.xam.itemset.impl.xydra.PropertyXy;
import de.xam.itemset.impl.xydra.RenameUtils;
import de.xam.itemset.impl.xydra.StatementXy;
import de.xam.itemset.impl.xydra.WrapModel;
import de.xam.itemset.impl.xydra.WrapObject;
import de.xam.texthtml.text.TextTool;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.annotations.IgnoreMemoryConsumption;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.change.ChangeType;
import org.xydra.base.change.XCommand;
import org.xydra.base.change.XCommandUtils;
import org.xydra.base.change.XFieldEvent;
import org.xydra.base.change.XTransaction;
import org.xydra.base.change.XTransactionEvent;
import org.xydra.base.id.XidCodec;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.rmof.impl.memory.SimpleObject;
import org.xydra.base.util.DumpUtilsBase;
import org.xydra.base.value.ValueType;
import org.xydra.base.value.XBinaryValue;
import org.xydra.base.value.XIdSetValue;
import org.xydra.base.value.XSetDiffable;
import org.xydra.base.value.XSetValue;
import org.xydra.base.value.XStringValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.base.value.impl.memory.MemorySetValue;
import org.xydra.conf.IConfig;
import org.xydra.core.XX;
import org.xydra.core.change.XFieldEventListener;
import org.xydra.core.change.XTransactionEventListener;
import org.xydra.core.model.XChangeLog;
import org.xydra.core.model.XModel;
import org.xydra.core.model.XObject;
import org.xydra.core.model.delta.AtomicChangeType;
import org.xydra.core.model.delta.ChangeSummaryType;
import org.xydra.core.model.delta.OldValues;
import org.xydra.core.model.delta.Summarizer;
import org.xydra.core.model.delta.SummaryField;
import org.xydra.core.model.delta.SummaryModel;
import org.xydra.core.model.delta.SummaryObject;
import org.xydra.core.model.impl.memory.MemoryRepository;
import org.xydra.core.model.impl.memory.sync.ISyncLog;
import org.xydra.env.Env;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class XydraWrapper
implements IHasAttributes,
IItemSetSource {
    private static final IFilter<XObject> FILTER_IS_ITEM = new IFilter<XObject>(){

        public boolean matches(XObject xo) {
            return XydraWrapper.getType((XReadableObject)xo) == VocabularyCModel.Type.Item;
        }
    };
    private static final IFilter<XObject> FILTER_IS_PROPERTY = new IFilter<XObject>(){

        public boolean matches(XObject xo) {
            return XydraWrapper.getType((XReadableObject)xo) == VocabularyCModel.Type.Property;
        }
    };
    private static final IFilter<XObject> FILTER_IS_STATEMENT = new IFilter<XObject>(){

        public boolean matches(XObject xo) {
            return XydraWrapper.getType((XReadableObject)xo) == VocabularyCModel.Type.Statement;
        }
    };
    private static final String INTERNAL_ID_PREFIX = "_";
    private static final IFilter<XId> HIDE_INTERNAL_IDS = new IFilter<XId>(){

        public boolean matches(XId entry) {
            String decodedId = XidCodec.decode((String)entry.toString());
            return !decodedId.startsWith(XydraWrapper.INTERNAL_ID_PREFIX);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(XydraWrapper.class);
    private static final XId META_OBJECT_ID = XX.toId((String)"_meta");
    protected static transient ITransformer<XId, IItem> TRANSFORMER_ID2ITEM;
    protected static transient ITransformer<XObject, IItem> TRANSFORMER_XO2ITEM;
    protected static transient ITransformer<XObject, IProperty> TRANSFORMER_XO2PROPERTY;
    protected static transient ITransformer<XObject, IStatement> TRANSFORMER_XO2STATEMENT;
    private HashSet<String> allowedContentTypes = null;
    @IgnoreMemoryConsumption
    private EventBus eventBus;
    private XyFactory factory;
    private ItemSetXy itemSet;
    private XModel xmodel;
    private final transient XFieldEventListener xmodel_field2itemmodel = new XFieldEventListener(){

        public void onChangeEvent(XFieldEvent fieldEvent) {
            if (fieldEvent.inTransaction()) {
                // empty if block
            }
            XydraWrapper.this.onFieldEvent(fieldEvent);
        }
    };
    private final transient XTransactionEventListener xmodel_txn2itemmodel = new XTransactionEventListener(){

        public void onChangeEvent(XTransactionEvent txnEvent) {
            XydraWrapper.refireXEventAsMyBaseEvents(XydraWrapper.this.getXModel(), XydraWrapper.this.itemSet, XydraWrapper.this.getXModel().getChangeLog(), txnEvent, XydraWrapper.this.getEventBus());
        }
    };

    protected static XSetDiffable.XSetDiff<XId> computeDiff(XValue a, XValue b) {
        if (a == null) {
            if (b == null) {
                return new MemorySetValue.SetDiff();
            }
            MemorySetValue.SetDiff diff = new MemorySetValue.SetDiff();
            XIdSetValue bSet = (XIdSetValue)b;
            diff.added.addAll(bSet.toSet());
            return diff;
        }
        XIdSetValue aSet = (XIdSetValue)a;
        if (b == null) {
            MemorySetValue.SetDiff diff = new MemorySetValue.SetDiff();
            diff.removed.addAll(aSet.toSet());
            return diff;
        }
        XIdSetValue bSet = (XIdSetValue)b;
        return aSet.computeDiff((XSetValue)bSet);
    }

    public static VocabularyCModel.Type getType(XReadableObject xo) {
        assert (xo != null);
        XValue typeValue = XydraWrapper.getTypeValue(xo);
        assert (typeValue != null);
        String type = ((XStringValue)typeValue).contents();
        assert (type != null);
        return VocabularyCModel.Type.valueOf((String)type);
    }

    public static XValue getTypeValue(XReadableObject xo) {
        assert (xo != null);
        XReadableField xf = xo.getField(VocabularyCModel.ATTRIBUTE_TYPE);
        assert (xf != null) : "field '" + xo.getAddress() + "." + VocabularyCModel.ATTRIBUTE_TYPE + "' is not there";
        XValue typeValue = xf.getValue();
        assert (typeValue != null) : "no type value in " + DumpUtilsBase.toStringBuffer((XReadableObject)xo);
        return typeValue;
    }

    public XydraWrapper(EventBus eventBus) {
        this.eventBus = eventBus;
        this.factory = XydraWrapper.createFactory();
        TRANSFORMER_ID2ITEM = new ITransformer<XId, IItem>(){

            public IItem transform(XId id) {
                ItemXy item = XydraWrapper.this.itemSet.getItemById(id);
                assert (item != null) : "no item for id " + id;
                return item;
            }
        };
        TRANSFORMER_XO2ITEM = new ITransformer<XObject, IItem>(){

            public IItem transform(XObject xo) {
                ItemXy item = ItemXy.wrap(XydraWrapper.this.itemSet, (XWritableObject)xo);
                assert (item != null);
                return item;
            }
        };
        TRANSFORMER_XO2STATEMENT = new ITransformer<XObject, IStatement>(){

            public IStatement transform(XObject in) {
                return StatementXy.wrap(XydraWrapper.this.itemSet, (XWritableObject)in);
            }
        };
        TRANSFORMER_XO2PROPERTY = new ITransformer<XObject, IProperty>(){

            public IProperty transform(XObject in) {
                return PropertyXy.wrap(XydraWrapper.this.itemSet, (XWritableObject)in);
            }
        };
    }

    public void addItem(IItem sourceItem) throws IllegalArgumentException {
        assert (this.xmodel != null);
        assert (this.itemSet != null);
        assert (sourceItem != null);
        XId sourceEntityId = sourceItem.getId();
        ItemXy targetItem = this.getItemById(sourceEntityId);
        if (targetItem != null) {
            throw new IllegalArgumentException("item with id '" + sourceEntityId + "' exists already");
        }
        WrapObject wo = this.createAndAddObject(sourceEntityId);
        targetItem = ItemXy.create(this.itemSet, wo);
        Items.copyAttributes((IHasReadableAttributes)sourceItem, targetItem);
        assert (targetItem.getChangeData().getCreationDateUTC() != 0L || targetItem.getChangeData().getLastModifiedUTC() != 0L);
        this.executeTransaction(wo);
    }

    public void addProperty(IProperty sourceProperty) throws IllegalArgumentException {
        assert (this.xmodel != null);
        assert (this.itemSet != null);
        XId sourcePropertyId = sourceProperty.getId();
        PropertyXy targetProperty = this.getPropertyById(sourcePropertyId);
        if (targetProperty != null) {
            throw new IllegalArgumentException("property with id '" + sourcePropertyId + "' exists already");
        }
        assert (sourceProperty.getWritableContent().getContentValue() != null);
        WrapObject wo = this.createAndAddObject(sourcePropertyId);
        targetProperty = PropertyXy.create(this.itemSet, wo);
        Items.copyAttributes((IHasReadableAttributes)sourceProperty, targetProperty);
        assert (targetProperty.getChangeData().getCreationDateUTC() != 0L || targetProperty.getChangeData().getLastModifiedUTC() != 0L);
        this.executeTransaction(wo);
    }

    public void addStatement(IStatement sourceStatement) throws IllegalArgumentException {
        assert (this.xmodel != null);
        assert (this.itemSet != null);
        XId sourceStmtId = sourceStatement.getId();
        StatementXy targetStmt = this.getStatementById(sourceStmtId);
        if (targetStmt != null) {
            throw new IllegalArgumentException("stmt with id '" + sourceStmtId + "' exists already");
        }
        WrapObject wo = this.createAndAddObject(sourceStmtId);
        targetStmt = StatementXy.create(this.itemSet, wo);
        Items.copyAttributes((IHasReadableAttributes)sourceStatement, targetStmt);
        assert (targetStmt.getChangeData().getCreationDateUTC() != 0L || targetStmt.getChangeData().getLastModifiedUTC() != 0L);
        this.executeTransaction(wo);
    }

    public Iterator<XId> attributes() {
        return this.getOrCreateMetaObject().iterator();
    }

    private void connectEventListeners(XModel xmodel) {
        xmodel.addListenerForFieldEvents(this.xmodel_field2itemmodel);
        xmodel.addListenerForTransactionEvents(this.xmodel_txn2itemmodel);
    }

    public ItemXy createAndAddItem(XId itemId, IChangeData changeData) throws IllegalArgumentException {
        assert (changeData.getCreationDateUTC() != 0L || changeData.getLastModifiedUTC() != 0L);
        ItemXy item = this.getItemById(itemId);
        if (item != null) {
            throw new IllegalArgumentException("item with id '" + itemId + "' exists already");
        }
        WrapObject wo = this.createAndAddObject(itemId);
        item = ItemXy.create(this.itemSet, wo);
        item.setEntityMetaData(changeData);
        this.executeTransaction(wo);
        item = this.getItemById(itemId);
        return item;
    }

    private WrapObject createAndAddObject(XId objectId) {
        WrapModel wrapModel = new WrapModel((XWritableModel)this.xmodel);
        WrapObject o = wrapModel.createObject(objectId);
        return o;
    }

    public IProperty createAndAddProperty(XId propertyId, XId sourceEntityId, XId propertyKey, XValue propertyValue, IChangeData changeData) throws IllegalArgumentException {
        String contentTypeString = XydraContentType.toXydraTypeUri((ValueType)propertyValue.getType());
        return this.createAndAddProperty(propertyId, sourceEntityId, propertyKey, propertyValue, contentTypeString, changeData);
    }

    public IProperty createAndAddProperty(XId propertyId, XId sourceEntityId, XId propertyKey, String contentString, String contentTypeString, IChangeData changeData) {
        XStringValue value = XV.toValue((String)contentString);
        return this.createAndAddProperty(propertyId, sourceEntityId, propertyKey, (XValue)value, contentTypeString, changeData);
    }

    private IProperty createAndAddProperty(XId propertyId, XId sourceEntityId, XId propertyKey, XValue value, String contentTypeString, IChangeData changeData) {
        assert (propertyId != null);
        assert (sourceEntityId != null);
        assert (propertyKey != null);
        assert (changeData != null);
        PropertyXy prop = this.getPropertyById(propertyId);
        if (prop != null) {
            throw new IllegalArgumentException("property-statement with id '" + propertyId + "' exists already");
        }
        WrapObject wo = this.createAndAddObject(propertyId);
        prop = PropertyXy.create(this.itemSet, wo);
        prop.setEntityMetaData(changeData);
        prop.setSourceEntityId(sourceEntityId);
        prop.setPropertyKey(propertyKey);
        AttributeContentUtils.setContent((IHasAttributes)wo, (XValue)value, (String)contentTypeString, (long)ChangeDatas.getLastCreationOrModifiedDate((IChangeData)changeData));
        this.executeTransaction(wo);
        prop = this.getPropertyById(propertyId);
        return prop;
    }

    public IStatement createAndAddStatement(XId statementId, XId s, XId p, XId o, IChangeData changeData) throws IllegalArgumentException {
        assert (statementId != null);
        assert (s != null);
        assert (p != null);
        assert (o != null);
        assert (changeData != null);
        StatementXy stmt = this.getStatementById(statementId);
        if (stmt != null) {
            if (stmt.s().equals((Object)s) && stmt.p().equals((Object)p) && stmt.o().equals((Object)o)) {
                log.warn("Hmm, trying to add the exact same stmt again, why? " + stmt);
            } else {
                throw new IllegalArgumentException("statment with id '" + statementId + "' exists already: " + stmt);
            }
        }
        return this.createStatement(statementId, s, p, o, changeData);
    }

    public boolean deleteItem(XId itemId, IChangeData changeData) {
        assert (itemId != null);
        assert (this.xmodel.getObject(itemId) == null || this.xmodel.getObject(itemId).getFieldValue(VocabularyCModel.ATTRIBUTE_TYPE).equals(XV.toValue((String)VocabularyCModel.Type.Item.name())));
        boolean success = this.removeEntity(itemId, changeData);
        return success;
    }

    public boolean deleteProperty(XId propertyId, IChangeData changeData) {
        boolean success = this.removeEntity(propertyId, changeData);
        return success;
    }

    public boolean deleteStatement(XId statementId, IChangeData changeData) {
        assert (this.xmodel.getObject(statementId) == null || this.xmodel.getObject(statementId).getFieldValue(VocabularyCModel.ATTRIBUTE_TYPE).equals(XV.toValue((String)VocabularyCModel.Type.Statement.name())));
        boolean success = this.removeEntity(statementId, changeData);
        return success;
    }

    private void disconnectEventListeners(XModel xmodel) {
        xmodel.removeListenerForFieldEvents(this.xmodel_field2itemmodel);
        xmodel.removeListenerForTransactionEvents(this.xmodel_txn2itemmodel);
    }

    private boolean executeTransaction(IHasTransaction hasTxn) {
        XTransaction txn = hasTxn.toTransaction();
        if (txn == null) {
            return false;
        }
        assert (txn != null);
        long result = this.xmodel.executeCommand((XCommand)txn);
        assert (XCommandUtils.success((long)result)) : "txn failed: " + txn;
        return XCommandUtils.changedSomething((long)result);
    }

    public CFactory factory() {
        return this.factory;
    }

    private Iterator<XObject> getAllXObjects() {
        return Iterators.transform(this.iterator(), (ITransformer)new ITransformer<XId, XObject>(){

            public XObject transform(XId in) {
                return XydraWrapper.this.xmodel.getObject(in);
            }
        });
    }

    public XValue getAttribute(XId attributeId) {
        XWritableObject xo = this.getOrCreateMetaObject();
        return XydraUtils.getFieldValue((XReadableObject)xo, (XId)attributeId);
    }

    protected XChangeLog getChangeLog() {
        return this.xmodel.getChangeLog();
    }

    @Override
    public IEntity getEntityById(XId entityId) {
        XObject o = this.xmodel.getObject(entityId);
        if (o == null) {
            return null;
        }
        VocabularyCModel.Type type = this.getType(entityId);
        assert (type != null);
        switch (type) {
            case Item: {
                return ItemXy.wrap(this.itemSet, (XWritableObject)o);
            }
            case Statement: {
                return StatementXy.wrap(this.itemSet, (XWritableObject)o);
            }
            case Property: {
                return PropertyXy.wrap(this.itemSet, (XWritableObject)o);
            }
        }
        throw new AssertionError();
    }

    public XId getId() {
        return this.xmodel.getId();
    }

    @Override
    public ItemXy getItemById(XId itemId) {
        XObject o = this.xmodel.getObject(itemId);
        if (o == null) {
            return null;
        }
        if (this.getType(itemId) != VocabularyCModel.Type.Item) {
            return null;
        }
        return ItemXy.wrap(this.itemSet, (XWritableObject)o);
    }

    private XWritableObject getOrCreateMetaObject() {
        XObject wo = this.xmodel.getObject(META_OBJECT_ID);
        if (wo == null) {
            wo = this.xmodel.createObject(META_OBJECT_ID);
        }
        return wo;
    }

    public PropertyXy getPropertyById(XId propertyId) {
        XObject xo = this.xmodel.getObject(propertyId);
        if (xo == null) {
            return null;
        }
        if (this.getType(propertyId) != VocabularyCModel.Type.Property) {
            return null;
        }
        return PropertyXy.wrap(this.itemSet, (XWritableObject)xo);
    }

    public StatementXy getStatementById(XId stmtId) {
        XObject xo = this.xmodel.getObject(stmtId);
        if (xo == null) {
            return null;
        }
        if (this.getType(stmtId) != VocabularyCModel.Type.Statement) {
            return null;
        }
        return StatementXy.wrap(this.itemSet, (XWritableObject)xo);
    }

    public Iterator<CSymbol> getSymbols() {
        return Iterators.transform(this.items(), (ITransformer)new ITransformer<IItem, CSymbol>(){

            public CSymbol transform(IItem in) {
                return in;
            }
        });
    }

    public Iterator<CTriple> getTriples() {
        return Iterators.transform(this.statements(), (ITransformer)new ITransformer<IStatement, CTriple>(){

            public CTriple transform(IStatement in) {
                return in.getTriple();
            }
        });
    }

    public VocabularyCModel.Type getType(XId id) {
        XObject xo = this.xmodel.getObject(id);
        if (xo == null) {
            return null;
        }
        return XydraWrapper.getType((XReadableObject)xo);
    }

    public static VocabularyCModel.Type getType(XValue typeValue) {
        assert (typeValue != null);
        VocabularyCModel.Type type = VocabularyCModel.Type.valueOf((String)typeValue.toString());
        return type;
    }

    public static XValue getTypeValue(XReadableModel xmodel, XId objectId, SummaryObject summaryObject) {
        SummaryField summaryField = summaryObject.getSummaryField(VocabularyCModel.ATTRIBUTE_TYPE);
        if (summaryField != null && summaryField.getOldValue() != null) {
            XValue typeValue = summaryField.getOldValue();
            assert (typeValue != null);
            return typeValue;
        }
        XReadableObject xo = xmodel.getObject(objectId);
        assert (xo != null) : "object '" + objectId + "' not found";
        return XydraWrapper.getTypeValue(xo);
    }

    public XModel getXModel() {
        return this.xmodel;
    }

    @Override
    public boolean hasItemWithId(XId itemId) {
        XObject o = this.xmodel.getObject(itemId);
        if (o == null) {
            return false;
        }
        return this.getType(itemId) == VocabularyCModel.Type.Item;
    }

    public boolean isEmpty() {
        return this.xmodel.isEmpty();
    }

    public int itemCount() {
        return Iterators.count(this.items());
    }

    @Override
    public Iterator<IItem> items() {
        return Iterators.transform((Iterator)Iterators.filter(this.getAllXObjects(), FILTER_IS_ITEM), TRANSFORMER_XO2ITEM);
    }

    @Override
    public Iterator<XId> iterator() {
        return Iterators.filter((Iterator)this.xmodel.iterator(), HIDE_INTERNAL_IDS);
    }

    public static void refireXEventAsMyBaseEvents(XModel xmodel, ItemSetXy itemSet, XChangeLog changeLog, XTransactionEvent txnEvent, EventBus eventBus) {
        SummaryModel summaryModel = Summarizer.createTransactionSummary((XTransactionEvent)txnEvent, (XChangeLog)changeLog, (XReadableModel)xmodel);
        Iterator oIt = summaryModel.getChildren();
        while (oIt.hasNext()) {
            Map.Entry entry = (Map.Entry)oIt.next();
            SummaryObject summaryObject = (SummaryObject)entry.getValue();
            XydraWrapper.onChangedObject(xmodel, itemSet, (XId)entry.getKey(), summaryObject, eventBus);
        }
    }

    protected static void onChangedObject(XModel xmodel, ItemSetXy itemSet, XId objectId, SummaryObject summaryObject, EventBus eventBus) {
        XValue typeValue = XydraWrapper.getTypeValue((XReadableModel)xmodel, objectId, summaryObject);
        assert (typeValue != null);
        ChangeSummaryType cst = summaryObject.getChangeSummaryType();
        VocabularyCModel.Type type = XydraWrapper.getType(typeValue);
        block0 : switch (type) {
            case Item: {
                CBrowserRenderableContent newContent = null;
                CBrowserRenderableContent oldContent = null;
                switch (cst) {
                    case Added: {
                        newContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, false);
                        if (newContent == null) break;
                        ItemSets.fireContentUpdate(eventBus, objectId, null, newContent);
                        break;
                    }
                    case Neutral: {
                        oldContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, true);
                        newContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, false);
                        assert (oldContent != null || newContent != null);
                        ItemSets.fireContentUpdate(eventBus, objectId, oldContent, newContent);
                        break;
                    }
                    case Removed: {
                        oldContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, true);
                        ItemSets.fireContentUpdate(eventBus, objectId, oldContent, null);
                    }
                }
                break;
            }
            case Property: {
                CBrowserRenderableContent newContent = null;
                CBrowserRenderableContent oldContent = null;
                switch (cst) {
                    case Added: {
                        IProperty property = XydraWrapper.toProperty(xmodel, itemSet, summaryObject, objectId, false);
                        newContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, false);
                        if (newContent == null) break block0;
                        ItemSets.firePropertyEvent(eventBus, property, AtomicChangeType.Add, oldContent, newContent);
                        break;
                    }
                    case Neutral: {
                        IProperty property = XydraWrapper.toProperty(xmodel, itemSet, summaryObject, objectId, false);
                        oldContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, true);
                        newContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, false);
                        assert (oldContent != null || newContent != null);
                        ItemSets.firePropertyEvent(eventBus, property, AtomicChangeType.Change, oldContent, newContent);
                        break;
                    }
                    case Removed: {
                        IProperty property = XydraWrapper.toProperty(xmodel, itemSet, summaryObject, objectId, true);
                        oldContent = XydraWrapper.toBrec((XReadableModel)xmodel, summaryObject, objectId, true);
                        ItemSets.firePropertyEvent(eventBus, property, AtomicChangeType.Remove, oldContent, newContent);
                    }
                }
                break;
            }
            case Statement: {
                switch (cst) {
                    case Removed: {
                        IStatement statement = XydraWrapper.toStatement(xmodel, itemSet, summaryObject, objectId, true);
                        ItemSets.fireStatementEvent(eventBus, statement, AtomicChangeType.Remove);
                        break block0;
                    }
                    case Neutral: {
                        IStatement statement = XydraWrapper.toStatement(xmodel, itemSet, summaryObject, objectId, false);
                        ItemSets.fireStatementEvent(eventBus, statement, AtomicChangeType.Change);
                        break block0;
                    }
                    case Added: {
                        IStatement statement = XydraWrapper.toStatement(xmodel, itemSet, summaryObject, objectId, false);
                        ItemSets.fireStatementEvent(eventBus, statement, AtomicChangeType.Add);
                        break block0;
                    }
                }
                break;
            }
        }
    }

    private void onFieldEvent(XFieldEvent fieldEvent) {
        assert (this.eventBus != null);
        if (log.isTraceEnabled()) {
            log.trace("process property event " + fieldEvent);
        }
        XValue oldValue = null;
        if (fieldEvent.getChangeType() == ChangeType.REMOVE || fieldEvent.getChangeType() == ChangeType.CHANGE) {
            OldValues.getOldValue((XFieldEvent)fieldEvent, (XChangeLog)this.getChangeLog(), (XReadableModel)this.xmodel);
        }
        XValue newValue = fieldEvent.getNewValue();
        XId entityId = fieldEvent.getTarget().getObject();
        XId attId = fieldEvent.getChangedEntity().getField();
        ItemSets.fireAttributeUpdate(this.eventBus, entityId, attId, oldValue, newValue);
    }

    @Override
    public Iterator<IProperty> properties() {
        return Iterators.transform((Iterator)Iterators.filter(this.getAllXObjects(), FILTER_IS_PROPERTY), TRANSFORMER_XO2PROPERTY);
    }

    private boolean removeEntity(XId entityId, IChangeData changeData) {
        boolean success = true;
        Set<IStatement> stmts = this.itemSet.getStatementsFor(entityId, null, null);
        for (IStatement stmt : stmts) {
            log.info("Deleting *-- " + stmt);
            success &= this.deleteStatement(stmt.getId(), changeData);
        }
        stmts = this.itemSet.getStatementsFor(null, entityId, null);
        for (IStatement stmt : stmts) {
            log.info("Deleting -*- " + stmt);
            success &= this.deleteStatement(stmt.getId(), changeData);
        }
        stmts = this.itemSet.getStatementsFor(null, null, entityId);
        for (IStatement stmt : stmts) {
            log.info("Deleting --* " + stmt);
            success &= this.deleteStatement(stmt.getId(), changeData);
        }
        return success &= this.xmodel.removeObject(entityId);
    }

    public void removeEventListeners() {
        this.xmodel.removeListenerForFieldEvents(this.xmodel_field2itemmodel);
        this.xmodel.removeListenerForTransactionEvents(this.xmodel_txn2itemmodel);
    }

    public void setAllowedContentTypes(Collection<String> contentTypeStrings) {
        if (contentTypeStrings != null) {
            this.allowedContentTypes = new HashSet();
            this.allowedContentTypes.addAll(contentTypeStrings);
        } else {
            this.allowedContentTypes = null;
        }
    }

    public boolean setAttribute(XId attributeId, XValue attributeValue) {
        return XydraUtils.setFieldValue((XWritableObject)this.getOrCreateMetaObject(), (XId)attributeId, (XValue)attributeValue);
    }

    public boolean setContent(byte[] contentBytes, String contentTypeUri, XWritableObject xobject, long lastModified) {
        assert (contentBytes != null);
        assert (contentTypeUri != null);
        assert (lastModified != 0L);
        this.validateContentType(contentTypeUri);
        assert (xobject != null);
        WrapObject txnWrapper = new WrapObject(null, xobject);
        AttributeContentUtils.setContent((IHasAttributes)txnWrapper, (byte[])contentBytes, (String)contentTypeUri, (long)lastModified);
        return this.executeTransaction(txnWrapper);
    }

    public boolean setContent(String contentString, String contentTypeUri, XWritableObject xobject, long lastModified) {
        assert (contentString != null);
        assert (contentTypeUri != null);
        assert (lastModified != 0L);
        this.validateContentType(contentTypeUri);
        assert (xobject != null);
        WrapObject txnWrapper = new WrapObject(null, xobject);
        String cleanContent = TextTool.removeIllegalOrDiscouragedXml10Characters((String)contentString);
        AttributeContentUtils.setContent((IHasAttributes)txnWrapper, (String)cleanContent, (String)contentTypeUri, (long)lastModified);
        return this.executeTransaction(txnWrapper);
    }

    public boolean setContent(XValue contentValue, String contentTypeUri, XWritableObject xobject, long lastModified) {
        assert (contentValue != null);
        assert (contentTypeUri != null);
        assert (lastModified != 0L);
        this.validateContentType(contentTypeUri);
        assert (xobject != null);
        WrapObject txnWrapper = new WrapObject(null, xobject);
        AttributeContentUtils.setContent((IHasAttributes)txnWrapper, (XValue)contentValue, (String)contentTypeUri, (long)lastModified);
        return this.executeTransaction(txnWrapper);
    }

    public int statementCount() {
        return Iterators.count(this.statements());
    }

    @Override
    public Iterator<IStatement> statements() {
        return Iterators.transform((Iterator)Iterators.filter(this.getAllXObjects(), FILTER_IS_STATEMENT), TRANSFORMER_XO2STATEMENT);
    }

    public static CBrowserRenderableContent toBrec(XReadableModel xmodel, SummaryObject so, XId objectId, boolean remove) {
        XReadableObject xo = xmodel.getObject(objectId);
        XValue contentValue = so.getFieldValue(xo, VocabularyCModel.ATTRIBUTE_CONTENT_VALUE, remove);
        if (contentValue == null) {
            return null;
        }
        assert (contentValue != null) : so;
        if (contentValue.getType() == ValueType.String) {
            XValue contentTypeUriValue = so.getFieldValue(xo, VocabularyCModel.ATTRIBUTE_CONTENT_TYPE_URI, remove);
            return new MemoryBrec(contentValue.toString(), contentTypeUriValue.toString());
        }
        if (contentValue.getType() == ValueType.String) {
            XValue contentTypeUriValue = so.getFieldValue(xo, VocabularyCModel.ATTRIBUTE_CONTENT_TYPE_URI, remove);
            return new MemoryBrec(((XBinaryValue)contentValue).getValue(), contentTypeUriValue.toString());
        }
        return new BrecNativeXydraValue(contentValue);
    }

    public String toDebugString() {
        return DumpUtilsBase.toStringBuffer((XReadableModel)this.xmodel).toString();
    }

    public static SimpleObject toSimpleObject(XReadableModel xmodel, XId objectId, XReadableObject xo, SummaryObject so, boolean remove) {
        XAddress objectAddress = Base.resolveObject((XAddress)xmodel.getAddress(), (XId)objectId);
        SimpleObject simpleObject = new SimpleObject(objectAddress);
        for (Map.Entry e : so.getSummaryFields()) {
            XId fieldId = (XId)e.getKey();
            XValue value = so.getFieldValue(xo, fieldId, remove);
            simpleObject.createField(fieldId).setValue(value);
        }
        return simpleObject;
    }

    public static IProperty toProperty(XModel xmodel, ItemSetXy itemSet, SummaryObject so, XId objectId, boolean remove) {
        XObject xo = xmodel.getObject(objectId);
        if (remove) {
            SimpleObject simpleObject = XydraWrapper.toSimpleObject((XReadableModel)xmodel, objectId, (XReadableObject)xo, so, remove);
            return new PropertyXy(itemSet, (XWritableObject)simpleObject);
        }
        return new PropertyXy(itemSet, (XWritableObject)xo);
    }

    public static IStatement toStatement(XModel xmodel, ItemSetXy itemSet, SummaryObject so, XId objectId, boolean remove) {
        XObject xo = xmodel.getObject(objectId);
        if (remove) {
            SimpleObject simpleObject = XydraWrapper.toSimpleObject((XReadableModel)xmodel, objectId, (XReadableObject)xo, so, remove);
            return new StatementXy(itemSet, (XWritableObject)simpleObject);
        }
        return new StatementXy(itemSet, (XWritableObject)xo);
    }

    private void validateContentType(String contentTypeId) {
        IContentType contentType;
        boolean valid = this.allowedContentTypes == null ? (contentType = ContentTypes.parseContentTypeIdentifier((String)contentTypeId)) != null : this.allowedContentTypes.contains(contentTypeId);
        if (!valid) {
            throw new RuntimeException("Content type not set as allowed type: '" + contentTypeId + "'");
        }
    }

    private static XyFactory createFactory() {
        IConfig conf = Env.get().conf();
        XId repositoryId = (XId)conf.getAs("mybase-repoId", XId.class);
        XId actorId = ConfParamsItemSet._ACTOR_LOCALHOST;
        String passwordHash = "localhost";
        XyFactory factory = new XyFactory(repositoryId, actorId, "localhost");
        return factory;
    }

    public void setModel(XModel model) {
        assert (model != null);
        if (this.xmodel != null) {
            this.disconnectEventListeners(this.xmodel);
        }
        this.xmodel = model;
        this.connectEventListeners(model);
    }

    public void setChangeRecordMode(ISyncLog.ChangeRecordMode changeRecordMode) {
        assert (this.xmodel != null);
        this.xmodel.getRoot().setChangeRecordMode(changeRecordMode);
    }

    public void clearXModelAndChangeLog() {
        assert (this.xmodel != null) : "otherwise clear makes no sense";
        this.factory.clearRepository();
        XModel model = this.createXModel();
        this.setModel(model);
    }

    public XModel createXModel() {
        MemoryRepository repo = this.factory.getRepository();
        IConfig conf = Env.get().conf();
        XId modelId = (XId)conf.getAs("mainModelId", XId.class);
        XModel model = repo.createModel(modelId);
        return model;
    }

    public void setItemSet(ItemSetXy itemSetXy) {
        this.itemSet = itemSetXy;
    }

    public void renameIds(Map<XId, XId> rename) {
        RenameUtils.renameIds(this.xmodel, rename);
    }

    public void refireEvents(boolean contentUpdateEvents, boolean statementEvents, boolean propertyEvents, boolean attributeEvents) {
        Iterator<XId> entityIt = this.iterator();
        long events = 0L;
        while (entityIt.hasNext()) {
            XId entityId = entityIt.next();
            IEntity entity = this.getEntityById(entityId);
            if (entity instanceof IItem) {
                IItem item = (IItem)entity;
                CBrowserRenderableContent content = item.getContent();
                if (content != null) {
                    ItemSets.fireContentUpdate(this.eventBus, entityId, null, content);
                }
            } else if (entity instanceof IStatement) {
                ItemSets.fireStatementEvent(this.eventBus, (IStatement)entity, AtomicChangeType.Add);
            } else if (entity instanceof IProperty) {
                IProperty prop = (IProperty)entity;
                ItemSets.firePropertyEvent(this.eventBus, prop, AtomicChangeType.Add, null, prop.getContent());
            } else {
                throw new AssertionError();
            }
            Iterator attIt = entity.attributes();
            while (attIt.hasNext()) {
                XId attId = (XId)attIt.next();
                XValue attVal = entity.getAttribute(attId);
                ItemSets.fireAttributeUpdate(this.eventBus, entityId, attId, null, attVal);
            }
            if (++events % 1000L != 0L) continue;
            log.info("Replayed events: " + events);
        }
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void indexAsNewStatement(XId s, XId p, XId o, IChangeData changeData, Map<XId, XValue> attributes) {
        assert (s != null);
        assert (p != null);
        assert (o != null);
        assert (changeData != null);
        XId statementId = this.itemSet.factory().createId();
        StatementXy stmt = this.createStatement(statementId, s, p, o, changeData);
        if (attributes != null) {
            for (Map.Entry<XId, XValue> e : attributes.entrySet()) {
                stmt.setAttribute(e.getKey(), e.getValue());
            }
        }
    }

    private StatementXy createStatement(XId statementId, XId s, XId p, XId o, IChangeData changeData) {
        WrapObject wo = this.createAndAddObject(statementId);
        StatementXy stmt = StatementXy.create(this.itemSet, wo);
        stmt.setEntityMetaData(changeData);
        stmt.setSPO(s, p, o);
        this.executeTransaction(wo);
        stmt = this.getStatementById(statementId);
        return stmt;
    }

    public int entityCount() {
        return Iterators.count(this.iterator());
    }
}

