/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl.xydra;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.base.Base;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableField;
import org.xydra.base.rmof.XReadableObject;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XAddressListValue;
import org.xydra.base.value.XAddressSetValue;
import org.xydra.base.value.XAddressSortedSetValue;
import org.xydra.base.value.XIdListValue;
import org.xydra.base.value.XIdSetValue;
import org.xydra.base.value.XIdSortedSetValue;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.core.XCopyUtils;
import org.xydra.core.model.XField;
import org.xydra.core.model.XModel;
import org.xydra.core.model.XObject;
import org.xydra.index.iterator.Iterators;

public class RenameUtils {
    public static void renameIds(XModel xm, Map<XId, XId> rename) {
        Set oIds = Iterators.toSet((Iterator)xm.iterator());
        for (XId oId : oIds) {
            if (rename.containsKey(oId)) {
                XObject xoOld = xm.getObject(oId);
                xm.removeObject(oId);
                XObject xoNew = xm.createObject(rename.get(oId));
                XCopyUtils.copyData((XReadableObject)xoOld, (XWritableObject)xoNew);
                RenameUtils.renameIds(xoNew, rename);
                continue;
            }
            RenameUtils.renameIds(xm.getObject(oId), rename);
        }
    }

    public static void renameIds(XObject xo, Map<XId, XId> rename) {
        Set fIds = Iterators.toSet((Iterator)xo.iterator());
        for (XId fId : fIds) {
            if (rename.containsKey(fId)) {
                XField xfOld = xo.getField(fId);
                xo.removeField(fId);
                XField xfNew = xo.createField(rename.get(fId));
                XCopyUtils.copyData((XReadableField)xfOld, (XWritableField)xfNew);
                RenameUtils.renameIds(xfNew, rename);
                continue;
            }
            RenameUtils.renameIds(xo.getField(fId), rename);
        }
    }

    public static XAddress renameIds(XAddress xa, Map<XId, XId> rename) {
        XId rId = rename.get(xa.getRepository());
        XId mId = rename.get(xa.getModel());
        XId oId = rename.get(xa.getObject());
        XId fId = rename.get(xa.getField());
        if (rId != null || mId != null || oId != null || fId != null) {
            if (rId == null) {
                rId = xa.getRepository();
            }
            if (mId == null) {
                mId = xa.getModel();
            }
            if (oId == null) {
                oId = xa.getObject();
            }
            if (fId == null) {
                fId = xa.getField();
            }
            XAddress xaNew = Base.toAddress((XId)rId, (XId)mId, (XId)oId, (XId)fId);
            return xaNew;
        }
        return null;
    }

    public static void renameIds(XField xf, Map<XId, XId> rename) {
        XValue xv = xf.getValue();
        switch (xv.getType()) {
            case Address: {
                XAddress xa = (XAddress)xv;
                XAddress xaNew = RenameUtils.renameIds(xa, rename);
                if (xaNew == null) break;
                xf.setValue((XValue)xaNew);
                break;
            }
            case AddressList: {
                XAddressListValue valueOld;
                XAddressListValue valueNew = valueOld = (XAddressListValue)xv;
                boolean change = false;
                for (int i = 0; i < valueOld.size(); ++i) {
                    XAddress xa = (XAddress)valueOld.get(i);
                    XAddress xaNew = RenameUtils.renameIds(xa, rename);
                    if (xaNew == null) continue;
                    change = true;
                    valueNew = valueNew.remove(i);
                    valueNew = valueNew.add(i, xaNew);
                }
                if (!change) break;
                xf.setValue((XValue)valueNew);
                break;
            }
            case AddressSet: {
                XAddressSetValue valueOld;
                XAddressSetValue valueNew = valueOld = (XAddressSetValue)xv;
                boolean change = false;
                for (XAddress xa : valueOld) {
                    XAddress xaNew = RenameUtils.renameIds(xa, rename);
                    if (xaNew == null) continue;
                    change = true;
                    valueNew = valueNew.remove(xa);
                    valueNew = valueNew.add(xaNew);
                }
                if (!change) break;
                xf.setValue((XValue)valueNew);
                break;
            }
            case AddressSortedSet: {
                XAddressSortedSetValue valueOld = (XAddressSortedSetValue)xv;
                ArrayList<XAddress> values = new ArrayList<XAddress>();
                boolean change = false;
                for (XAddress xa : valueOld) {
                    XAddress xaNew = RenameUtils.renameIds(xa, rename);
                    if (xaNew != null) {
                        change = true;
                        values.add(xaNew);
                        continue;
                    }
                    values.add(xa);
                }
                if (!change) break;
                XAddressSortedSetValue valueNew = XV.toAddressSortedSetValue(values);
                xf.setValue((XValue)valueNew);
                break;
            }
            case Id: {
                if (!rename.containsKey(xv)) break;
                xf.setValue((XValue)rename.get(xv));
                break;
            }
            case IdList: {
                XIdListValue valueOld;
                XIdListValue valueNew = valueOld = (XIdListValue)xv;
                boolean change = false;
                for (int i = 0; i < valueOld.size(); ++i) {
                    XId id = (XId)valueOld.get(i);
                    if (!rename.containsKey(id)) continue;
                    change = true;
                    valueNew = valueNew.remove(i);
                    valueNew = valueNew.add(i, id);
                }
                if (!change) break;
                xf.setValue((XValue)valueNew);
                break;
            }
            case IdSet: {
                XIdSetValue valueOld;
                XIdSetValue valueNew = valueOld = (XIdSetValue)xv;
                boolean change = false;
                for (XId id : valueOld) {
                    if (!rename.containsKey(id)) continue;
                    change = true;
                    valueNew = valueNew.remove(id);
                    valueNew = valueNew.add(id);
                }
                if (!change) break;
                xf.setValue((XValue)valueNew);
                break;
            }
            case IdSortedSet: {
                XIdSortedSetValue valueOld = (XIdSortedSetValue)xv;
                ArrayList<XId> values = new ArrayList<XId>();
                boolean change = false;
                for (XId id : valueOld) {
                    if (rename.containsKey(id)) {
                        change = true;
                        values.add(rename.get(id));
                        continue;
                    }
                    values.add(id);
                }
                if (!change) break;
                XIdSortedSetValue valueNew = XV.toIdSortedSetValue(values);
                xf.setValue((XValue)valueNew);
                break;
            }
        }
    }
}

