/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl.xydra;

import de.xam.cmodel.content.CWritableBrowserRenderableContent;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.cmodel.util.XydraUtils;
import de.xam.itemset.IItem;
import de.xam.itemset.impl.xydra.AbstractContentEntityXy;
import de.xam.itemset.impl.xydra.ItemSetXy;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ItemXy
extends AbstractContentEntityXy
implements IItem,
CWritableBrowserRenderableContent {
    private static final Logger log = LoggerFactory.getLogger(ItemXy.class);

    public static ItemXy create(ItemSetXy itemModelXy, XWritableObject o) {
        ItemXy item = ItemXy.wrap(itemModelXy, o);
        item.setType(VocabularyCModel.Type.Item);
        return item;
    }

    public static ItemXy wrap(ItemSetXy itemModelXy, XWritableObject o) {
        ItemXy item = new ItemXy(itemModelXy, o);
        return item;
    }

    private ItemXy(ItemSetXy model, XWritableObject object) {
        super(model, object);
    }

    public long length() {
        XValue value = this.getAttribute(VocabularyCModel.ATTRIBUTE_CONTENT_LENGTH);
        return XydraUtils.toLong((XValue)value);
    }

    protected void setByteValue(XId fieldId, byte[] bytes) {
        this.setAttribute(fieldId, (XValue)XV.toValue((byte[])bytes));
    }

    @Override
    public String toDebugString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(this.getId());
        b.append("]='");
        b.append(this.getDisplayString());
        b.append("'");
        Iterator<XId> pIt = this.attributes();
        while (pIt.hasNext()) {
            XId p = pIt.next();
            b.append("\n* ");
            b.append(p);
            b.append(" = '");
            XValue value = this.getAttribute(p);
            b.append(value);
            b.append("' (");
            b.append((Object)(value == null ? "NULL" : value.getType()));
            b.append(")");
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(this.getId());
        b.append("]='");
        b.append(this.getDisplayString());
        b.append("'");
        if (this.isReference()) {
            b.append("REF");
        } else {
            b.append("SYM");
        }
        return b.toString();
    }

    public boolean isReference() {
        return XydraUtils.getProperty((XWritableObject)this.xobject, (XId)VocabularyCModel.ATTRIBUTE_VALUE_IS_REFERENCE_VALUE) != null;
    }

    @Override
    public void setIsReference(boolean isReference) {
        XydraUtils.setFieldValue((XWritableObject)this.xobject, (XId)VocabularyCModel.ATTRIBUTE_VALUE_IS_REFERENCE_VALUE, (XValue)XV.toValue((boolean)isReference));
    }

    @Override
    public String getDisplayString() {
        String s = this.getContent().getContentAsString();
        if (s != null) {
            return s;
        }
        log.warn("Item id '" + this.getId() + "' has no string content");
        return this.getId().toString();
    }
}

