/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl;

import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.IHasAttributes;
import de.xam.cmodel.fact.IHasReadableAttributes;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.itemset.Attributes;
import de.xam.itemset.CDS;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IItemSetSource;
import de.xam.itemset.IItemSink;
import de.xam.itemset.IStatement;
import de.xam.itemset.VocabularyItemSet;
import de.xam.itemset.impl.ItemSets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Items {
    private static final Logger log = LoggerFactory.getLogger(Items.class);

    public static String getContentTypeUri(IItem ittem) {
        return Attributes.getStringAttribute(ittem, VocabularyCModel.ATTRIBUTE_CONTENT_TYPE_URI);
    }

    public static String getDisplayString(IItemSet itemSet, XId itemId) {
        IItem item = itemSet.getItemById(itemId);
        if (item == null) {
            return null;
        }
        return item.getContent().getContentAsString();
    }

    public static void setContentString(IItem item, String content, long lastModified) {
        assert (content != null);
        item.getWritableContent().setContent((XValue)XV.toValue((String)content), lastModified);
    }

    public static String toDebugString(XValue value) {
        if (value == null) {
            return "<code>null</code>";
        }
        String s = value.toString();
        if (s.contains("\n")) {
            return "{{{" + s + "}}}";
        }
        return s;
    }

    public static void copy(IItemSetSource itemSource, IItemSink itemSink) {
        Iterator<IItem> itemIt = itemSource.items();
        while (itemIt.hasNext()) {
            IItem item = itemIt.next();
            try {
                itemSink.addItem(item);
            }
            catch (IllegalArgumentException e) {}
        }
        Iterator<IStatement> stmtIt = itemSource.statements();
        while (stmtIt.hasNext()) {
            IStatement stmt = stmtIt.next();
            itemSink.addStatement(stmt);
        }
        Iterator attIt = itemSource.attributes();
        while (attIt.hasNext()) {
            XId attId = (XId)attIt.next();
            XValue attValue = itemSource.getAttribute(attId);
            itemSink.setAttribute(attId, attValue);
        }
    }

    public static void copyAttributes(IHasReadableAttributes source, IHasAttributes target) {
        Iterator attIt = source.attributes();
        while (attIt.hasNext()) {
            XId attId = (XId)attIt.next();
            XValue value = source.getAttribute(attId);
            target.setAttribute(attId, value);
        }
    }

    public static String getAttributeValue(IItem item, XId attributeId) {
        XValue value = item.getAttribute(attributeId);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean canBeDeleted(IEntity entity) {
        boolean isDeleteProtected = Attributes.getBooleanAttribute(entity, VocabularyItemSet.ATTRIBUTE_ACCESS_IS_DELETE_PROTECTED);
        return !isDeleteProtected;
    }

    public static void setIsDeleteProtected(IItem item, boolean isDeleteProtected) {
        Attributes.setBooleanAttribute(item, VocabularyItemSet.ATTRIBUTE_ACCESS_IS_DELETE_PROTECTED, isDeleteProtected);
    }

    public static void addType(IItem item, XId type, IChangeData changeData) {
        ItemSets.addRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasType, type, changeData);
    }

    public static void addLinkTarget(IItem item, XId targetId, IChangeData changeData) {
        ItemSets.addRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasTarget, targetId, changeData);
    }

    public static void removeLinkTarget(IItem item, XId targetId, IChangeData changeData) {
        ItemSets.removeRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasTarget, targetId, changeData);
    }

    public static void addAutoLinkTarget(IItem item, XId targetId, IChangeData changeData) {
        ItemSets.addRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasAutoLinkTarget, targetId, changeData);
    }

    public static void removeAutoLinkTarget(IItem item, XId targetId, IChangeData changeData) {
        ItemSets.removeRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasAutoLinkTarget, targetId, changeData);
    }

    public static void addManualLinkTarget(IItem item, XId targetId, IChangeData changeData) {
        ItemSets.addRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasManualLinkTarget, targetId, changeData);
    }

    public static void removeManualLinkTarget(IItem item, XId targetId, IChangeData changeData) {
        ItemSets.removeRelated(item.itemSet(), item.getId(), (XId)CDS.INSTANCE.hasManualLinkTarget, targetId, changeData);
    }

    public static boolean hasType(IItem item, XId type) {
        return item.hasRelated((XId)CDS.INSTANCE.hasType, type);
    }

    public static Map<XId, XValue> getPropertiesAsMap(IItem item) {
        HashMap<XId, XValue> map = new HashMap<XId, XValue>();
        Iterator<XId> it = item.properties();
        while (it.hasNext()) {
            XId propertyId = it.next();
            XValue value = item.getProperty(propertyId);
            if (value == null) continue;
            map.put(propertyId, value);
        }
        return map;
    }

    public static Map<XId, XValue> getAttributesAsMap(IItem item) {
        HashMap<XId, XValue> map = new HashMap<XId, XValue>();
        Iterator it = item.attributes();
        while (it.hasNext()) {
            XId attId = (XId)it.next();
            XValue value = item.getAttribute(attId);
            if (value == null) continue;
            map.put(attId, value);
        }
        return map;
    }

    public static IItem getOrCreateItemWithId(IItemSet itemSet, XId id, String contentString, IChangeData changeData) {
        IItem item = itemSet.getItemById(id);
        if (item == null) {
            item = contentString == null ? itemSet.getOrCreateAndAddItem(id, changeData) : ItemSets.createItemWithStringContent(itemSet, id, contentString, changeData);
        }
        return item;
    }

    public static long getChangeDateUTC(IEntity entity) {
        return ChangeDatas.getLastCreationOrModifiedDate((IChangeData)entity.getChangeData());
    }
}

