/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl;

import de.xam.cmodel.fact.IChangeData;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IStatement;
import de.xam.p13n.shared.time.TimeProvider;
import java.util.Map;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.index.IRemovableTripleSink;

public class ItemSetRemovableTripleSinkAdapter
implements IRemovableTripleSink<XId, XId, XId> {
    private final IItemSet itemSet;
    private final Map<XId, XValue> attributes;
    private final String createdBy;
    private final String creationSource;

    public static ItemSetRemovableTripleSinkAdapter create(IItemSet itemSet, String createdBy, String creationSource, Map<XId, XValue> attributes) {
        return new ItemSetRemovableTripleSinkAdapter(itemSet, createdBy, creationSource, attributes);
    }

    private IChangeData createCurrentChangeData() {
        final long now = TimeProvider.getCurrentTimeInMillis();
        return new IChangeData(){

            public long getLastModifiedUTC() {
                return now;
            }

            public String getCreationSource() {
                return ItemSetRemovableTripleSinkAdapter.this.creationSource;
            }

            public long getCreationDateUTC() {
                return now;
            }

            public String getCreatedBy() {
                return ItemSetRemovableTripleSinkAdapter.this.createdBy;
            }
        };
    }

    public ItemSetRemovableTripleSinkAdapter(IItemSet itemSet, String createdBy, String creationSource, Map<XId, XValue> attributes) {
        this.itemSet = itemSet;
        this.createdBy = createdBy;
        this.creationSource = creationSource;
        this.attributes = attributes;
    }

    public boolean deIndex(XId s, XId p, XId o) {
        boolean removed = false;
        for (IStatement stmt : this.itemSet.getStatementsFor(s, p, o)) {
            removed |= this.itemSet.deleteStatement(stmt.getId(), this.createCurrentChangeData());
        }
        return removed;
    }

    public boolean index(XId s, XId p, XId o) {
        IChangeData changeData = this.createCurrentChangeData();
        this.itemSet.indexAsNewStatement(s, p, o, changeData, this.attributes);
        return true;
    }
}

