/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics.logsink;

import de.xam.googleanalytics.FocusPoint;
import de.xam.googleanalytics.GaEvent;
import de.xam.googleanalytics.Tracker;
import de.xam.googleanalytics.UrlAndHashUtils;
import de.xam.googleanalytics.UserInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.xydra.log.api.ILogListener;
import org.xydra.log.api.Logger;

public class GALogListener
implements ILogListener,
UserInfo {
    private final long currentSessionStartTime = UrlAndHashUtils.getCurrentTimeInSeconds();
    private final String domainName;
    private final long thirtyOneBitId = UrlAndHashUtils.random31bitInteger();
    private final Tracker tracker;
    public static final String GA_URI = "GA?";

    public GALogListener(String trackerCode, String domainName) {
        this.tracker = new Tracker(trackerCode);
        this.domainName = domainName;
    }

    public void debug(Logger log, String msg) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "info", msg);
        }
    }

    public void debug(Logger log, String msg, Throwable t) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "info", msg);
        }
    }

    public void error(Logger log, String msg) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "error", msg);
        }
    }

    public void error(Logger log, String msg, Throwable t) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "error", msg);
        }
    }

    @Override
    public long get31BitId() {
        return this.thirtyOneBitId;
    }

    @Override
    public long getCurrentSessionStartTime() {
        return this.currentSessionStartTime;
    }

    @Override
    public String getDomainName() {
        return this.domainName;
    }

    @Override
    public long getFirstVisitStartTime() {
        return this.currentSessionStartTime;
    }

    @Override
    public String getHostName() {
        String hostname = "(not set)";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    @Override
    public long getLastVisitStartTime() {
        return this.currentSessionStartTime;
    }

    @Override
    public long getSessionCount() {
        return 1L;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    @Override
    public String getVar() {
        return null;
    }

    public void info(Logger log, String msg) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "info", msg);
        }
    }

    public void info(Logger log, String msg, Throwable t) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "info", msg);
        }
    }

    public void trace(Logger log, String msg) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "info", msg);
        }
    }

    public void trace(Logger log, String msg, Throwable t) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "info", msg);
        }
    }

    private void track(Logger log, GaEvent gaEvent) {
        this.tracker.track(new FocusPoint(log.toString()), "-", this, gaEvent);
    }

    private void trackData(Logger log, String logLevel, String msg) {
        assert (GALogListener.hasGaData(msg));
        String dataPart = msg.substring(msg.indexOf(GA_URI) + GA_URI.length());
        Map<String, String> dataMap = GALogListener.parseQueryString(dataPart);
        String category = dataMap.get("category");
        assert (category != null);
        String action = dataMap.get("action");
        assert (action != null);
        String optionalLabel = dataMap.get("label");
        String optionalValue = dataMap.get("value");
        int value = -1;
        if (optionalValue != null) {
            value = Integer.parseInt(optionalValue);
        }
        GaEvent gaEvent = optionalLabel == null ? new GaEvent(category, action) : (value == -1 ? new GaEvent(category, action, optionalLabel) : new GaEvent(category, action, optionalLabel, value));
        this.track(log, gaEvent);
    }

    public void warn(Logger log, String msg) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "warn", msg);
        }
    }

    public void warn(Logger log, String msg, Throwable t) {
        if (GALogListener.hasGaData(msg)) {
            this.trackData(log, "warn", msg);
        }
    }

    public static boolean hasGaData(String s) {
        return s.contains(GA_URI);
    }

    public static Map<String, String> parseQueryString(String q) {
        String[] pairs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : pairs = q.split("\\&")) {
            String[] parts = s.split("=");
            String key = parts[0];
            String value = parts.length > 1 ? parts[1] : null;
            map.put(key, value);
        }
        return map;
    }
}

