/*
 * Decompiled with CFR 0.152.
 */
package de.xam.googleanalytics;

import de.xam.googleanalytics.FocusPoint;
import de.xam.googleanalytics.GaEvent;
import de.xam.googleanalytics.UrchinCookie;
import de.xam.googleanalytics.UrchinUrl;
import de.xam.googleanalytics.UserInfo;
import de.xam.googleanalytics.httpclient.HttpUserAgent;
import de.xam.googleanalytics.httpclient.HttpUserAgentFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Tracker {
    public static final String CLIENT_ID = "$Revision: 10175 $".replace(" ", "_");
    public static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    public static final String HTTP_HEADER_USER_AGENT = "User-agent";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static String USER_AGENT;
    private static Logger log;
    private final String trackerCode;
    private int trackCount = 0;
    private final HttpUserAgent httpClient;
    boolean warnedAbout500Events = false;

    public String getTrackerCode() {
        return this.trackerCode;
    }

    public Tracker(String trackerCode) {
        this.trackerCode = trackerCode;
        this.httpClient = HttpUserAgentFactory.createHttpUserAgent();
        this.httpClient.setUserAgentIdentifier(USER_AGENT);
        this.httpClient.setConnectionTimeout(5000);
        this.httpClient.setAutoRetry(false);
    }

    public String trackLowLevel(String hostname, FocusPoint focusPoint, String refererURL, String cookie, GaEvent gaEvent) {
        ++this.trackCount;
        String url = UrchinUrl.toURL(hostname, focusPoint, refererURL, cookie, this.trackerCode, gaEvent, this.trackCount);
        Future<Integer> result = this.httpClient.GET(url);
        if (this.trackCount % 50 == 10) {
            log.debug("Verifying HTTP GET to Google Analytics");
            try {
                result.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                log.warn("Could not finish HTTP GET", (Throwable)e);
            }
            catch (TimeoutException e) {
                log.warn("Could not finish HTTP GET in time", (Throwable)e);
            }
        }
        if (this.trackCount > 500 && !this.warnedAbout500Events) {
            log.warn("Sent over 500 requests in this session to Google Analytics - they don't track more");
            this.warnedAbout500Events = true;
        }
        return url;
    }

    public void track(FocusPoint focusPoint, String refererURL, UserInfo userinfo, GaEvent gaEvent) {
        log.debug("Tracking asynchronously focusPoint=" + focusPoint.getContentTitle());
        assert (userinfo.getDomainName() != null);
        UrchinCookie cookie = new UrchinCookie(userinfo);
        String hostname = userinfo.getHostName();
        this.trackLowLevel(hostname, focusPoint, refererURL, cookie.getCookieString(), gaEvent);
    }

    static {
        String osShortName = OS_NAME.contains("Windows") ? "Windows" : (OS_NAME.contains("Mac OS") ? "Macintosh" : (OS_NAME.contains("nix") || OS_NAME.contains("nux") ? "Linux" : "UnknownOS"));
        USER_AGENT = "Tracker/" + CLIENT_ID + " (" + osShortName + "; " + OS_VERSION + ")";
        log = LoggerFactory.getLogger(Tracker.class);
    }
}

