/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.jetty;

import org.eclipse.jetty.util.log.AbstractLogger;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class JettyLog2XydraLogger
extends AbstractLogger {
    private final Logger log;

    private static String format(String msg, Object ... args) {
        String message = String.valueOf(msg);
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = message.indexOf("{}", start);
            if (bracesIndex < 0) {
                builder.append(message.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = message.length();
                continue;
            }
            builder.append(message.substring(start, bracesIndex));
            builder.append(String.valueOf(arg));
            start = bracesIndex + "{}".length();
        }
        builder.append(message.substring(start));
        return builder.toString();
    }

    public JettyLog2XydraLogger(String fullname) {
        this.log = LoggerFactory.getThreadSafeLogger((String)fullname);
    }

    public void debug(String msg, Object ... args) {
        this.log.debug(msg);
    }

    public void debug(String msg, Throwable t) {
        this.log.debug(msg, t);
    }

    public void debug(Throwable thrown) {
        this.log.debug("No message", thrown);
    }

    public String getName() {
        return this.log.getName();
    }

    public void ignore(Throwable ignored) {
        this.log.debug("Ignored this error", ignored);
    }

    public void info(String msg, Object ... args) {
        this.log.info(JettyLog2XydraLogger.format(msg, args));
    }

    public void info(Throwable thrown) {
        this.log.info("No message", thrown);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    protected org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        return new JettyLog2XydraLogger(fullname);
    }

    public void setDebugEnabled(boolean enabled) {
        this.log.setLevel(Logger.Level.Debug);
    }

    public void warn(String msg, Object ... args) {
        this.log.warn(JettyLog2XydraLogger.format(msg, args));
    }

    public void warn(String msg, Throwable thrown) {
        this.log.warn(msg, thrown);
    }

    public void warn(Throwable thrown) {
        this.log.warn("No message", thrown);
    }

    public void info(String msg, Throwable thrown) {
        this.log.info(msg, thrown);
    }
}

