/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.jetty;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.xydra.env.Env;
import org.xydra.jetty.EmbeddedJetty;
import org.xydra.jetty.JettyUtils;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.utils.Delay;

public class Jetty
extends EmbeddedJetty {
    private static Logger log = LoggerFactory.getLogger(Jetty.class);
    private Filter userFirstFilter;
    private final Filter imageCachingFilter = JettyUtils.createOneYearCachingFilter();
    private final Filter noGwtCachingFilter = JettyUtils.createNoCacheFilter();
    private final Filter requestCountingFilter = JettyUtils.createRequestCountingFilter();
    private final Filter simulateNetworkDelaysFilter = JettyUtils.createSimulateNetworkDelaysFilter();

    public Jetty() {
        this(8080);
    }

    public Jetty(int port) {
        Env.get().conf().set("jetty-port", (Object)port);
    }

    @Override
    protected void configureWebapp(WebAppContext webappContext) {
        FilterHolder filterHolder;
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        webappContext.setClassLoader(classloader);
        if (this.userFirstFilter != null) {
            filterHolder = new FilterHolder();
            filterHolder.setFilter(this.userFirstFilter);
            webappContext.addFilter(filterHolder, "*", EnumSet.allOf(DispatcherType.class));
        }
        filterHolder = new FilterHolder();
        filterHolder.setFilter(this.imageCachingFilter);
        webappContext.addFilter(filterHolder, "*.png", EnumSet.allOf(DispatcherType.class));
        webappContext.addFilter(filterHolder, "*.gif", EnumSet.allOf(DispatcherType.class));
        FilterHolder gwtFilterHolder = new FilterHolder();
        gwtFilterHolder.setFilter(this.noGwtCachingFilter);
        webappContext.addFilter(gwtFilterHolder, "*.nocache.js", EnumSet.allOf(DispatcherType.class));
        FilterHolder filterHolderForCounting = new FilterHolder();
        filterHolderForCounting.setFilter(this.requestCountingFilter);
        webappContext.addFilter(filterHolderForCounting, "*", EnumSet.allOf(DispatcherType.class));
        if (Delay.hasServePageDelay()) {
            FilterHolder filterHolderForDelay = new FilterHolder();
            filterHolderForDelay.setFilter(this.simulateNetworkDelaysFilter);
            webappContext.addFilter(filterHolderForDelay, "*", EnumSet.allOf(DispatcherType.class));
        }
        webappContext.getSecurityHandler().setLoginService(JettyUtils.createInsecureTestLoginService());
        FilterHolder filterHolderForStaticContent = new FilterHolder();
        filterHolderForStaticContent.setFilter(new Filter(){

            public void destroy() {
            }

            public void doFilter(ServletRequest req, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
                if (req instanceof HttpServletRequest) {
                    HttpServletRequest hreq = (HttpServletRequest)req;
                    String path = hreq.getPathInfo();
                    if (path == null) {
                        path = "";
                    }
                    if ((path = path.toLowerCase()).contains("favicon.ico")) {
                        log.info("JETTY Blocked: " + hreq.getRequestURL());
                    } else {
                        filterChain.doFilter(req, response);
                    }
                } else {
                    filterChain.doFilter(req, response);
                }
            }

            public void init(FilterConfig filterConfig) {
            }
        });
        webappContext.addFilter(filterHolderForStaticContent, "*", EnumSet.allOf(DispatcherType.class));
    }

    public void setFirstFilter(Filter filter) {
        this.userFirstFilter = filter;
    }
}

