/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.jetty;

import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.Slf4jLog;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.xydra.conf.IConfig;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.utils.HostUtils;

public abstract class EmbeddedJetty {
    protected String contextPath;
    protected String docRootURL;
    private Server server;
    private int port;
    protected long startTime;
    private final WebAppContext webapp = new WebAppContext();
    private static final org.xydra.log.api.Logger log = LoggerFactory.getLogger(EmbeddedJetty.class);

    public synchronized void configureFromConf(IConfig conf) {
        assert (conf != null);
        this.port = conf.getInt("jetty-port");
        this.contextPath = conf.getString("jetty-contextpath");
        this.docRootURL = conf.getString("jetty-docroot");
        if (conf.tryToGet("restless-useDefaultServlet") == Boolean.TRUE) {
            Restless.DELEGATE_UNHANDLED_TO_DEFAULT = true;
        }
        try {
            Log.setLog((Logger)new Slf4jLog());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String serverVersion = Server.getVersion();
        log.info("Mapped Jetty logging to global logging. Expect '" + serverVersion + "' as next line");
    }

    public URI startServer() {
        Resource base;
        assert (this.server == null);
        if (!this.isConfigured()) {
            throw new IllegalStateException("configure(...) first");
        }
        this.server = new Server(this.port);
        this.webapp.setCopyWebDir(false);
        this.webapp.setCopyWebInf(false);
        try {
            base = Resource.newResource((String)this.docRootURL);
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException(e2);
        }
        this.webapp.setBaseResource(base);
        this.webapp.setContextPath(this.contextPath);
        this.configureWebapp(this.webapp);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.webapp, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        log.debug("Base URI of webapp: " + this.webapp.getBaseResource().getURI());
        this.startTime = System.currentTimeMillis();
        try {
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            this.server.addEventListener((Container.Listener)mbContainer);
            this.server.addBean((Object)mbContainer);
            this.server.start();
            new Thread(){

                @Override
                public void run() {
                    while (EmbeddedJetty.this.server.isStarting()) {
                        System.out.println("Starting...");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    System.out.println("Done. Now " + EmbeddedJetty.this.server.getState());
                }
            }.start();
        }
        catch (BindException e) {
            log.warn("App is already running at port " + this.port + ", could not automatically stop it.");
            System.exit(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String uriString = "http://" + HostUtils.getLocalHostname() + ":" + this.port + "/";
            return new URI(uriString).resolve(this.contextPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void configureWebapp(WebAppContext var1);

    public void stopServer() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("error stopping server", e);
            }
            this.server = null;
        }
    }

    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    public boolean isConfigured() {
        return this.contextPath != null && this.docRootURL != null;
    }
}

