/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gaemyadmin;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.gaemyadmin.AppConstants;
import org.xydra.gaemyadmin.GaeMyAdmin_GaeTestfixer;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.Page;
import org.xydra.restless.utils.ServletUtils;

public class LogAdminResource {
    public static final String PAGE_NAME = "Logging Configuration";
    static String URL;

    public static void restless(Restless restless, String prefix) {
        URL = prefix + "/logs";
        restless.addMethod(URL, "GET", LogAdminResource.class, "index", true, new RestlessParameter[0]);
        restless.addMethod(URL, "POST", LogAdminResource.class, "post", true, new RestlessParameter[0]);
    }

    public void index(HttpServletResponse res) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "");
        Page.Form form = new Page.Form(null, Page.METHOD.POST, "/admin" + URL);
        Page.UnsortedList ul = form.unsortedList();
        LogManager lm = LogManager.getLogManager();
        Enumeration<String> enu = lm.getLoggerNames();
        while (enu.hasMoreElements()) {
            String loggerName = enu.nextElement();
            Logger logger = lm.getLogger(loggerName);
            if (logger != null) {
                Level currentLevel = logger.getLevel();
                ul.li().inputText("Logger '" + loggerName + "'", "logger-" + loggerName, currentLevel == null ? "" : currentLevel.getName());
                continue;
            }
            ul.li("'" + loggerName + "'");
        }
        ul.li().inputSubmit("Set");
        w.write(form.toHtml("  "));
        AppConstants.endPage(w);
    }

    public void post(HttpServletRequest req, HttpServletResponse res) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Map params = ServletUtils.getRequestparametersAsMap((HttpServletRequest)req);
        LogManager lm = LogManager.getLogManager();
        for (Map.Entry param : params.entrySet()) {
            String key = (String)param.getKey();
            String loggerName = key.substring("logger-".length());
            Logger logger = lm.getLogger(loggerName);
            if (logger == null) {
                throw new IllegalArgumentException("Logger '" + loggerName + "' was null");
            }
            Level current = logger.getLevel();
            Level planned = null;
            try {
                planned = Level.parse((String)param.getValue());
                if (current != null && current.equals(planned)) continue;
                logger.setLevel(planned);
            }
            catch (IllegalArgumentException e) {}
        }
        res.sendRedirect("/admin" + URL);
    }
}

