/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files.type.impl;

import de.xam.files.type.IFileType;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

public class FileTypeImpl
implements IFileType {
    private final String name;
    private final Charset charset;
    private final Set<String> extensions;
    private final Set<String> mimeTypes;
    private boolean canContainFiles;

    public FileTypeImpl(String name, Charset charset, Set<String> extensions, Set<String> mimeTypes) {
        this.name = name;
        this.charset = charset;
        this.extensions = extensions;
        this.mimeTypes = mimeTypes;
    }

    public FileTypeImpl addExtension(String extension) {
        this.extensions.add(extension);
        return this;
    }

    public FileTypeImpl addMimeType(String mimeType) {
        this.mimeTypes.add(mimeType);
        return this;
    }

    public FileTypeImpl(String name, Charset charset) {
        this(name, charset, new HashSet<String>(), new HashSet<String>());
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public boolean canContainFiles() {
        return this.canContainFiles;
    }

    public IFileType setCanContainFiles(boolean canContainFiles) {
        this.canContainFiles = canContainFiles;
        return this;
    }
}

