/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files.type.impl;

import de.xam.files.type.IFileType;
import de.xam.files.type.IFileTypeHandler;
import de.xam.files.type.impl.FileTypeImpl;
import java.io.IOException;
import java.io.InputStream;

public class DefaultFileTypeHandler
implements IFileTypeHandler {
    private final IFileType fileType;
    private double precision = 0.0;
    private static int id = 0;

    public DefaultFileTypeHandler(IFileType fileType) {
        this.fileType = fileType;
    }

    @Override
    public long getMetadataHeaderByteLength(InputStream in) throws IOException {
        return 0L;
    }

    @Override
    public IFileType getFileType() {
        return this.fileType;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    public static IFileTypeHandler createWithExtension(String ext) {
        return new DefaultFileTypeHandler(new FileTypeImpl("Default-" + id++, null).addExtension(ext));
    }

    public static IFileTypeHandler createWithMimeType(String mimeType) {
        return new DefaultFileTypeHandler(new FileTypeImpl("Default-" + id++, null).addMimeType(mimeType));
    }

    public IFileTypeHandler setPrecision(double precision) {
        this.precision = precision;
        return this;
    }
}

