/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class TagFileTool {
    protected static final String EXT_TAG = ".tag";

    public static Set<String> getTags(File dir) {
        HashSet<String> tags = new HashSet<String>();
        for (File f : dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(TagFileTool.EXT_TAG);
            }
        })) {
            if (!f.isFile()) continue;
            String tag = FilenameUtils.getBaseName((String)f.getName());
            tags.add(tag.toLowerCase());
        }
        return tags;
    }

    public static boolean hasTag(File dir, String tag) {
        File tagFile = new File(dir, tag + EXT_TAG);
        assert (!tagFile.exists() || tagFile.isFile());
        return tagFile.exists();
    }

    public static void addTags(File dir, String ... tags) throws IOException {
        assert (dir.isDirectory());
        for (String tag : tags) {
            File f = new File(dir, tag + EXT_TAG);
            f.createNewFile();
        }
    }
}

