/*
 * Decompiled with CFR 0.152.
 */
package de.xam.files;

import de.xam.files.type.IFileAndFolderTypeHandlerProvider;
import de.xam.files.type.IFileTypeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FileMetaDataProviderService {
    private static final Logger log = LoggerFactory.getLogger(FileMetaDataProviderService.class);
    private static ServiceLoader<IFileAndFolderTypeHandlerProvider> fileMetaDataProviderService = ServiceLoader.load(IFileAndFolderTypeHandlerProvider.class);
    private static Map<String, IFileTypeHandler> ext2handler;

    public static IFileTypeHandler getBestFileTypeHandlerByExt(String ext) {
        if (ext2handler.containsKey(ext)) {
            return ext2handler.get(ext);
        }
        TreeMap<Double, IFileTypeHandler> map = new TreeMap<Double, IFileTypeHandler>();
        assert (fileMetaDataProviderService.iterator().hasNext());
        for (IFileAndFolderTypeHandlerProvider cp : fileMetaDataProviderService) {
            IFileTypeHandler handler = cp.getFileTypeHandlerByExtension(ext);
            if (handler == null) continue;
            map.put(handler.getPrecision(), handler);
        }
        IFileTypeHandler best = FileMetaDataProviderService.getBest(map, ext);
        if (best != null) {
            ext2handler.put(ext, best);
        }
        return FileMetaDataProviderService.getBestFileTypeHandlerByExt(ext);
    }

    private static IFileTypeHandler getBest(SortedMap<Double, IFileTypeHandler> map, String searchString) {
        if (map.isEmpty()) {
            return null;
        }
        SortedMap<Double, IFileTypeHandler> best = map.tailMap(map.lastKey());
        if (best.size() > 1) {
            log.warn("Found multiple 'best' implementations for '" + searchString + "'");
            ArrayList<IFileTypeHandler> list = new ArrayList<IFileTypeHandler>(best.size());
            list.addAll(best.values());
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return o2.getClass().getCanonicalName().compareTo(o1.getClass().getCanonicalName());
                }
            });
            return (IFileTypeHandler)list.get(0);
        }
        assert (best.size() == 1);
        return best.values().iterator().next();
    }

    static {
        assert (fileMetaDataProviderService.iterator().hasNext());
        ext2handler = new HashMap<String, IFileTypeHandler>();
    }
}

