/*
 * Decompiled with CFR 0.152.
 */
package de.xam.kgif.impl.itemset;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Attachment;
import com.calpano.kgif.v1_1_0.gen.Attribute;
import com.calpano.kgif.v1_1_0.gen.Attributes;
import com.calpano.kgif.v1_1_0.gen.Content;
import com.calpano.kgif.v1_1_0.gen.Footer;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Label;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import com.calpano.kgif.v1_1_0.read.KgifReads;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.ItemSets;
import de.xam.itemset.impl.Items;
import de.xam.itemset.impl.xydra.PropertyXy;
import de.xam.kgif.impl.itemset.KgifItemset;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.id.XidCodec;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.index.IPair;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifEntityHandler
implements IEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(KgifEntityHandler.class);
    private Footer footer;
    private Header header;
    private final IItemSet itemSet;
    private Map<String, String> nsMap;

    public static void assertKnownContentType(IIoContext ioContext, String contentTypeId) {
        IContentType contentType = ContentTypes.parseContentTypeIdentifier((String)contentTypeId);
        if (contentType == null) {
            throw new KgifReadWriteException("Unknown content type '" + contentTypeId + "'", ioContext.getParseLocation());
        }
    }

    public static Map<String, String> getNamespaceMap(Header header) {
        Attributes atts;
        HashMap<String, String> nsMap = new HashMap<String, String>();
        assert (header != null);
        Metadata metadata = header.getMetadata();
        if (metadata != null && (atts = metadata.getAttributes()) != null) {
            for (Attribute att : atts.getAttribute()) {
                if (!att.getName().startsWith("namespace-")) continue;
                String ns = att.getName().substring("namespace-".length());
                String expansion = att.getContent();
                nsMap.put(ns, expansion);
            }
        }
        return nsMap;
    }

    private static void setAttributeIfNotNull(IEntity entity, String attributeIdStr, String attributeValueStr) {
        if (attributeValueStr != null) {
            entity.setAttribute(Base.toId((String)attributeIdStr), (XValue)XV.toValue((String)attributeValueStr));
        }
    }

    public static IPair<String, XId> toXidFromKgifId(String kgifId, Map<String, String> nsMap) {
        XId id;
        boolean sourceSyntaxRequired;
        block7: {
            assert (kgifId != null) : "kgif id is null";
            assert (!kgifId.isEmpty()) : "kgif id is the empty string";
            sourceSyntaxRequired = false;
            String idStr = ItemSets.abbreviate((String)kgifId, nsMap, (String)"-");
            if (idStr == null) {
                idStr = kgifId;
            } else {
                sourceSyntaxRequired = true;
            }
            try {
                id = Base.toId((String)idStr);
            }
            catch (IllegalArgumentException e) {
                sourceSyntaxRequired = true;
                id = XidCodec.encodeAsXId((String)idStr, (int)100);
                if ($assertionsDisabled || id != null) break block7;
                throw new AssertionError();
            }
        }
        if (sourceSyntaxRequired) {
            return new Pair((Object)kgifId, (Object)id);
        }
        return new Pair(null, (Object)id);
    }

    public KgifEntityHandler(IItemSet itemSet) {
        this.itemSet = itemSet;
    }

    public void close() throws IOException {
    }

    public Footer getFooter() {
        return this.footer;
    }

    public Header getHeader() {
        return this.header;
    }

    public void onDocumentEnd(IIoContext ioContext) throws IOException {
    }

    public void onDocumentStart(IIoContext ioContext) throws IOException {
    }

    public void onFooter(IIoContext ioContext, Footer footer) {
        this.footer = footer;
    }

    public void onGraphEnd(IIoContext ioContext) {
    }

    public void onGraphStart(IIoContext ioContext, Metadata metadata) {
    }

    public void onHeader(IIoContext ioContext, Header header) {
        this.header = header;
        this.nsMap = KgifEntityHandler.getNamespaceMap(header);
    }

    public void onLink(IIoContext ioContext, Link link) {
        XId id;
        String sourceSyntax = null;
        String idStr = link.getId();
        if (idStr == null) {
            id = this.itemSet.factory().createId();
        } else {
            IPair<String, XId> sourceSyntax_id_pair = this.toXidFromKgifId(idStr);
            sourceSyntax = (String)sourceSyntax_id_pair.getFirst();
            id = (XId)sourceSyntax_id_pair.getSecond();
        }
        Metadata metadata = link.getMetadata();
        IChangeData changeData = KgifItemset.toChangeData(metadata);
        String sStr = link.getFrom();
        String pStr = link.getType();
        String oStr = link.getTo();
        XId s = (XId)this.toXidFromKgifId(sStr).getSecond();
        XId p = (XId)this.toXidFromKgifId(pStr).getSecond();
        XId o = (XId)this.toXidFromKgifId(oStr).getSecond();
        assert (o != null);
        try {
            IStatement stmt = this.itemSet.createAndAddStatement(id, s, p, o, changeData);
            KgifEntityHandler.setAttributeIfNotNull((IEntity)stmt, "id-sourceSyntax", sourceSyntax);
        }
        catch (Exception e) {
            throw new RuntimeException("While processing link (" + s + "," + p + "," + o + ")", e);
        }
    }

    public void onNode(IIoContext ioContext, Node node) {
        Content content;
        String idStr = node.getId();
        IPair<String, XId> sourceSyntax_id_pair = this.toXidFromKgifId(idStr);
        String sourceSyntax = (String)sourceSyntax_id_pair.getFirst();
        XId id = (XId)sourceSyntax_id_pair.getSecond();
        Metadata metadata = node.getMetadata();
        IChangeData changeData = KgifItemset.toChangeData(metadata);
        String labelStr = null;
        Label label = node.getLabel();
        if (label == null) {
            if (log.isTraceEnabled()) {
                log.trace("no label in node " + node.getId() + " @" + ioContext.getParseLocation());
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Importing '" + label.getContent() + "'(" + label.getContentType() + ") [id=" + id + "]");
            }
            KgifEntityHandler.assertKnownContentType(ioContext, label.getContentType());
            labelStr = label.getContent();
        }
        if (labelStr == null) {
            labelStr = idStr;
        }
        IItem item = Items.getOrCreateItemWithId((IItemSet)this.itemSet, (XId)id, (String)labelStr, (IChangeData)changeData);
        KgifEntityHandler.setAttributeIfNotNull((IEntity)item, "id-sourceSyntax", sourceSyntax);
        if (metadata != null) {
            List attachmentList;
            String type = KgifReads.getAttributeValue((Metadata)metadata, (String)VocabularyCModel.ATTRIBUTE_TYPE.toString(), null);
            assert (type == null || type.equals("Item"));
            Attributes atts = metadata.getAttributes();
            if (atts != null) {
                for (Attribute att : atts.getAttribute()) {
                    if (VocabularyCModel.SET_OF_ATTRIBUTE_IDS_FOR_CONTENT.contains(Base.toId((String)att.getName()))) continue;
                    this.onNodeMetadataAttribute(item, att);
                }
            }
            if ((attachmentList = metadata.getAttachment()) != null && attachmentList.size() > 0) {
                for (Attachment attachment : attachmentList) {
                    log.info("Ignoring attachment " + attachment.getContent().length() + " chars");
                }
            }
        }
        if ((content = node.getContent()) != null) {
            String contentType = content.getContentType();
            assert (contentType.equals("text/plain") || contentType.equals("http://purl.org/net/xydra/datatypes#string") || contentType.equals("http://www.w3.org/2001/XMLSchema#string")) : contentType;
            this.onNodeContent(item, content);
        }
    }

    protected void onNodeContent(IItem item, Content content) {
    }

    protected void onNodeMetadataAttribute(IItem item, Attribute att) {
        XId attId = (XId)this.toXidFromKgifId(att.getName()).getSecond();
        item.setAttribute(attId, (XValue)XV.toValue((String)att.getContent()));
    }

    public void onProperty(IIoContext ioContext, Property property) throws IOException, KgifReadWriteException {
        XId id;
        String sourceSyntax = null;
        String idStr = property.getId();
        if (idStr == null) {
            id = this.itemSet.factory().createId();
        } else {
            IPair<String, XId> sourceSyntax_id_pair = this.toXidFromKgifId(idStr);
            sourceSyntax = (String)sourceSyntax_id_pair.getFirst();
            id = (XId)sourceSyntax_id_pair.getSecond();
        }
        Metadata metadata = property.getMetadata();
        IChangeData changeData = KgifItemset.toChangeData(metadata);
        String sStr = property.getSourceEntityId();
        assert (sStr != null) : "missing sourceEntityId in property " + property;
        XId s = (XId)this.toXidFromKgifId(sStr).getSecond();
        assert (s != null);
        String pStr = property.getKey();
        XId p = (XId)this.toXidFromKgifId(pStr).getSecond();
        assert (p != null);
        String oStr = property.getContent().getContent();
        String oContentTypeStr = property.getContent().getContentType();
        try {
            IProperty prop = this.itemSet.createAndAddProperty(id, s, p, oStr, oContentTypeStr, changeData);
            assert (prop instanceof PropertyXy);
            KgifEntityHandler.setAttributeIfNotNull((IEntity)prop, "id-sourceSyntax", sourceSyntax);
        }
        catch (Exception e) {
            throw new RuntimeException("While processing property (" + s + "." + p + "=" + oStr + ")", e);
        }
    }

    protected IPair<String, XId> toXidFromKgifId(String kgifId) {
        return KgifEntityHandler.toXidFromKgifId(kgifId, this.nsMap);
    }
}

