/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.gaeutils;

import com.google.appengine.api.utils.SystemProperty;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.util.ClassPathTool;
import org.xydra.xgae.gaeutils.GaeTestFixer_LocalPart;

public class GaeTestfixer {
    private static final Logger log = LoggerFactory.getLogger(GaeTestfixer.class);
    private static boolean enabled = false;
    private static boolean checkedProduction = false;

    public static void enable() {
        log.debug("Enabling test fixer.");
        enabled = true;
        checkedProduction = false;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean inProduction() {
        return SystemProperty.environment.get() != null && SystemProperty.environment.value().equals((Object)SystemProperty.Environment.Value.Production);
    }

    public static void initialiseHelperAndAttachToCurrentThread() {
        if (!enabled) {
            return;
        }
        if (!checkedProduction) {
            log.debug("Testing if we are on the real GAE in production...");
            checkedProduction = true;
            if (GaeTestfixer.inProduction()) {
                log.debug("Testfixer: Running on AppEngine in production: Auto-disabled test fixer.");
                enabled = false;
                return;
            }
            log.debug("Testfixer: Running locally");
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class.forName("com.google.appengine.tools.development.testing.LocalServiceTestHelper", false, cl);
                log.info("We can load the test classes.");
            }
            catch (ClassNotFoundException e) {
                log.info("We are in production or have no test-classpath (=a test jar is missing): Auto-disabled test fixer.\n Reason: 'com.google.appengine.tools.development.testing.LocalServiceTestHelper' not found in classpath", (Throwable)e);
                ClassPathTool.dumpCurrentClasspath();
                enabled = false;
                return;
            }
            catch (NoClassDefFoundError e) {
                log.warn("We are in production or have no test-classpath (=a test jar is missing): Auto-disabled test fixer.", (Throwable)e);
                enabled = false;
                return;
            }
        }
        GaeTestFixer_LocalPart.initialiseHelperAndAttachToCurrentThread();
    }

    public static synchronized void tearDown() {
        GaeTestFixer_LocalPart.tearDown();
    }
}

