/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.datastore.impl.gae;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Text;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xydra.index.TransformerTool;
import org.xydra.index.iterator.ITransformer;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SValue;
import org.xydra.xgae.datastore.impl.gae.GKey;
import org.xydra.xgae.datastore.impl.gae.GText;
import org.xydra.xgae.datastore.impl.gae.RawWrapper;

public class GEntity
extends RawWrapper<Entity, GEntity>
implements SEntity {
    private static ITransformer<Object, Object> GAE_TO_XGAE = new ITransformer<Object, Object>(){

        public Object transform(Object in) {
            if (in instanceof List) {
                List list = (List)in;
                ArrayList<Object> xgaeList = new ArrayList<Object>(list.size());
                for (Object o : list) {
                    xgaeList.add(GAE_TO_XGAE.transform(o));
                }
                return xgaeList;
            }
            if (in instanceof Text) {
                return GText.wrap((Text)in);
            }
            if (in instanceof Key) {
                return GKey.wrap((Key)in);
            }
            return in;
        }
    };
    protected static final ITransformer<Entity, SEntity> TRANSFOMER_ENTITY_SENTITY = new ITransformer<Entity, SEntity>(){

        public SEntity transform(Entity in) {
            return GEntity.wrap(in);
        }
    };
    private static ITransformer<Object, Object> XGAE_TO_GAE = new ITransformer<Object, Object>(){

        public Object transform(Object in) {
            if (in instanceof List) {
                List list = (List)in;
                ArrayList<Object> gaeList = new ArrayList<Object>(list.size());
                for (Object o : list) {
                    gaeList.add(XGAE_TO_GAE.transform(o));
                }
                return gaeList;
            }
            if (in instanceof SValue) {
                return ((SValue)in).raw();
            }
            return in;
        }
    };

    public static Iterable<Entity> unwrap(Iterable<SEntity> it) {
        return GEntity._unwrap(it);
    }

    public static GEntity wrap(Entity raw) {
        if (raw == null) {
            return null;
        }
        return new GEntity(raw);
    }

    private GEntity(Entity raw) {
        super(raw);
    }

    public Object getAttribute(String name) {
        Object o = ((Entity)this.raw()).getProperty(name);
        return GAE_TO_XGAE.transform(o);
    }

    public Map<String, Object> getAttributes() {
        Map map = ((Entity)this.raw()).getProperties();
        return TransformerTool.transformMapValues((Map)map, GAE_TO_XGAE);
    }

    public SKey getKey() {
        return GKey.wrap(((Entity)this.raw()).getKey());
    }

    public boolean hasAttribute(String name) {
        return ((Entity)this.raw()).hasProperty(name);
    }

    public void removeAttribute(String name) {
        ((Entity)this.raw()).removeProperty(name);
    }

    public void setAttribute(String name, boolean value) {
        ((Entity)this.raw()).setUnindexedProperty(name, (Object)value);
    }

    public void setAttribute(String name, List<?> list) {
        Object gaeList = XGAE_TO_GAE.transform(list);
        ((Entity)this.raw()).setUnindexedProperty(name, gaeList);
    }

    public void setAttribute(String name, long value) {
        ((Entity)this.raw()).setUnindexedProperty(name, (Object)value);
    }

    public void setAttribute(String name, Serializable serializable) {
        ((Entity)this.raw()).setUnindexedProperty(name, (Object)serializable);
    }

    public void setAttribute(String name, String value) {
        ((Entity)this.raw()).setUnindexedProperty(name, (Object)value);
    }

    public void setAttribute(String name, SValue value) {
        ((Entity)this.raw()).setUnindexedProperty(name, value.raw());
    }
}

