/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.xgae.datastore.impl.gae;

import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.xydra.index.TransformerTool;
import org.xydra.index.iterator.ITransformer;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.sharedutils.XyAssert;
import org.xydra.xgae.datastore.api.IDatastoreAsync;
import org.xydra.xgae.datastore.api.SEntity;
import org.xydra.xgae.datastore.api.SKey;
import org.xydra.xgae.datastore.api.SPreparedQuery;
import org.xydra.xgae.datastore.api.STransaction;
import org.xydra.xgae.datastore.impl.gae.DatastoreImplGaeBase;
import org.xydra.xgae.datastore.impl.gae.GEntity;
import org.xydra.xgae.datastore.impl.gae.GKey;
import org.xydra.xgae.datastore.impl.gae.GPreparedQuery;
import org.xydra.xgae.datastore.impl.gae.GTransaction;
import org.xydra.xgae.gaeutils.GaeTestfixer;
import org.xydra.xgae.util.FutureUtils;
import org.xydra.xgae.util.XGaeDebugHelper;

public class DatastoreImplGaeAsync
extends DatastoreImplGaeBase
implements IDatastoreAsync {
    private static final Logger log = LoggerFactory.getLogger(DatastoreImplGaeAsync.class);
    private AsyncDatastoreService asyncDatastore;
    public static final String DATASTORE_NAME = "[#DSa]";
    private static final boolean TRACE_CALLS = false;

    public Future<STransaction> beginTransaction() {
        log.debug("-- begin Transaction --");
        this.makeSureDatestoreServiceIsInitialised();
        return GTransaction.wrapFuture(this.asyncDatastore.beginTransaction());
    }

    public Future<Void> deleteEntity(SKey key) {
        return this.deleteEntity(key, null);
    }

    public Future<Void> deleteEntity(SKey key, STransaction txn) {
        assert (key != null);
        log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, (String)key.toString(), null, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Started));
        this.makeSureDatestoreServiceIsInitialised();
        Future future = this.asyncDatastore.delete((Transaction)txn.raw(), new Key[]{(Key)key.raw()});
        return new FutureDeleteEntity(key, future);
    }

    public void endTransaction(STransaction txn) throws ConcurrentModificationException {
        log.debug("-- end Transaction --");
        this.makeSureDatestoreServiceIsInitialised();
        ((Transaction)txn.raw()).commit();
    }

    public Future<Map<SKey, SEntity>> getEntities(Collection<SKey> keys) {
        return this.getEntities(keys, null);
    }

    public Future<Map<SKey, SEntity>> getEntities(Collection<SKey> keys, STransaction txn) {
        assert (keys != null);
        this.makeSureDatestoreServiceIsInitialised();
        ITransformer<Map<Key, Entity>, Map<SKey, SEntity>> transformer = new ITransformer<Map<Key, Entity>, Map<SKey, SEntity>>(){

            public Map<SKey, SEntity> transform(Map<Key, Entity> in) {
                return TransformerTool.transformMapKeyAndValues(in, GKey.TRANSFOMER_KEY_SKEY, GEntity.TRANSFOMER_ENTITY_SENTITY);
            }
        };
        if (keys.isEmpty()) {
            Map emptyMap = Collections.emptyMap();
            Future result = FutureUtils.createCompleted(emptyMap);
            return result;
        }
        Future rawResult = this.asyncDatastore.get((Transaction)txn.raw(), GKey.unwrap(keys));
        return new FutureUtils.TransformingFuture(rawResult, (ITransformer)transformer);
    }

    public Future<SEntity> getEntity(SKey key) {
        return this.getEntity(key, null);
    }

    public Future<SEntity> getEntity(SKey key, STransaction txn) {
        assert (key != null);
        this.makeSureDatestoreServiceIsInitialised();
        Future e = this.asyncDatastore.get((Transaction)txn.raw(), (Key)key.raw());
        return new FutureGetEntity(key, e);
    }

    private void makeSureDatestoreServiceIsInitialised() {
        GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        if (this.asyncDatastore == null) {
            log.debug(XGaeDebugHelper.init((String)DATASTORE_NAME));
            this.asyncDatastore = DatastoreServiceFactory.getAsyncDatastoreService();
        }
    }

    public SPreparedQuery prepareRangeQuery(String kind, boolean keysOnly, String lowName, String highName) {
        return this.prepareRangeQuery(kind, true, lowName, highName, null);
    }

    public SPreparedQuery prepareRangeQuery(String kind, boolean keysOnly, String lowName, String highName, STransaction txn) {
        Query query = this.createRangeQuery(kind, keysOnly, lowName, highName);
        assert (query != null);
        return GPreparedQuery.wrap(this.asyncDatastore.prepare((Transaction)txn.raw(), query));
    }

    public Future<List<SKey>> putEntities(Iterable<SEntity> it) {
        XyAssert.xyAssert((it != null ? 1 : 0) != 0, (Object)"iterable is null");
        assert (it != null);
        log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, (String)"entities", (Object)"many", (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Now));
        this.makeSureDatestoreServiceIsInitialised();
        Future f = this.asyncDatastore.put(TransformerTool.transformIterable(it, (ITransformer)new ITransformer<SEntity, Entity>(){

            public Entity transform(SEntity in) {
                return (Entity)in.raw();
            }
        }));
        ITransformer<List<Key>, List<SKey>> transformer = new ITransformer<List<Key>, List<SKey>>(){

            public List<SKey> transform(List<Key> in) {
                return TransformerTool.transformListEntries(in, GKey.TRANSFOMER_KEY_SKEY);
            }
        };
        return new FutureUtils.TransformingFuture(f, (ITransformer)transformer);
    }

    public Future<SKey> putEntity(SEntity entity) {
        return this.putEntity(entity, null);
    }

    public Future<SKey> putEntity(SEntity entity, STransaction txn) {
        XyAssert.xyAssert((entity != null ? 1 : 0) != 0, (Object)"entity is null");
        assert (entity != null);
        log.debug(XGaeDebugHelper.dataPut((String)DATASTORE_NAME, (String)XGaeDebugHelper.toString((SKey)entity.getKey()), (Object)entity, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Started));
        this.makeSureDatestoreServiceIsInitialised();
        Future f = this.asyncDatastore.put((Transaction)txn.raw(), (Entity)entity.raw());
        return new FuturePutEntity(entity, f);
    }

    public boolean isTransactionsActive() {
        return !this.asyncDatastore.getActiveTransactions().isEmpty();
    }

    public String getDatastoreName() {
        return DATASTORE_NAME;
    }

    private static class FuturePutEntity
    extends DebugFuture<SEntity, SKey> {
        public FuturePutEntity(SEntity key, Future<Key> f) {
            super(key, new FutureUtils.TransformingFuture(f, (ITransformer)new ITransformer<Key, SKey>(){

                public SKey transform(Key in) {
                    return GKey.wrap(in);
                }
            }));
        }

        @Override
        void log(SEntity key, SKey result) {
            log.debug(XGaeDebugHelper.dataPut((String)DatastoreImplGaeAsync.DATASTORE_NAME, (String)XGaeDebugHelper.toString((SKey)result), (Object)key, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Finished));
        }
    }

    private static class FuturePutEntities
    extends TransformingDebugFuture<Iterable<SEntity>, List<Key>, List<SKey>> {
        public FuturePutEntities(Iterable<SEntity> it, Future<List<Key>> f, ITransformer<List<Key>, List<SKey>> transformer) {
            super(it, f, transformer);
        }

        @Override
        void log(Iterable<SEntity> key, List<SKey> result) {
            log.debug(XGaeDebugHelper.dataPut((String)DatastoreImplGaeAsync.DATASTORE_NAME, (String)"manyKeys", key, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Finished));
        }
    }

    private static class FutureGetEntities
    extends TransformingDebugFuture<Collection<SKey>, Map<Key, Entity>, Map<SKey, SEntity>> {
        public FutureGetEntities(Collection<SKey> keys, Future<Map<Key, Entity>> f, ITransformer<Map<Key, Entity>, Map<SKey, SEntity>> transformer) {
            super(keys, f, transformer);
        }

        @Override
        void log(Collection<SKey> key, Map<SKey, SEntity> result) {
            log.debug(XGaeDebugHelper.dataGet((String)DatastoreImplGaeAsync.DATASTORE_NAME, key, result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Finished));
        }
    }

    private static class FutureGetEntity
    extends DebugFuture<SKey, SEntity> {
        public FutureGetEntity(SKey key, Future<Entity> f) {
            super(key, new FutureUtils.TransformingFuture(f, (ITransformer)new ITransformer<Entity, SEntity>(){

                public SEntity transform(Entity in) {
                    return GEntity.wrap(in);
                }
            }));
        }

        @Override
        void log(SKey key, SEntity result) {
            log.debug(XGaeDebugHelper.dataGet((String)DatastoreImplGaeAsync.DATASTORE_NAME, (String)XGaeDebugHelper.toString((SKey)key), (Object)result, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Finished));
        }
    }

    private static class FutureDeleteEntity
    extends DebugFuture<SKey, Void> {
        public FutureDeleteEntity(SKey key, Future<Void> f) {
            super(key, f);
        }

        @Override
        void log(SKey key, Void result) {
            log.debug(XGaeDebugHelper.dataPut((String)DatastoreImplGaeAsync.DATASTORE_NAME, (String)XGaeDebugHelper.toString((SKey)key), null, (XGaeDebugHelper.Timing)XGaeDebugHelper.Timing.Finished));
        }
    }

    private static abstract class TransformingDebugFuture<K, I, O>
    implements Future<O> {
        private final Future<I> f;
        private final K key;
        private final ITransformer<I, O> transformer;

        public TransformingDebugFuture(K key, Future<I> f, ITransformer<I, O> transformer) {
            this.key = key;
            this.f = f;
            this.transformer = transformer;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.f.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.f.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            I in = this.f.get();
            Object out = this.transformer.transform(in);
            this.log(this.key, out);
            return (O)out;
        }

        abstract void log(K var1, O var2);

        @Override
        public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            I in = this.f.get(timeout, unit);
            Object out = this.transformer.transform(in);
            this.log(this.key, out);
            return (O)out;
        }
    }

    private static abstract class DebugFuture<K, V>
    implements Future<V> {
        private final Future<V> f;
        private final K key;

        public DebugFuture(K key, Future<V> f) {
            this.key = key;
            this.f = f;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.f.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.f.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            V result = this.f.get();
            this.log(this.key, result);
            return result;
        }

        abstract void log(K var1, V var2);

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            V result = this.f.get(timeout, unit);
            this.log(this.key, result);
            return result;
        }
    }
}

