/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.hover;

import com.calpano.common.client.ClientApp;
import com.calpano.common.client.view.hover.HasHoverHandlers;
import com.calpano.common.client.view.hover.HoverHandler;
import com.calpano.common.shared.util.CommonAppState;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.HandlerRegistration;

public class HoverEvent
extends Event<HoverHandler> {
    private final NativeEvent cause;
    private final boolean hoverStart;
    public static Event.Type<HoverHandler> TYPE = new Event.Type();

    public HoverEvent(NativeEvent cause, boolean hoverStart) {
        this.cause = cause;
        this.hoverStart = hoverStart;
    }

    public NativeEvent getCause() {
        return this.cause;
    }

    public boolean isHoverStart() {
        return this.hoverStart;
    }

    public boolean isHoverEnd() {
        return !this.hoverStart;
    }

    public static Event.Type<HoverHandler> getTYPE() {
        return TYPE;
    }

    public Event.Type<HoverHandler> getAssociatedType() {
        return TYPE;
    }

    public Widget getSource() {
        return (Widget)super.getSource();
    }

    protected void dispatch(HoverHandler handler) {
        handler.onHoverChange(this);
    }

    public static void fireHoverStartFromSource(HasHoverHandlers source, NativeEvent cause) {
        if (source.getLastHoverFired() != CommonAppState.Is.Yes) {
            ClientApp.getEventBus().fireEventFromSource((Event)new HoverEvent(cause, true), (Object)source);
            source.setLastHoverFired(CommonAppState.Is.Yes);
        }
    }

    public static void fireHoverEndFromSource(HasHoverHandlers source, NativeEvent cause) {
        if (source.getLastHoverFired() != CommonAppState.Is.No) {
            ClientApp.getEventBus().fireEventFromSource((Event)new HoverEvent(cause, false), (Object)source);
            source.setLastHoverFired(CommonAppState.Is.No);
        }
    }

    public static HandlerRegistration addHandler(Object source, HoverHandler handler) {
        return ClientApp.getEventBus().addHandlerToSource(TYPE, source, (Object)handler);
    }

    public static void registerHoverEventsOn(HasHoverHandlers hhh) {
        hhh.asWidget().addDomHandler((EventHandler)new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                HasHoverHandlers hhh = (HasHoverHandlers)event.getSource();
                HoverEvent.fireHoverStartFromSource(hhh, event.getNativeEvent());
            }
        }, MouseOverEvent.getType());
        hhh.asWidget().addDomHandler((EventHandler)new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                HasHoverHandlers hhh = (HasHoverHandlers)event.getSource();
                HoverEvent.fireHoverEndFromSource(hhh, event.getNativeEvent());
            }
        }, MouseOutEvent.getType());
    }
}

