/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.placeholder.impl;

import com.calpano.common.client.view.forms.Html5DomUtil;
import com.calpano.common.client.view.forms.locking.impl.H5Lockable;
import com.calpano.common.client.view.forms.placeholder.IPlaceholderSupport;
import com.calpano.common.client.view.forms.utils.KeyUtils;
import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.TextBoxBase;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class H5Placeholder<T extends TextBoxBase>
extends H5Lockable<T>
implements IPlaceholderSupport {
    private static final Logger log = LoggerFactory.getLogger(H5Placeholder.class);
    public static final int[] PLACEHOLDER_EVENTS = new int[]{128, 512, 524288, 1024, 1, 2, 2048};
    private String lastFiredValue = null;
    private String placeholderText = "";
    private final boolean simulatePlaceholder;
    private State state;

    public H5Placeholder(T base, boolean simulatePlaceholder) {
        super(base);
        CommonResourceBundle.INSTANCE.css().ensureInjected();
        this.simulatePlaceholder = simulatePlaceholder;
        this.setToInitialPlaceholderState();
    }

    private void fireValueChangeEventIfValueChangeFromLastTime(String userTypedText) {
        if (this.lastFiredValue != null && this.lastFiredValue.equals(userTypedText)) {
            return;
        }
        this.lastFiredValue = userTypedText;
        ValueChangeEvent.fire(this.getTextBoxBase(), (Object)userTypedText);
    }

    @Override
    protected int getEventsToSink() {
        int eventBits = 0;
        eventBits |= super.getEventsToSink();
        if (this.simulatePlaceholder) {
            for (int i = 0; i < PLACEHOLDER_EVENTS.length; ++i) {
                eventBits |= PLACEHOLDER_EVENTS[i];
            }
        }
        return eventBits;
    }

    public String getPlaceholder() {
        return this.placeholderText;
    }

    @Override
    public String getRawText() {
        return ((IPlaceholderSupport)this.base).getRawText();
    }

    public String getText() {
        return this.getUsertypedText();
    }

    public String getUsertypedText() {
        switch (this.state) {
            case Placeholder: {
                return "";
            }
            case Usertyped: {
                return this.getRawText();
            }
        }
        throw new AssertionError();
    }

    private boolean hasNonEmptyPlaceholderText() {
        assert (this.placeholderText != null);
        return this.placeholderText.length() > 0;
    }

    private void setToInitialPlaceholderState() {
        this.lastFiredValue = null;
        this.state = State.Placeholder;
    }

    private void moveCursorToFront() {
        this.getTextBoxBase().setCursorPos(0);
        this.getTextBoxBase().setFocus(true);
    }

    protected void onBrowserEvent(Event event) {
        if (!this.simulatePlaceholder) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("H5PlaceH event " + event.getType() + " in state = " + (Object)((Object)this.state));
        }
        int eventType = DOM.eventGetType((Event)event);
        if (this.state == State.Placeholder) {
            switch (eventType) {
                case 1: 
                case 2: 
                case 2048: {
                    this.selectNothing();
                    this.moveCursorToFront();
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            H5Placeholder.this.placeholderTextRepairIfAltered();
                        }
                    });
                    break;
                }
                case 128: {
                    if (KeyUtils.producesText(event.getKeyCode())) {
                        this.switchToUserInputAndRemovePlaceholderText();
                        break;
                    }
                    if (event.getKeyCode() == 9) break;
                    event.stopPropagation();
                    event.preventDefault();
                    return;
                }
                case 524288: {
                    this.switchToUserInputAndRemovePlaceholderText();
                    break;
                }
                case 512: {
                    if (event.getKeyCode() == 9) {
                        this.onGetFocus();
                    } else if (KeyUtils.producesText(event.getKeyCode())) {
                        this.fireValueChangeEventIfValueChangeFromLastTime(this.getRawText());
                    }
                    return;
                }
            }
        } else {
            assert (this.state == State.Usertyped);
            switch (eventType) {
                case 512: 
                case 1024: 
                case 2048: {
                    String value = this.getText();
                    if (value.isEmpty()) {
                        this.state = State.Placeholder;
                        this.renderState();
                        this.fireValueChangeEventIfValueChangeFromLastTime("");
                        break;
                    }
                    this.fireValueChangeEventIfValueChangeFromLastTime(value);
                }
            }
        }
    }

    protected void onGetFocus() {
        log.warn("getting focus");
        if (this.state == State.Usertyped) {
            this.selectAll();
        }
        this.moveCursorToFront();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.simulatePlaceholder) {
            this.renderState();
        }
    }

    private void placeholderTextRepairIfAltered() {
        String foundText = this.getRawText();
        if (!foundText.equals(this.getPlaceholder())) {
            log.info("autorepair placeholder text");
            this.placeholderTextShow();
        }
    }

    private void placeholderTextShow() {
        ((IPlaceholderSupport)this.getTextBoxBase()).setRawText(this.getPlaceholder());
        this.moveCursorToFront();
    }

    private void renderState() {
        switch (this.state) {
            case Placeholder: {
                this.getTextBoxBase().addStyleName(CommonResourceBundle.INSTANCE.css().placeholder());
                this.getTextBoxBase().getElement().setAttribute("spellcheck", "false");
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        H5Placeholder.this.placeholderTextShow();
                    }
                });
                break;
            }
            case Usertyped: {
                this.getTextBoxBase().removeStyleName(CommonResourceBundle.INSTANCE.css().placeholder());
                this.getTextBoxBase().getElement().removeAttribute("spellcheck");
                ((IPlaceholderSupport)this.getTextBoxBase()).setRawText("");
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        if (!this.simulatePlaceholder) {
            return;
        }
        this.fireValueChangeEventIfValueChangeFromLastTime("");
        this.setToInitialPlaceholderState();
        this.renderState();
    }

    private void selectAll() {
        this.getTextBoxBase().setSelectionRange(0, ((IPlaceholderSupport)this.getTextBoxBase()).getRawText().length());
    }

    private void selectNothing() {
        if (this.getTextBoxBase().getSelectionLength() > 0) {
            this.getTextBoxBase().setSelectionRange(0, 0);
        }
    }

    public void setPlaceholder(String placeholderText) {
        String string = this.placeholderText = placeholderText != null ? placeholderText : "";
        if (!this.simulatePlaceholder) {
            Html5DomUtil.setPropertyString(this.getTextBoxBase(), "placeholder", this.placeholderText);
        }
    }

    @Override
    public void setRawText(String s) {
        ((IPlaceholderSupport)this.getTextBoxBase()).setRawText(s);
    }

    public void setText(String s) {
        if (log.isTraceEnabled()) {
            log.trace("setText " + s);
        }
        String text = s != null ? s : "";
        switch (this.state) {
            case Placeholder: {
                if (text.length() <= 0) break;
                this.state = State.Usertyped;
                this.setRawText(text);
                this.renderState();
                break;
            }
            case Usertyped: {
                if (text.length() == 0) {
                    this.state = State.Placeholder;
                    this.setRawText("");
                    this.renderState();
                    break;
                }
                this.setRawText(text);
                this.fireValueChangeEventIfValueChangeFromLastTime(text);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public void setValue(String s) {
        this.setText(s);
    }

    private void switchToUserInputAndRemovePlaceholderText() {
        if (this.state == State.Placeholder) {
            this.state = State.Usertyped;
            this.setRawText("");
            this.renderState();
        }
    }

    private void trimContent() {
        ((IPlaceholderSupport)this.getTextBoxBase()).setRawText(((IPlaceholderSupport)this.getTextBoxBase()).getRawText().trim());
    }

    public static enum State {
        Placeholder,
        Usertyped;

    }
}

