/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.view.forms.impl;

import com.calpano.common.client.util.SuggestionDisplay;
import com.calpano.common.client.view.forms.AutofocusManager;
import com.calpano.common.client.view.forms.Html5DomUtil;
import com.calpano.common.client.view.forms.IHtml5TextInput;
import com.calpano.common.client.view.forms.activation.H5Activation;
import com.calpano.common.client.view.forms.impl.Html5FormPanel;
import com.calpano.common.client.view.forms.suggestion.HideSuggestionEvent;
import com.calpano.common.client.view.forms.suggestion.HideSuggestionHandler;
import com.calpano.common.client.view.forms.suggestion.ShowSuggestionEvent;
import com.calpano.common.client.view.forms.suggestion.ShowSuggestionHandler;
import com.calpano.common.client.view.forms.suggestion.impl.SuggestionManager;
import com.calpano.common.client.view.forms.utils.EventUtil;
import com.calpano.common.client.view.forms.validation.InvalidationHandler;
import com.calpano.common.client.view.forms.validation.ValidationHandler;
import com.calpano.common.client.view.forms.validation.impl.CalculateValidationHelper;
import com.calpano.common.client.view.forms.validation.impl.ShowValidationMessageHelper;
import com.calpano.common.shared.validation.IStringValidator;
import com.calpano.common.shared.validation.ValidationMessage;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBoxBase;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.HandlerRegistration;
import org.xydra.conf.annotations.RequireConf;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

class Html5TextBoxAndAreaPart<T extends TextBoxBase>
extends H5Activation<T>
implements IHtml5TextInput,
ShowSuggestionHandler,
HideSuggestionHandler {
    private static final Logger log = LoggerFactory.getLogger(Html5TextBoxAndAreaPart.class);
    private Html5FormPanel form;
    private final ShowValidationMessageHelper showValidationMessageHelper;
    private final boolean submitOnEnter;
    private final CalculateValidationHelper validationHelper;
    private SuggestionDisplay suggestionDisplay;
    private SuggestionManager suggestionManager;
    private boolean isShowingSuggestions;

    @RequireConf(value={"x-debugMode"})
    public Html5TextBoxAndAreaPart(T gwtTextBoxBase, boolean submitOnEnter, boolean simulatePlaceholder, boolean simulateValidation) {
        super(gwtTextBoxBase, simulatePlaceholder);
        this.submitOnEnter = submitOnEnter;
        this.validationHelper = new CalculateValidationHelper(this, simulateValidation);
        this.showValidationMessageHelper = new ShowValidationMessageHelper(this);
        int eventBits = 0;
        eventBits |= 0x200;
        eventBits |= super.getEventsToSink();
        eventBits |= this.showValidationMessageHelper.getEventsToSink();
        boolean debugMode = Env.get().conf().getBoolean("x-debugMode");
        if (debugMode) {
            eventBits |= 0x7FFFF8F;
        }
        this.getTextBoxBase().sinkEvents(eventBits);
    }

    @Override
    public void addValidator(Integer order, IStringValidator validator) {
        this.validationHelper.addValidator(order, validator);
    }

    @Override
    public Html5FormPanel getForm() {
        return this.form;
    }

    @Override
    public String getType() {
        return this.validationHelper.getType();
    }

    @Override
    public ValidationMessage computeValidation() {
        return this.validationHelper.computeValidation();
    }

    @Override
    public boolean isRequired() {
        return this.validationHelper.isRequired();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @RequireConf(value={"x-debugMode"})
    public void onBrowserEvent(Event event) {
        boolean debugMode = Env.get().conf().getBoolean("x-debugMode");
        if (debugMode) {
            log.info("'''INPUT: " + EventUtil.dumpEvent(event));
        }
        super.onBrowserEvent(event);
        if (this.isShowingSuggestions()) {
            this.suggestionManager.onBrowserEvent(event);
            return;
        }
        switch (DOM.eventGetType((Event)event)) {
            case 128: {
                switch (event.getKeyCode()) {
                    case 13: {
                        if (!this.submitOnEnter || this.isShowingSuggestions()) break;
                        this.getForm().tryToSubmit(this);
                        event.stopPropagation();
                        event.preventDefault();
                        break;
                    }
                    case 40: {
                        if (this.suggestionManager == null) break;
                        this.suggestionManager.showSuggestions("");
                    }
                }
                break;
            }
        }
        this.showValidationMessageHelper.onBrowserEvent(event);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.validationHelper.onLoad();
    }

    @Override
    public void reset() {
        super.reset();
        this.getTextBoxBase().setText("");
        this.showValidationMessageHelper.reset();
        if (this.suggestionManager != null) {
            this.suggestionManager.reset();
        }
        this.validationHelper.reset();
    }

    public void setAutofocus(boolean autofocus) {
        AutofocusManager.setAutofocusWidget(this.getTextBoxBase(), autofocus);
    }

    public void setAutofocus(String attributeValue) {
        if (attributeValue.equals("autofocus") || attributeValue.equals("")) {
            this.setAutofocus(true);
        }
    }

    @Override
    public void setForm(Html5FormPanel html5FormPanel) {
        this.form = html5FormPanel;
    }

    @Override
    public void setRequired(boolean required) {
        this.validationHelper.setRequired(required);
    }

    public void setRequired(String attributeValue) {
        this.validationHelper.setRequired(attributeValue);
    }

    public void setType(String type) {
        this.validationHelper.setType(type);
    }

    public void onBeforeRemoveFromParent() {
        this.showValidationMessageHelper.onBeforeRemoveFromParent();
    }

    @Override
    public void activateValidationWarnings() {
        this.showValidationMessageHelper.activateValidationWarnings();
    }

    public void setAutocomplete(String onOrOff) {
        boolean on;
        boolean bl = on = onOrOff == null || onOrOff.equals("") || onOrOff.equalsIgnoreCase("on");
        assert (on || onOrOff.equalsIgnoreCase("off")) : "autocomplete must be '','on' or 'off'";
        if (!on) {
            Html5DomUtil.setPropertyString(this.getTextBoxBase(), "autocomplete", "off");
        }
    }

    @Override
    public HandlerRegistration addValidationHandler(ValidationHandler handler) {
        return this.validationHelper.addValidationHandler(handler);
    }

    @Override
    public HandlerRegistration addInvalidationHandler(InvalidationHandler handler) {
        return this.validationHelper.addInvalidationHandler(handler);
    }

    @Override
    public boolean isShowingSuggestions() {
        return this.isShowingSuggestions;
    }

    @Override
    public void suggestValuesFrom(SuggestOracle oracle) {
        this.suggestionDisplay = new SuggestionDisplay();
        this.suggestionDisplay.setEnabled(true);
        RootPanel.get().add((Widget)this.suggestionDisplay);
        this.suggestionManager = new SuggestionManager(oracle, this.base, this.suggestionDisplay);
        this.suggestionManager.addShowSuggestionHandler(this);
        this.suggestionManager.addHideSuggestionHandler(this);
        this.getTextBoxBase().addValueChangeHandler((ValueChangeHandler)this);
    }

    @Override
    public void onShowSuggestion(ShowSuggestionEvent event) {
        log.trace("is showing suggestions");
        this.isShowingSuggestions = true;
    }

    @Override
    public void onHideSuggestion(HideSuggestionEvent event) {
        log.trace("is not showing suggestions");
        this.isShowingSuggestions = false;
    }

    @Override
    public void onValueChange(ValueChangeEvent<String> event) {
        super.onValueChange(event);
        if (this.suggestionManager != null) {
            this.suggestionManager.onValueChange(event);
        }
    }

    public void onUnload() {
        this.validationHelper.onUnload();
    }

    public void setSuggestionsEnabled(boolean enabled) {
        assert (this.suggestionManager != null);
        this.suggestionManager.setEnabled(enabled);
    }
}

