/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.util;

import com.calpano.common.client.util.SelectableDropDown;
import com.calpano.common.client.view.forms.suggestion.ISuggestionDisplay;
import com.calpano.common.client.view.forms.suggestion.impl.SuggestionManager;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;

public class SuggestionDisplay
extends Composite
implements ISuggestionDisplay {
    private final SelectableDropDown<Selectable> dropdown = new SelectableDropDown();
    private SuggestionManager suggestionManager;
    private boolean enabled;

    public SuggestionDisplay() {
        this.initWidget((Widget)this.dropdown);
        this.dropdown.addSelectionHandler(new SelectionHandler<Selectable>(){

            public void onSelection(SelectionEvent<Selectable> event) {
                SuggestionDisplay.this.suggestionManager.fireSuggestionActivated(((Selectable)event.getSelectedItem()).suggestion);
            }
        });
    }

    @Override
    public SuggestOracle.Suggestion getCurrentSelection() {
        if (!this.enabled) {
            return null;
        }
        Selectable s = this.dropdown.getCurrentSelection();
        return s == null ? null : s.suggestion;
    }

    @Override
    public void hideSuggestions() {
        this.dropdown.hide();
    }

    @Override
    public void moveSelectionDown() {
        if (!this.enabled) {
            return;
        }
        this.dropdown.moveSelectionDown();
    }

    @Override
    public void moveSelectionUp() {
        if (!this.enabled) {
            return;
        }
        this.dropdown.moveSelectionUp();
    }

    @Override
    public void showSuggestions(SuggestionManager suggestionManager, Collection<? extends SuggestOracle.Suggestion> suggestions, boolean isAutoSelectEnabled, SuggestionManager.SuggestionCallback callback, boolean hasMoreSuggestions, int numMoreSuggestions) {
        if (!this.enabled) {
            return;
        }
        this.suggestionManager = suggestionManager;
        ArrayList<Selectable> items = new ArrayList<Selectable>();
        for (SuggestOracle.Suggestion suggestion : suggestions) {
            items.add(new Selectable(suggestion));
        }
        this.dropdown.positionBelow((Widget)suggestionManager.getTextBoxBase());
        this.dropdown.show(items, isAutoSelectEnabled ? 0 : -1);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    class Selectable
    implements SelectableDropDown.SelectableObject {
        final SuggestOracle.Suggestion suggestion;

        public Selectable(SuggestOracle.Suggestion suggestion) {
            this.suggestion = suggestion;
        }

        @Override
        public String getHtmlDisplayString() {
            return this.suggestion.getDisplayString();
        }
    }
}

