/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.util;

import com.calpano.common.client.view.ListItemWidget;
import com.calpano.common.client.view.UnorderedListWidget;
import com.calpano.common.client.view.resources.CommonResourceBundle;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class SelectableDropDown<T extends SelectableObject>
extends Composite
implements HasSelectionHandlers<T> {
    private static final Logger log = LoggerFactory.getLogger(SelectableDropDown.class);
    private final UnorderedListWidget ul;
    private int currentIndex = 0;
    private final List<T> displayedObjects = new ArrayList<T>();

    public SelectableDropDown() {
        CommonResourceBundle.INSTANCE.css().ensureInjected();
        this.ul = new UnorderedListWidget();
        this.initWidget((Widget)this.ul);
    }

    public T getCurrentSelection() {
        if (this.displayedObjects.size() == 0) {
            return null;
        }
        if (this.currentIndex == -1) {
            return null;
        }
        return (T)((SelectableObject)this.displayedObjects.get(this.currentIndex));
    }

    public void hide() {
        this.getStyleElement().getStyle().setDisplay(Style.Display.NONE);
    }

    public void moveSelectionDown() {
        if (this.displayedObjects.size() == 0) {
            return;
        }
        this.updateActiveSelection(this.currentIndex, (this.currentIndex + 1) % this.displayedObjects.size());
    }

    public void moveSelectionUp() {
        if (this.displayedObjects.size() == 0) {
            return;
        }
        this.updateActiveSelection(this.currentIndex, (this.currentIndex - 1 + this.displayedObjects.size()) % this.displayedObjects.size());
    }

    public void positionBelow(Widget reference) {
        int top = reference.getAbsoluteTop() + reference.getOffsetHeight();
        int left = reference.getAbsoluteLeft();
        this.addStyleName(CommonResourceBundle.INSTANCE.css().typeahead());
        this.addStyleName(CommonResourceBundle.INSTANCE.css().dropdownMenu());
        Style style = this.getStyleElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setTop((double)top, Style.Unit.PX);
        style.setLeft((double)left, Style.Unit.PX);
        style.setDisplay(Style.Display.BLOCK);
    }

    public void show(List<T> items, int initialSelected) {
        this.ul.clear();
        this.displayedObjects.clear();
        if (items.size() == 0) {
            this.hide();
            return;
        }
        int index = 0;
        for (final SelectableObject item : items) {
            this.displayedObjects.add(item);
            ListItemWidget li = new ListItemWidget();
            Anchor a = new Anchor();
            a.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    SelectionEvent.fire((HasSelectionHandlers)SelectableDropDown.this, (Object)item);
                }
            });
            final int itemIndex = index++;
            a.addMouseOverHandler(new MouseOverHandler(){

                public void onMouseOver(MouseOverEvent event) {
                    SelectableDropDown.this.updateActiveSelection(SelectableDropDown.this.currentIndex, itemIndex);
                }
            });
            a.addMouseOutHandler(new MouseOutHandler(){

                public void onMouseOut(MouseOutEvent event) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SelectableDropDown.this.updateActiveSelection(itemIndex, -1);
                        }
                    });
                }
            });
            a.setHTML(item.getHtmlDisplayString());
            li.setWidget((Widget)a);
            this.ul.add((Widget)li);
        }
        this.updateActiveSelection(-1, initialSelected);
    }

    private void updateActiveSelection(int oldIndex, int currentIndex) {
        this.currentIndex = currentIndex;
        if (oldIndex >= 0) {
            this.ul.getWidget(oldIndex).removeStyleName(CommonResourceBundle.INSTANCE.css().active());
        }
        if (currentIndex >= 0) {
            this.ul.getWidget(currentIndex).addStyleName(CommonResourceBundle.INSTANCE.css().active());
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<T> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public static interface SelectableObject {
        public String getHtmlDisplayString();
    }
}

