/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.common.client.data;

import com.calpano.common.client.data.DataEventWatcher;
import com.calpano.common.client.storage.MemoryModelStorage;
import com.calpano.common.shared.data.DataEvent;
import com.calpano.common.shared.data.DataEventCondition;
import com.calpano.common.shared.data.DataItemDefinition;
import com.calpano.common.shared.data.DataSink;
import com.calpano.common.shared.data.Snapshotizer;
import com.calpano.common.shared.data.Syncer;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xydra.base.XAddress;
import org.xydra.base.XId;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.rmof.impl.XExistsRevWritableModel;
import org.xydra.base.rmof.impl.memory.SimpleModel;
import org.xydra.core.XCopyUtils;
import org.xydra.core.model.impl.memory.IMemoryModel;
import org.xydra.core.model.impl.memory.MemoryModel;
import org.xydra.core.serialize.XydraParser;
import org.xydra.core.serialize.XydraSerializer;
import org.xydra.core.serialize.json.JsonParser;
import org.xydra.core.serialize.json.JsonSerializer;
import org.xydra.gwt.store.GwtXydraStoreRestClient;
import org.xydra.store.XydraStore;

public class DataManager {
    private final XId actorId;
    private final Map<XAddress, DataItemDefinition> dataItemDefinitionMap;
    private final DataSink dataSink;
    private final EventBus eventBus;
    private final Map<XAddress, Syncer> modelAddressToSyncerMap;
    private final String passwordHash;
    private final XId repoId;
    private final Snapshotizer.SnapshotizerCallback snapshotCallback;
    private final Snapshotizer snapshotizer;
    private final XydraStore store;
    private final Syncer.SyncerCallback syncerCallBack;

    public static XydraStore createStore(XId userId, String passwordHash, String restApiLocation) {
        return new GwtXydraStoreRestClient(restApiLocation, (XydraSerializer)new JsonSerializer(), (XydraParser)new JsonParser());
    }

    public static void registerWatcher(EventBus eventBus, AllEventsOccuredCallback callback, DataEventCondition ... eventConditions) {
        DataEventWatcher.watch(eventBus, callback, eventConditions);
    }

    public DataManager(XId actorId, XId repoId, String passwordHash, EventBus eventBus, List<DataItemDefinition> dataItemDefinitions, DataSink dataSink, String restApiLocation) {
        this.actorId = actorId;
        this.repoId = repoId;
        this.passwordHash = passwordHash;
        this.eventBus = eventBus;
        this.dataItemDefinitionMap = new HashMap<XAddress, DataItemDefinition>();
        for (DataItemDefinition dataItemDef : dataItemDefinitions) {
            this.dataItemDefinitionMap.put(dataItemDef.getModelAddress(), dataItemDef);
        }
        this.snapshotCallback = new Snapshotizer.SnapshotizerCallback(){

            public void onFailedSnapshot(XAddress modelAddress, Throwable exception) {
                DataManager.this.createAndFireDataEvent(modelAddress, DataEvent.ActionKind.FetchFailure, null);
            }

            public void onFailedSnapshotizer(Throwable exception) {
            }

            public void onSuccessfulSnapshot(XReadableModel snapshot) {
                SimpleModel simpleModel = new SimpleModel(snapshot.getAddress());
                XCopyUtils.copyDataAndRevisions((XReadableModel)snapshot, (XExistsRevWritableModel)simpleModel);
                MemoryModel model = new MemoryModel(DataManager.this.actorId, DataManager.this.passwordHash, (XExistsRevWritableModel)simpleModel);
                DataManager.this.createAndFireDataEvent(snapshot.getAddress(), DataEvent.ActionKind.FetchSuccess, (IMemoryModel)model);
                DataManager.this.createSyncerForModelIfNotPresent((IMemoryModel)model);
            }
        };
        this.syncerCallBack = new Syncer.SyncerCallback(){

            public void onFailedSync(XAddress modelAddress, Throwable exception) {
                DataManager.this.createAndFireDataEvent(modelAddress, DataEvent.ActionKind.SyncFailure, null);
            }

            public void onSuccessfulSync(IMemoryModel model, boolean hasChanges) {
                DataManager.this.createAndFireDataEvent(model.getAddress(), DataEvent.ActionKind.SyncSuccess, model);
            }
        };
        this.store = DataManager.createStore(null, null, restApiLocation);
        this.snapshotizer = new Snapshotizer(this.store);
        this.dataSink = dataSink;
        this.modelAddressToSyncerMap = new HashMap<XAddress, Syncer>();
        ArrayList<Event.Type> eventTypeList = new ArrayList<Event.Type>();
        for (DataItemDefinition itemDef : this.dataItemDefinitionMap.values()) {
            eventTypeList.add(itemDef.getEventType());
        }
        for (Event.Type eventType : eventTypeList) {
            this.dataSink.registerEventType(eventType);
        }
    }

    private void createAndFireDataEvent(XAddress modelAddress, DataEvent.ActionKind kind, IMemoryModel memoryModel) {
        DataEvent event = this.dataItemDefinitionMap.get(modelAddress).getEventPrototype();
        this.eventBus.fireEvent((Event)event.create(kind, (Object)memoryModel));
    }

    private void createSyncerForModelIfNotPresent(IMemoryModel model) {
        if (!this.modelAddressToSyncerMap.containsKey(model.getAddress())) {
            Syncer syncer = new Syncer(model, this.store);
            this.modelAddressToSyncerMap.put(model.getAddress(), syncer);
        }
    }

    private void getSnapshots(List<XAddress> modelAddressList) {
        this.snapshotizer.getModelSnapshots(this.actorId, this.passwordHash, this.snapshotCallback, modelAddressList);
    }

    public List<XAddress> loadDataLocal() {
        ArrayList<XAddress> locallyNotFoundModelAddresses = new ArrayList<XAddress>();
        for (DataItemDefinition dataItemDef : this.dataItemDefinitionMap.values()) {
            MemoryModelStorage storage = new MemoryModelStorage(this.actorId, this.repoId, this.passwordHash, dataItemDef.getLocalStorageKeyPrefix());
            IMemoryModel model = (IMemoryModel)storage.get();
            if (model != null) {
                this.createAndFireDataEvent(model.getAddress(), DataEvent.ActionKind.LoadSuccess, model);
                this.createSyncerForModelIfNotPresent(model);
                continue;
            }
            XAddress failedModelAddress = dataItemDef.getModelAddress();
            this.createAndFireDataEvent(failedModelAddress, DataEvent.ActionKind.LoadFailure, null);
            locallyNotFoundModelAddresses.add(failedModelAddress);
        }
        return locallyNotFoundModelAddresses;
    }

    public void loadDataTryLocalFirstThenRemote() {
        List<XAddress> locallyNotFoundModelAddresses = this.loadDataLocal();
        this.getSnapshots(locallyNotFoundModelAddresses);
    }

    public void store(DataItemDefinition dataItemDef) {
        IMemoryModel model = (IMemoryModel)this.dataSink.getDataForEventType(dataItemDef.getEventType());
        if (model != null) {
            MemoryModelStorage storage = new MemoryModelStorage(this.actorId, this.repoId, this.passwordHash, dataItemDef.getLocalStorageKeyPrefix());
            storage.store(model);
        }
    }

    public void synchronize(DataItemDefinition dataItemDef) {
        Syncer syncer = this.modelAddressToSyncerMap.get(dataItemDef.getModelAddress());
        if (syncer != null) {
            syncer.synchronize(this.syncerCallBack);
        }
    }

    public static interface AllEventsOccuredCallback {
        public void onAllEventsOccured();
    }
}

