/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.rest;

import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.query.ISonicQuery;
import com.sonicmetrics.core.shared.query.SonicQuery;
import com.sonicmetrics.core.shared.query.TimeConstraint;
import com.sonicmetrics.gaeserver.impl.GaeSonicDB;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.csv.HtmlTool;
import org.xydra.csv.ISparseTable;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.HtmlUtils;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.restless.utils.SharedHtmlUtils;
import org.xydra.sharedutils.URLUtils;
import org.xydra.xgae.gaeutils.AboutAppEngine;
import org.xydra.xgae.gaeutils.GaeTestfixer;

public class SonicAdminResource {
    private static final Logger log = LoggerFactory.getLogger(SonicAdminResource.class);
    private static final String PATH = "/sonicadmin";

    public static void restless(Restless restless, String prefix) {
        restless.addMethod(PATH, "GET", SonicAdminResource.class, "index", true, new RestlessParameter[]{new RestlessParameter("start", null), new RestlessParameter("end", null), new RestlessParameter("format", "html"), new RestlessParameter("category", "*"), new RestlessParameter("action", "*"), new RestlessParameter("label", "*"), new RestlessParameter("subject", "*"), new RestlessParameter("source", "*"), new RestlessParameter("delete", "false")});
    }

    public static void index(String startStr, String endStr, String filterKey, String filterValue, String format, String category, String action, String label, String subject, String source, String deleteStr, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Writer w;
        boolean delete;
        GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        long start = -1L;
        long end = -1L;
        if (startStr != null && endStr != null) {
            start = Long.parseLong(startStr);
            end = Long.parseLong(endStr);
        }
        boolean bl = delete = deleteStr != null && deleteStr.equals("true");
        if (start == -1L) {
            start = System.currentTimeMillis() - 3600000L;
            delete = false;
        }
        if (end == -1L) {
            end = System.currentTimeMillis();
            delete = false;
        }
        if (format.equals("csv")) {
            Date now = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
            String name = AboutAppEngine.getApplicationId() + "-" + sdf.format(now) + ".csv";
            log.info("Wrapping in file named " + name);
            res.setContentType("text/csv");
            res.addHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
            ServletOutputStream os = res.getOutputStream();
            w = new OutputStreamWriter((OutputStream)os, "utf-8");
        } else {
            ServletUtils.headers((HttpServletResponse)res, (String)"text/html");
            w = HtmlUtils.startHtmlPage((HttpServletResponse)res, (String)"Datalogger", (SharedHtmlUtils.HeadChild[])new SharedHtmlUtils.HeadChild[]{new SharedHtmlUtils.HeadLinkStyle("/s/xydebug.css")});
            w.write("<div class='xydebug'>");
            w.write("Browse logs " + SharedHtmlUtils.link((String)"/admin/datalog", (String)"from last hour") + " (or enter any other time scale) " + SharedHtmlUtils.form((SharedHtmlUtils.METHOD)SharedHtmlUtils.METHOD.GET, (String)"/admin/datalog/").withInputText("start", "" + start).withInputText("end", "" + end).withInputText("category", "*").withInputText("action", "*").withInputText("label", "*").withInputText("subject", "*").withInputText("source", "*").withInputText("delete", "false").withInputSubmit("Go") + "<br/>");
            w.write(SharedHtmlUtils.link((String)("/admin/sonicadmin?start=" + start + "&end=" + end + "&category=" + category + "&action=" + action + "&label=" + label + "&subject=" + subject + "&source=" + source + "&delete=false&format=csv"), (String)"Download as CSV") + "<br/>");
        }
        SonicQuery sq = ((SonicQuery.Builder)SonicQuery.build((TimeConstraint)TimeConstraint.fromTo((long)start, (long)end)).categoryActionLabelSubjectSource(category, action, label, subject, source)).done();
        if (start > -1L && end > -1L) {
            Pair filter = null;
            if (filterKey != null && !filterKey.equals("")) {
                filter = new Pair((Object)URLUtils.decode((String)filterKey), (Object)URLUtils.decode((String)filterValue));
            }
            if (format.equals("html")) {
                w.write("Query for logs [" + start + "," + end + "] with filter " + filter);
                if (delete) {
                    w.write("Deleting...");
                    GaeSonicDB.INSTANCE.delete((ISonicQuery)sq);
                }
                w.flush();
            }
            if (!delete) {
                SonicAdminResource.writeRecords(w, (ISonicQuery)sq, format, "key");
            }
        }
        if (format.equals("html")) {
            w.write("Done.");
            w.write("</div>");
            HtmlUtils.endHtmlPage((Writer)w);
        } else {
            w.flush();
            w.close();
        }
    }

    private static void writeRecords(Writer w, ISonicQuery sq, String format, String sortBy) throws IOException {
        Iterator it = GaeSonicDB.INSTANCE.query(sq).iterator();
        CsvTable table = new CsvTable();
        while (it.hasNext()) {
            ISonicEvent se = (ISonicEvent)it.next();
            String key = se.getKey();
            assert (key != null);
            Row row = table.getOrCreateRow(key, true);
            row.setValue("created", se.getWhen(), true);
            row.setValue("subject", se.getSubject(), true);
            row.setValue("category", se.getCategory(), true);
            row.setValue("action", se.getAction(), true);
            row.setValue("label", se.getLabel(), true);
            row.setValue("source", se.getSource(), true);
            row.setValue("key", se.getKey(), true);
            for (Map.Entry e : se.getExtensionData().entrySet()) {
                row.setValue((String)e.getKey(), (String)e.getValue(), true);
            }
        }
        if (format.equals("html")) {
            HtmlTool.writeToHtml((ISparseTable)table, (String)sortBy, (Writer)w);
        } else {
            table.writeTo(w);
        }
    }
}

