/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.rest;

import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicEvent;
import com.sonicmetrics.core.shared.rest.ISonicREST_API;
import com.sonicmetrics.gaeserver.impl.GaeSonicDB;
import com.sonicmetrics.gaeserver.rest.SonicResource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.ServletUtils;
import org.xydra.xgae.gaeutils.GaeTestfixer;

public class SendResource
extends SonicResource {
    public static final String EXT_LATITUDE = "latitude";
    public static final String EXT_LONGITUDE = "longitude";
    private static final Logger log = LoggerFactory.getLogger(SendResource.class);
    public static final Set<String> DEFINED_URL_KEYS = new HashSet<String>();
    private static final String X_AppEngine_CityLatLong = "X-AppEngine-CityLatLong";
    private static final long VERY_OLD = 1500000000L;

    public static void restless(Restless restless, boolean allowAll) {
        RestlessParameter[] sendParams = new RestlessParameter[]{new RestlessParameter("subject"), new RestlessParameter("when", null), new RestlessParameter("category", "world"), new RestlessParameter("action"), new RestlessParameter("label", null), new RestlessParameter("source", "lazyclient"), new RestlessParameter("uniqueid", null), new RestlessParameter("callback", null)};
        restless.addMethod("/post", "GET", SendResource.class, "send", !allowAll, sendParams);
        restless.addMethod("/post", "POST", SendResource.class, "send", !allowAll, sendParams);
        restless.addMethod("/v2/send", "GET", SendResource.class, "send", !allowAll, sendParams);
        restless.addMethod("/v2/send", "POST", SendResource.class, "send", !allowAll, sendParams);
    }

    public static void send(String subject, String whenStr, String category, String action, String label, String source, String uniqueId, String callback, IRestlessContext ctx) throws IOException {
        PrintWriter w;
        GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        long now = System.currentTimeMillis();
        StringBuilder errors = new StringBuilder();
        long when = 0L;
        if (SendResource.isDefined(whenStr)) {
            try {
                when = Long.parseLong(whenStr);
                if (when > now) {
                    log.info("Your event is in the future. Funky.");
                }
            }
            catch (NumberFormatException e) {
                String msg = "Could not parse '" + whenStr + "' as a long. Using current system time for event date.";
                log.debug(msg);
                errors.append(msg);
            }
        }
        if (when == 0L) {
            when = now;
        }
        SonicEvent.SeBuilder builder = SonicEvent.create((long)when);
        try {
            builder.action(action);
            builder.category(category);
            builder.source(source);
            builder.subject(subject);
            builder.label(label);
            if (uniqueId != null) {
                builder.uniqueId(uniqueId);
            }
        }
        catch (IllegalArgumentException e) {
            log.info("some invalid params", (Throwable)e);
            HttpServletResponse res = ctx.getResponse();
            res.sendError(400, e.getMessage());
            return;
        }
        Map paraMap = ctx.getRequest().getParameterMap();
        for (Map.Entry e : paraMap.entrySet()) {
            String key = (String)e.getKey();
            if (DEFINED_KEYS.contains(key)) continue;
            String value = null;
            try {
                value = ((String[])e.getValue())[0];
                builder.withParam(key, value);
            }
            catch (Throwable t) {
                log.warn("Could not add '" + key + "'='" + value + "'", t);
            }
        }
        String lat = builder.getExtensionDataValue(EXT_LATITUDE);
        String lon = builder.getExtensionDataValue(EXT_LONGITUDE);
        if (lat == null || lon == null) {
            String[] parts;
            String latlong = ctx.getRequest().getHeader(X_AppEngine_CityLatLong);
            log.trace("Found no valid latlong yet, parsing '" + latlong + "'");
            if (latlong != null && (parts = latlong.split(",")).length == 2) {
                lat = parts[0];
                lon = parts[1];
                builder.withParam(EXT_LATITUDE, lat);
                builder.withParam(EXT_LONGITUDE, lon);
                log.trace("Parsed lat:'" + lat + "' and long:'" + lon + "'");
            }
        }
        SonicEvent se = (SonicEvent)builder.build();
        GaeSonicDB.INSTANCE.receiveEvent((ISonicEvent)se);
        log.info("Recorded " + se.toJsonObject());
        HttpServletResponse res = ctx.getResponse();
        if (SendResource.isDefined(callback)) {
            ServletUtils.headers((HttpServletResponse)res, (int)200, (long)-1L, (String)"application/json");
            w = res.getWriter();
            ((Writer)w).write(callback + "(true)");
        } else {
            ServletUtils.headers((HttpServletResponse)res, (int)200, (long)-1L, (String)"text/html");
            w = res.getWriter();
            ((Writer)w).write("<h3>Event logged.</h3>You sent: <br/><pre> " + se.toJsonObject() + "</pre><br />");
        }
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    public static long fixUnixTimeInMilliseconds(long timestamp) {
        if (timestamp < 1500000000L) {
            return timestamp * 1000L;
        }
        return timestamp;
    }

    public static void main(String[] args) {
        System.out.println(SendResource.fixUnixTimeInMilliseconds(1339914855L));
        System.out.println(SendResource.fixUnixTimeInMilliseconds(1339914855000L));
    }

    static {
        for (String s : ISonicREST_API.RESERVED_KEYS) {
            DEFINED_URL_KEYS.add(s);
        }
    }
}

