/*
 * Decompiled with CFR 0.152.
 */
package com.sonicmetrics.gaeserver.impl;

import com.sonicmetrics.core.shared.ISonicEvent;
import com.sonicmetrics.core.shared.impl.memory.SonicEvent;
import com.sonicmetrics.gaeserver.impl.GaeSonicDB;
import java.util.Map;
import org.xydra.log.api.ILogListener;
import org.xydra.log.api.Logger;
import org.xydra.restless.utils.ServletUtils;

public class ToSonicEventsLogListener
implements ILogListener {
    public static final int TRACE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final String[] levels = new String[]{"trace", "debug", "info", "warn", "error"};

    public void warn(Logger log, String msg, Throwable t) {
        ToSonicEventsLogListener.handleLog(log, 3, msg, t);
    }

    public void warn(Logger log, String msg) {
        ToSonicEventsLogListener.handleLog(log, 3, msg, null);
    }

    public void trace(Logger log, String msg, Throwable t) {
        ToSonicEventsLogListener.handleLog(log, 0, msg, t);
    }

    public void trace(Logger log, String msg) {
        ToSonicEventsLogListener.handleLog(log, 0, msg, null);
    }

    public void info(Logger log, String msg, Throwable t) {
        ToSonicEventsLogListener.handleLog(log, 2, msg, t);
    }

    public void info(Logger log, String msg) {
        ToSonicEventsLogListener.handleLog(log, 2, msg, null);
    }

    public void error(Logger log, String msg, Throwable t) {
        ToSonicEventsLogListener.handleLog(log, 4, msg, t);
    }

    public void error(Logger log, String msg) {
        ToSonicEventsLogListener.handleLog(log, 4, msg, null);
    }

    public void debug(Logger log, String msg, Throwable t) {
        ToSonicEventsLogListener.handleLog(log, 1, msg, t);
    }

    public void debug(Logger log, String msg) {
        ToSonicEventsLogListener.handleLog(log, 1, msg, null);
    }

    public static void handleLog(Logger log, int level, String msg, Throwable t) {
        if (msg != null && msg.contains("DATA?")) {
            String dataQuery = msg.substring(msg.indexOf("DATA?") + "DATA?".length());
            Map map = ServletUtils.parseQueryString((String)dataQuery);
            if (t != null) {
                map.put("logExceptionClass", t.getClass().getName());
            }
            ISonicEvent se = (ISonicEvent)((SonicEvent.SeBuilder)SonicEvent.create((long)System.currentTimeMillis()).withParam("logLevel", levels[level])).withParams(map).build();
            GaeSonicDB.INSTANCE.receiveEvent(se);
        }
    }
}

