/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.calpano.kgif.io.common.IKgifStreamImporter;
import com.calpano.kgif.io.common.IRepeatableStreamSource;
import com.calpano.kgif.io.common.impl.FileStreamSource;
import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.io.ImportResult;
import de.xam.dwzmodel.io.import_from_x.ImportManager;
import de.xam.dwzmodel.state.CacheManager;
import de.xam.dwzmodel.state.DirStore;
import de.xam.dwzmodel.state.HistoryManager;
import de.xam.dwzmodel.state.KnowledgeModelState;
import de.xam.dwzmodel.state.ProjectProperties;
import de.xam.mybase.model.FileProgressReporter;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.texthtml.text.HumanReadableText;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xydra.base.id.XidCodec;
import org.xydra.index.IPair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IMultipartFormDataHandler;

class StateManager_Load {
    private static final Logger log = LoggerFactory.getLogger(StateManager_Load.class);

    StateManager_Load() {
    }

    private static ProjectProperties loadOrCreateProjectProperties(DirStore dirStore, IoProgressReporter iop) {
        ProjectProperties projectProperties;
        try {
            projectProperties = dirStore.readProjectProperties();
        }
        catch (IOException e) {
            log.warn("Could not read loadJob", (Throwable)e);
            throw new RuntimeException("Error", e);
        }
        if (projectProperties == null) {
            try {
                projectProperties = ProjectProperties.create(-21L, -21L);
            }
            catch (IOException e) {
                log.warn("Could not create projectProperties", (Throwable)e);
                iop.reportException((Throwable)e);
                throw new RuntimeException(e);
            }
            assert (projectProperties != null);
            try {
                dirStore.writeProjectProperties(projectProperties);
            }
            catch (IOException e) {
                log.warn("Could not write projectProperties", (Throwable)e);
                iop.reportException((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        assert (projectProperties != null);
        return projectProperties;
    }

    private static ImportJob createImportJob(DirStore dirStore, ProjectProperties projectProps, IoProgressReporter iop) {
        int stepNo;
        ArrayList<ProjectProperties.Step> listOfStepsWeCanProcess = new ArrayList<ProjectProperties.Step>();
        for (stepNo = 0; stepNo < projectProps.getNumberOfSteps(); ++stepNo) {
            ProjectProperties.Step step = projectProps.getStep(stepNo);
            assert (step != null);
            if (step.getProcess().equals("import")) {
                if (!StateManager_Load.isValid(step)) continue;
                listOfStepsWeCanProcess.add(step);
                continue;
            }
            if (ProjectProperties.PROCESS_DEPRECATED.contains(step.getProcess())) continue;
            iop.reportProgress("Found unknown process type '" + step.getProcess() + "', ignoring.");
        }
        projectProps.deleteAllSteps();
        for (stepNo = 0; stepNo < listOfStepsWeCanProcess.size(); ++stepNo) {
            ProjectProperties.Step targetStep = projectProps.createStep(stepNo);
            ProjectProperties.Step sourceStep = (ProjectProperties.Step)listOfStepsWeCanProcess.get(stepNo);
            targetStep.copyAllSubKeyValuesFrom(sourceStep);
        }
        ImportJob importJob = new ImportJob();
        for (int stepNo2 = 0; stepNo2 < projectProps.getNumberOfSteps(); ++stepNo2) {
            ProjectProperties.Step step = projectProps.getStep(stepNo2);
            String localName = step.getSourceFilename();
            assert (localName != null);
            File alreadyImportedFile = dirStore.getPublicFile(localName);
            if (alreadyImportedFile.exists()) {
                long ageNow;
                long ageAtImportTime = step.getSourceFileLastModified();
                if (ageAtImportTime == (ageNow = alreadyImportedFile.lastModified())) {
                    importJob.unchangedFiles.add(alreadyImportedFile);
                    continue;
                }
                importJob.updatedFiles.add(alreadyImportedFile);
                continue;
            }
            importJob.removedFiles.add(alreadyImportedFile);
        }
        List<IPair<File, IKgifStreamImporter>> lookImportableFiles = ImportManager.listFilesThatAreImportable(dirStore, iop);
        for (IPair<File, IKgifStreamImporter> importable : lookImportableFiles) {
            File importableFile = (File)importable.getFirst();
            if (importJob.unchangedFiles.contains(importableFile) || importJob.updatedFiles.contains(importableFile)) continue;
            assert (!importJob.removedFiles.contains(importableFile));
            importJob.addedFiles.add(importableFile);
            importJob.importers.put(importableFile, (IKgifStreamImporter)importable.getSecond());
        }
        return importJob;
    }

    private static boolean isValid(ProjectProperties.Step step) {
        return step.getRevision() >= 0L && step.getSourceFilename() != null && step.getSourceFileLastModified() < Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KnowledgeModelState doLoadState(DirStore dirStore, IMyBase myBase, IoProgressReporter iop) throws IOException {
        assert (dirStore != null);
        assert (dirStore.exists());
        assert (dirStore.isLockedOnThisOS());
        assert (myBase != null);
        DwzFileFormats.init();
        File reportFile = dirStore.getShadowFile(HumanReadableText.fullDate_HH_MM((long)TimeProvider.getCurrentTimeInMillis()) + "--" + XidCodec.encode((String)dirStore.getFileName(), (int)100) + "--" + "report.txt");
        FileProgressReporter fileReporter = new FileProgressReporter(reportFile);
        iop.addBaseReporter((IMultipartFormDataHandler.IProgressReporter)fileReporter);
        ProjectProperties projectProperties = StateManager_Load.loadOrCreateProjectProperties(dirStore, iop);
        iop.reportProgress("Adding built-in knowledge");
        MyBases.addBuiltins((IMyBase)myBase, (IoProgressReporter)iop);
        iop.reportProgress("Scanning for importable files");
        ImportJob importJob = StateManager_Load.createImportJob(dirStore, projectProperties, iop);
        try {
            HistoryManager historyManager;
            CacheManager cacheManager = CacheManager.create();
            if (HistoryManager.hasHistory(dirStore)) {
                iop.reportProgress("Found user-saved changes in history, loading those.");
                historyManager = HistoryManager.open(dirStore, projectProperties, cacheManager, myBase, iop, true);
            } else {
                if (!importJob.addedFiles.isEmpty()) {
                    iop.reportProgress("Trying to auto-import files");
                }
                for (File f : importJob.addedFiles) {
                    FileStreamSource source = new FileStreamSource(f);
                    IKgifStreamImporter importer = importJob.importers.get(f);
                    ImportResult importResult = ImportManager.doImportFromSourceToMyBaseWithImporter(dirStore, (IRepeatableStreamSource)source, importer, myBase, iop);
                    if (importResult.success) {
                        int stepNo = projectProperties.getNumberOfSteps();
                        ProjectProperties.Step step = projectProperties.createStep(stepNo);
                        step.setProcess("import");
                        step.setRevision(myBase.getXModel().getRevisionNumber());
                        step.setSourceFilename(f.getName());
                        step.setSourceFileLastModified(f.lastModified());
                    }
                    source.close();
                }
                iop.reportProgress("Done reading files into memory, now store as DWZ native storage format");
                historyManager = HistoryManager.writeMyBaseToHistory(dirStore, projectProperties, cacheManager, myBase, iop);
            }
            dirStore.writeProjectProperties(projectProperties);
            assert (dirStore.getHistoryFile().exists()) : "HistoryFile not found";
            historyManager.startRecordingChangesOn(dirStore, myBase.getXModel(), iop);
            KnowledgeModelState kms = new KnowledgeModelState(dirStore, projectProperties, historyManager);
            myBase.indexManager().assertIndexesAre_computed_updating(Boolean.valueOf(true), Boolean.valueOf(true));
            iop.reportProgressSuccess("Done");
            KnowledgeModelState knowledgeModelState = kms;
            return knowledgeModelState;
        }
        finally {
            try {
                fileReporter.close();
            }
            catch (Exception e) {
                log.trace("IO", (Throwable)e);
            }
            iop.removeBaseReporter((IMultipartFormDataHandler.IProgressReporter)fileReporter);
        }
    }

    static class ImportJob {
        Set<File> addedFiles = new HashSet<File>();
        Set<File> removedFiles = new HashSet<File>();
        Set<File> updatedFiles = new HashSet<File>();
        Set<File> unchangedFiles = new HashSet<File>();
        Map<File, IKgifStreamImporter> importers = new HashMap<File, IKgifStreamImporter>();

        ImportJob() {
        }
    }
}

