/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.state;

import com.calpano.common.server.util.ArrayUtils;
import de.xam.files.ReadersAndWriters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xydra.conf.IConfig;
import org.xydra.conf.impl.ConfigFiles;
import org.xydra.conf.impl.MemoryConfig;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class LockHolder {
    private static final Logger log = LoggerFactory.getLogger(LockHolder.class);
    private static final Map<File, LockHolder> map = new HashMap<File, LockHolder>();
    private FileChannel fileChannel;
    private final File fileOrDir;
    private FileLock javaFileLock;
    private RandomAccessFile raf;
    public static final String FILENAME_DIR_LOCK = "dir.lock";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LockHolder getOrCreateLockHolder(File f, boolean create) {
        Map<File, LockHolder> map = LockHolder.map;
        synchronized (map) {
            LockHolder lockHolder = LockHolder.map.get(f);
            if (lockHolder == null && create) {
                lockHolder = new LockHolder(f);
                LockHolder.map.put(f, lockHolder);
            }
            return lockHolder;
        }
    }

    private static boolean isRemoteLockFile(File lockMarkerFile) {
        if (!lockMarkerFile.exists()) {
            return false;
        }
        try {
            if (lockMarkerFile.length() == 0L) {
                return false;
            }
            IConfig conf = Env.get().conf();
            String localUuid = conf.getString("id-uuid");
            Object[] localMacAdresses = (String[])conf.tryToGetAs("id-macAdresses", String[].class);
            String localUserName = (String)conf.tryToGetAs("id-userName", String.class);
            String localHostname = (String)conf.tryToGetAs("id-hostName", String.class);
            MemoryConfig lockConf = new MemoryConfig();
            ConfigFiles.read((File)lockMarkerFile, (IConfig)lockConf);
            String remoteUuid = (String)lockConf.tryToGetAs("id-uuid", String.class);
            Object[] remoteMacAdresses = (String[])lockConf.tryToGetAs("id-macAdresses", String[].class);
            String remoteUserName = (String)lockConf.tryToGetAs("id-userName", String.class);
            String remoteHostname = (String)lockConf.tryToGetAs("id-hostName", String.class);
            if (remoteUuid == null) {
                log.info("Found an old lock file (DWZ < v1.5.4). Upgrading format. Assuming file is not remotely locked.");
                return false;
            }
            if (localUuid.equals(remoteUuid)) {
                return false;
            }
            if (localUserName.equals(remoteUserName) && localHostname.equals(remoteHostname)) {
                return false;
            }
            if (ArrayUtils.equalSet((Object[])localMacAdresses, (Object[])remoteMacAdresses)) {
                return false;
            }
            log.debug("Lock file was created on machine '" + remoteUuid + "' -- or you deleted your config file");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private LockHolder(File fileOrDir) {
        this.fileOrDir = fileOrDir;
    }

    private void createLockMarkerFile() {
        File lockMarkerFile = this.getLockMarkerFile();
        try {
            lockMarkerFile.createNewFile();
            MemoryConfig lockConf = new MemoryConfig();
            IConfig conf = Env.get().conf();
            lockConf.set("id-uuid", (Object)conf.getString("id-uuid"));
            lockConf.set("id-hostName", (Object)conf.getString("id-hostName"));
            lockConf.set("id-macAdresses", (Object)conf.getString("id-macAdresses"));
            lockConf.set("id-userName", (Object)conf.getString("id-userName"));
            ConfigFiles.write((IConfig)lockConf, (File)lockMarkerFile);
            lockMarkerFile.deleteOnExit();
        }
        catch (IOException e) {
            log.trace("Failed to create local lock file", (Throwable)e);
        }
    }

    public Map<String, String> getLockProperties() {
        File f = this.getLockMarkerFile();
        try {
            Properties props = new Properties();
            Reader r = ReadersAndWriters.getUtf8Reader((File)f);
            props.load(r);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                map.put(e.getKey().toString(), e.getValue().toString());
            }
            return map;
        }
        catch (IOException e) {
            log.warn("Could not read lock properties from " + f.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    public static File getDirLockFile(File dir) {
        return new File(dir, FILENAME_DIR_LOCK);
    }

    public File getLockMarkerFile() {
        File lockMarkerFile = null;
        lockMarkerFile = this.fileOrDir.isDirectory() ? LockHolder.getDirLockFile(this.fileOrDir) : new File(this.fileOrDir + ".lock");
        return lockMarkerFile;
    }

    public synchronized boolean isLocked() {
        return this.javaFileLock != null && this.javaFileLock.isValid();
    }

    public synchronized boolean lock() {
        File lockMarkerFile = this.getLockMarkerFile();
        try {
            this.raf = new RandomAccessFile(lockMarkerFile, "rw");
            this.fileChannel = this.raf.getChannel();
            try {
                this.javaFileLock = this.fileChannel.lock();
                boolean isValidLock = this.javaFileLock.isValid();
                if (isValidLock) {
                    if (LockHolder.isRemoteLockFile(lockMarkerFile)) {
                        this.unlock();
                        return false;
                    }
                    this.createLockMarkerFile();
                    return true;
                }
                this.unlock();
                return false;
            }
            catch (IOException e) {
                log.trace("Failed to obtain java file lock", (Throwable)e);
                this.unlock();
                return false;
            }
        }
        catch (FileNotFoundException e) {
            log.trace("Failed to access lock marker file", (Throwable)e);
            this.unlock();
            return false;
        }
    }

    public synchronized boolean cleanUp() {
        File lockMarkerFile = this.getLockMarkerFile();
        if (lockMarkerFile.exists()) {
            if (LockHolder.isRemoteLockFile(lockMarkerFile)) {
                return false;
            }
            try {
                Files.delete(this.getLockMarkerFile().toPath());
            }
            catch (IOException e) {
                log.trace("Failed to delete local lock file", (Throwable)e);
            }
        }
        return true;
    }

    public synchronized boolean unlock() {
        try {
            if (this.javaFileLock != null) {
                this.javaFileLock.release();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        boolean success = this.cleanUp();
        map.remove(this.fileOrDir);
        return success;
    }
}

