/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.persistence;

import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.texthtml.text.HumanReadableText;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class NextFiles {
    public static void deleteNextFiles(File dir) {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isFile() && name.endsWith(DwzFileFormats.NEXT.getDefaultExtension());
            }
        });
        if (files == null) {
            return;
        }
        for (File f : files) {
            f.delete();
        }
    }

    public static File getNextFile(File f) {
        return new File(f.getParentFile(), f.getName() + "." + DwzFileFormats.NEXT.getDefaultExtension());
    }

    public static boolean commitNextLargerFile(File currentFile) {
        assert (NextFiles.getNextFile(currentFile).exists());
        File nextFile = NextFiles.getNextFile(currentFile);
        if (currentFile.exists()) {
            double growth;
            if (nextFile.length() < currentFile.length() && (growth = (double)nextFile.length() / (double)currentFile.length()) < 0.8) {
                throw new IllegalStateException("Refusing to overwrite currente file " + currentFile.getAbsolutePath() + " (" + HumanReadableText.fileSize((long)currentFile.length()) + ") with factor " + growth + " smaller " + "." + DwzFileFormats.NEXT.getDefaultExtension() + " file (" + HumanReadableText.fileSize((long)nextFile.length()) + ", " + nextFile.getAbsolutePath() + ")");
            }
            currentFile.delete();
        }
        try {
            Files.move(nextFile.toPath(), currentFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to move " + NextFiles.getNextFile(currentFile).getAbsolutePath() + " to " + currentFile.getAbsolutePath(), e);
        }
    }
}

