/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.io.import_before_kgif;

import com.calpano.kgif.io.IFileFormat;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import de.xam.dwzmodel.io.DwzFileFormats;
import de.xam.dwzmodel.io.import_before_kgif.IStorageManger;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.HasIdComparator;
import de.xam.itemset.impl.LexicographicItemComparator;
import de.xam.itemset.impl.xydra.ItemSetXy;
import de.xam.itemset.impl.xydra.ItemXy;
import de.xam.itemset.impl.xydra.StatementXy;
import de.xam.mybase.model.IoProgressReporter;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.io.SchemaMigration_v100_v112;
import de.xam.texthtml.text.Unicodes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.id.RefId;
import org.xydra.base.rmof.XWritableField;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.base.value.impl.memory.MemoryLongValue;
import org.xydra.base.value.impl.memory.MemoryStringValue;
import org.xydra.core.model.XModel;
import org.xydra.index.iterator.Iterators;

public class StorageManager_v2_xstream
implements IStorageManger {
    static XStream xstream() {
        XStream xstream = new XStream();
        xstream.setMode(1001);
        xstream.alias("entityList", EntityList.class);
        xstream.alias("entity", Entity.class);
        xstream.alias("longValue", MemoryLongValue.class);
        xstream.alias("stringValue", MemoryStringValue.class);
        xstream.alias("id", RefId.class);
        xstream.registerConverter((SingleValueConverter)new LongValueConverter());
        xstream.registerConverter((SingleValueConverter)new StringValueConverter());
        return xstream;
    }

    @Override
    public boolean saveAs(IMyBase myBase, File file, String format, IoProgressReporter iop) throws IOException {
        IItemSet itemSet = myBase.itemSet();
        EntityList entityList = new EntityList();
        ArrayList itemList = Iterators.toArrayList((Iterator)itemSet.items());
        Collections.sort(itemList, new LexicographicItemComparator());
        for (IItem item : itemList) {
            ItemXy itemXy = (ItemXy)item;
            Entity entity = new Entity(itemXy.getId().toString());
            entity.copyDataFrom(itemXy.getXObject());
            entityList.objects.add(entity);
        }
        ArrayList statementList = Iterators.toArrayList((Iterator)itemSet.statements());
        Collections.sort(statementList, new HasIdComparator());
        for (IStatement stmt : statementList) {
            StatementXy stmtXy = (StatementXy)stmt;
            Entity entity = new Entity(stmtXy.getId().toString());
            entity.copyDataFrom(stmtXy.getXObject());
            entityList.objects.add(entity);
        }
        File itemFile = new File(file, "items.xml");
        itemFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(itemFile);
        OutputStreamWriter ows = new OutputStreamWriter((OutputStream)fos, Unicodes.UTF8);
        XStream xstream = StorageManager_v2_xstream.xstream();
        xstream.toXML((Object)entityList, (Writer)ows);
        return true;
    }

    @Override
    public boolean open(File file, IMyBase myBase, IoProgressReporter iop) throws IOException {
        assert (file.isDirectory());
        assert (file.exists());
        File itemFile = new File(file, "items.xml");
        FileInputStream fis = new FileInputStream(itemFile);
        InputStreamReader ows = new InputStreamReader((InputStream)fis, Unicodes.UTF8);
        XStream xstream = StorageManager_v2_xstream.xstream();
        EntityList entityList = (EntityList)xstream.fromXML((Reader)ows);
        assert (entityList.version.equals("v2"));
        IItemSet itemSet = myBase.itemSet();
        ItemSetXy itemSetXy = (ItemSetXy)itemSet;
        XModel writableXModel = itemSetXy.getXModel();
        for (Entity entity : entityList.objects) {
            XWritableObject xo = writableXModel.createObject(entity.getId());
            entity.copyDataTo(xo);
        }
        SchemaMigration_v100_v112.doSchemaMigration((IItemSet)myBase.itemSet());
        return true;
    }

    @Override
    public IFileFormat getFileFormat() {
        return DwzFileFormats.ITEMS_XML;
    }

    public static class IdConverter
    implements SingleValueConverter {
        public boolean canConvert(Class type) {
            return type.equals(RefId.class);
        }

        public String toString(Object obj) {
            return ((XId)obj).toString();
        }

        public Object fromString(String str) {
            return Base.toId((String)str);
        }
    }

    public static class StringValueConverter
    implements SingleValueConverter {
        public boolean canConvert(Class type) {
            return type.equals(MemoryStringValue.class);
        }

        public String toString(Object obj) {
            return ((MemoryStringValue)obj).contents();
        }

        public Object fromString(String str) {
            return XV.toValue((String)str);
        }
    }

    public static class LongValueConverter
    implements SingleValueConverter {
        public boolean canConvert(Class type) {
            return type.equals(MemoryLongValue.class);
        }

        public String toString(Object obj) {
            return "" + ((MemoryLongValue)obj).contents();
        }

        public Object fromString(String str) {
            return XV.toValue((long)Long.parseLong(str));
        }
    }

    public static class Entity {
        String idStr;
        Map<String, XValue> values = new HashMap<String, XValue>();

        public Entity(String idStr) {
            this.idStr = idStr;
        }

        public void copyDataFrom(XWritableObject xo) {
            for (XId fid : xo) {
                XWritableField field = xo.getField(fid);
                XValue value = field.getValue();
                this.values.put(fid.toString(), value);
            }
        }

        public XId getId() {
            return Base.toId((String)this.idStr);
        }

        public void copyDataTo(XWritableObject xo) {
            for (Map.Entry<String, XValue> e : this.values.entrySet()) {
                XId fid = Base.toId((String)e.getKey());
                XWritableField field = xo.createField(fid);
                field.setValue(e.getValue());
            }
        }
    }

    public static class EntityList {
        String version = "v2";
        List<Entity> objects = new ArrayList<Entity>();
    }
}

