/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.visual;

import de.xam.dwzmodel.graph2.calc.TriplePattern;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.dwzmodel.graph2.visual.VisualGraph;
import de.xam.itemset.IItem;
import de.xam.mybase.model.Labeler;
import java.util.Iterator;
import java.util.SortedSet;
import org.xydra.base.XId;
import org.xydra.index.query.ITriple;

public class VisualGraphs {
    public static final String CSS_CLASS_FRONTIER = "frontier";
    public static final int MAX_LINK_PATTERNS = 4;
    public static final int MAX_NODE_PATTERNS = 4;
    public static final int MIN_LINKS_PER_PATTERN = 3;
    public static final int MIN_NODES_PER_PATTERN = 2;

    static String toLabel(LogicalNode logicalNode) {
        assert (logicalNode != null);
        IItem item = logicalNode.getItem();
        if (item == null) {
            return logicalNode.getItemId() + "";
        }
        assert (item != null) : logicalNode.getItemId();
        return item.getDisplayString();
    }

    public static String toLabel(VisualGraph visualGraph, SortedSet<LogicalNode> logicalNodes) {
        StringBuilder b = new StringBuilder();
        Iterator it = logicalNodes.iterator();
        while (it.hasNext()) {
            LogicalNode logicalNode = (LogicalNode)it.next();
            assert (logicalNode != null);
            String part = VisualGraphs.toLabel(logicalNode);
            b.append(part);
            if (!it.hasNext()) continue;
            b.append(" /");
        }
        return b.toString();
    }

    public static String toLabel(VisualGraph graph, XId itemId) {
        IItem item = graph.getLogicalGraph().getMyBase().itemSet().getItemById(itemId);
        if (item == null) {
            return itemId.toString();
        }
        assert (item != null) : itemId;
        return Labeler.toLabel((IItem)item);
    }

    public static String toString(ITriple<LogicalNode, XId, LogicalNode> triple) {
        return "[" + ((LogicalNode)triple.s()).getItemId() + "]-[" + triple.p() + "]->[" + ((LogicalNode)triple.o()).getItemId() + "] " + (((LogicalNode)triple.s()).isFrontier() ? "|" : "*") + (((LogicalNode)triple.o()).isFrontier() ? "|" : "*");
    }

    public static String toString(LogicalNode node) {
        return node == null ? "*" : "[" + node.getItemId() + "]";
    }

    public static String toString(TriplePattern<LogicalNode, XId, LogicalNode> pattern) {
        return VisualGraphs.toString(pattern.s()) + "-" + (pattern.p() == null ? "*" : "[" + pattern.p() + "]") + "->" + VisualGraphs.toString(pattern.o());
    }

    private static String toString(XId id) {
        return id == null ? "*" : "[" + id + "]";
    }
}

