/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.visual;

import de.xam.dwzmodel.graph.VisualType;
import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.dwzmodel.graph2.visual.CaptionEntry;
import de.xam.dwzmodel.graph2.visual.VisualLink;
import de.xam.dwzmodel.graph2.visual.VisualNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.xydra.base.XId;
import org.xydra.index.impl.TripleSetIndexImpl;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class VisualGraph {
    private final List<CaptionEntry> captionEntries = new ArrayList<CaptionEntry>();
    private final SortedSet<VisualNode> centralNodes = new TreeSet<VisualNode>();
    private final TripleSetIndexImpl<VisualNode, XId, VisualNode, VisualLink> linkIndex = new TripleSetIndexImpl();
    private final Map<LogicalNode, VisualNode> logical2visualNodes = new HashMap<LogicalNode, VisualNode>();
    private final LogicalGraph logicalGraph;
    private final SortedSet<VisualLink> visualLinks = new TreeSet<VisualLink>();
    private static final Logger log = LoggerFactory.getLogger(VisualGraph.class);

    public VisualGraph(LogicalGraph logicalGraph) {
        this.logicalGraph = logicalGraph;
        for (LogicalNode centralLogicalNode : logicalGraph.getCentralNodes()) {
            VisualNode centralVisualNode = this.getOrCreateNode(centralLogicalNode);
            this.centralNodes.add(centralVisualNode);
        }
    }

    public CaptionEntry createCaption(VisualType visualType, String label) {
        CaptionEntry captionEntry = new CaptionEntry(visualType, label);
        this.captionEntries.add(captionEntry);
        return captionEntry;
    }

    public VisualLink createLink(LogicalNode logicalSource, XId relationType, LogicalNode logicalTarget) {
        VisualNode visualSource = this.getOrCreateNode(logicalSource);
        VisualNode visualTarget = this.getOrCreateNode(logicalTarget);
        return this.createLink(visualSource, relationType, visualTarget);
    }

    public VisualLink createLink(VisualNode visualSource, XId relationType, VisualNode visualTarget) {
        VisualLink visualLink = new VisualLink(this, visualSource, relationType, visualTarget);
        this.visualLinks.add(visualLink);
        this.linkIndex.index((Object)visualSource, (Object)relationType, (Object)visualTarget, (Object)visualLink);
        return visualLink;
    }

    public VisualNode getOrCreateNode(LogicalNode logicalNode) {
        VisualNode visualNode = this.logical2visualNodes.get(logicalNode);
        if (visualNode == null) {
            visualNode = new VisualNode(this, logicalNode);
            this.logical2visualNodes.put(logicalNode, visualNode);
        }
        return visualNode;
    }

    public Iterable<CaptionEntry> getCaptions() {
        return this.captionEntries;
    }

    public SortedSet<VisualNode> getCentralNodes() {
        return this.centralNodes;
    }

    public TripleSetIndexImpl<VisualNode, XId, VisualNode, VisualLink> getLinkIndex() {
        return this.linkIndex;
    }

    public Iterable<VisualLink> getLinks() {
        return this.visualLinks;
    }

    public LogicalGraph getLogicalGraph() {
        return this.logicalGraph;
    }

    public int getNodeCount() {
        return this.logical2visualNodes.values().size();
    }

    public Iterable<VisualNode> getNodes() {
        return this.logical2visualNodes.values();
    }

    public VisualNode getVisualByLogicalNode(LogicalNode logicalNode) {
        return this.logical2visualNodes.get(logicalNode);
    }

    public void remove(VisualLink visualLink) {
        this.visualLinks.remove(visualLink);
        this.linkIndex.deIndex((Object)visualLink.getSource(), (Object)visualLink.getRelationType(), (Object)visualLink.getTarget(), (Object)visualLink);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.linkIndex.toString());
        return b.toString();
    }

    public void dump() {
        log.info(this.toString());
    }
}

