/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.visual;

import de.xam.dwzmodel.graph.VisualType;
import de.xam.json.JON;
import java.util.ArrayList;
import java.util.List;
import org.xydra.base.XId;

public class CaptionEntry {
    private String cssString;
    private final List<String> labels = new ArrayList<String>();
    private int typeNumber;
    private final VisualType visualType;
    private XId xid;

    public String toString() {
        return "CaptionEntry [cssString=" + this.cssString + ", labels=" + this.labels + ", typeNumber=" + this.typeNumber + ", visualType=" + (Object)((Object)this.visualType) + ", xid=" + this.xid + "]";
    }

    public CaptionEntry(VisualType visualType, String label) {
        this.labels.add(label);
        this.visualType = visualType;
    }

    public String getCssString() {
        return this.cssString;
    }

    public JON getJON() {
        JON jon = JON.create();
        jon.putString("type", new String[]{this.visualType.toString().toLowerCase()});
        if (this.visualType == VisualType.Link) {
            jon.putString("label", new String[]{this.getLabels().get(0)});
        } else {
            assert (this.visualType == VisualType.Node);
            JON jonLabels = jon.goTo("labels");
            jonLabels.setTypeAsArray();
            jonLabels.add(this.getLabels());
        }
        if (this.getCssString() != null) {
            jon.putString("class", new String[]{this.getCssString()});
        }
        if (this.getLinkedId() != null) {
            jon.putString("xid", new String[]{this.getLinkedId().toString()});
        }
        jon.putInt("typenumber", new Integer[]{this.getTypeNumber()});
        return jon;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public XId getLinkedId() {
        return this.xid;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public VisualType getVisualType() {
        return this.visualType;
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public void setLinkedId(XId xid) {
        this.xid = xid;
    }

    public void setTypeNumber(int typeNumber) {
        this.typeNumber = typeNumber;
    }
}

