/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.logical;

import de.xam.dwzmodel.graph2.logical.LogicalEntity;
import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalLinkContainer;
import de.xam.itemset.IItem;
import java.util.Iterator;
import org.xydra.base.XId;
import org.xydra.index.impl.MapIndex;
import org.xydra.index.iterator.Iterators;

public class LogicalNode
extends LogicalEntity
implements Comparable<LogicalNode> {
    private int depth = -1;
    private final MapIndex<LogicalNode, LogicalLinkContainer> incomingLinksBySource = new MapIndex();
    private final LogicalLinkContainer selfLinks = new LogicalLinkContainer(this.getLogicalGraph(), this, this);
    private final XId itemId;
    private boolean markedAsFrontier = false;
    private final MapIndex<LogicalNode, LogicalLinkContainer> outgoingLinksByTarget = new MapIndex();

    LogicalNode(LogicalGraph logicalGraph, XId itemId, int depth) {
        super(logicalGraph);
        this.itemId = itemId;
        this.depth = depth;
    }

    @Override
    public int compareTo(LogicalNode o) {
        return this.itemId.compareTo((Object)o.itemId);
    }

    public boolean equals(Object other) {
        return other instanceof LogicalNode && ((LogicalNode)other).getItemId().equals((Object)this.getItemId());
    }

    public int getDepth() {
        return this.depth;
    }

    public LogicalLinkContainer getIncomingLinkFrom(LogicalNode source) {
        return (LogicalLinkContainer)this.incomingLinksBySource.lookup((Object)source);
    }

    public void deIndexIncomingLinks(LogicalNode sourceNode) {
        this.incomingLinksBySource.deIndex((Object)sourceNode);
    }

    public Iterable<LogicalLinkContainer> getIncomingLinks() {
        return this.incomingLinksBySource;
    }

    public LogicalLinkContainer getSelfLinks() {
        return this.selfLinks;
    }

    public IItem getItem() {
        return this.getLogicalGraph().getMyBase().itemSet().getItemById(this.itemId);
    }

    public XId getItemId() {
        return this.itemId;
    }

    public int getLinkCount() {
        return this.incomingLinksBySource.size() + this.outgoingLinksByTarget.size();
    }

    public Iterator<LogicalNode> getLinkedNodes() {
        return Iterators.distinct((Iterator)Iterators.concat((Iterator)this.incomingLinksBySource.keyIterator(), (Iterator)this.outgoingLinksByTarget.keyIterator()));
    }

    public boolean has_n_orMoreLinkedFrontierNodes(int n) {
        if (n > this.getLinkCount()) {
            return false;
        }
        int linkedFrontierNodesCount = 0;
        Iterator<LogicalNode> it = this.getLinkedNodes();
        while (it.hasNext()) {
            LogicalNode linkedLogicalNode = it.next();
            if (linkedLogicalNode.isFrontier()) {
                ++linkedFrontierNodesCount;
            }
            if (linkedFrontierNodesCount < n) continue;
            return true;
        }
        return false;
    }

    public Iterable<LogicalLinkContainer> getOutgoingLinks() {
        return this.outgoingLinksByTarget;
    }

    public LogicalLinkContainer getOutgoingLinkTo(LogicalNode target) {
        return (LogicalLinkContainer)this.outgoingLinksByTarget.lookup((Object)target);
    }

    public int hashCode() {
        return this.itemId.hashCode();
    }

    void indexIncomingLink(LogicalNode source, XId p) {
        LogicalLinkContainer linkContainer = (LogicalLinkContainer)this.incomingLinksBySource.lookup((Object)source);
        if (linkContainer == null) {
            linkContainer = new LogicalLinkContainer(this.getLogicalGraph(), source, this);
            this.incomingLinksBySource.index((Object)source, (Object)linkContainer);
        }
        linkContainer.addRelationType(p);
    }

    void indexOutgoingLink(XId p, LogicalNode target) {
        LogicalLinkContainer linkContainer = (LogicalLinkContainer)this.outgoingLinksByTarget.lookup((Object)target);
        if (linkContainer == null) {
            linkContainer = new LogicalLinkContainer(this.getLogicalGraph(), this, target);
            this.outgoingLinksByTarget.index((Object)target, (Object)linkContainer);
        }
        linkContainer.addRelationType(p);
    }

    void indexSelfLink(XId p) {
        this.selfLinks.addRelationType(p);
    }

    public boolean isFrontier() {
        return this.markedAsFrontier || !this.getLogicalGraph().isFullyExplored(this);
    }

    public void markAsFrontier() {
        this.markedAsFrontier = true;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String toString() {
        return "[" + this.itemId.toString() + "]" + this.depth + (this.isFrontier() ? "|" : "*");
    }
}

