/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph2.calc;

import de.xam.dwzmodel.graph.VisualType;
import de.xam.dwzmodel.graph2.calc.GraphEntropy;
import de.xam.dwzmodel.graph2.calc.LinkInfo;
import de.xam.dwzmodel.graph2.calc.LinkPattern;
import de.xam.dwzmodel.graph2.calc.NodePattern;
import de.xam.dwzmodel.graph2.logical.LogicalGraph;
import de.xam.dwzmodel.graph2.logical.LogicalLinkContainer;
import de.xam.dwzmodel.graph2.logical.LogicalNode;
import de.xam.dwzmodel.graph2.visual.CaptionEntry;
import de.xam.dwzmodel.graph2.visual.RelationPreferences;
import de.xam.dwzmodel.graph2.visual.VisualGraph;
import de.xam.dwzmodel.graph2.visual.VisualGraphs;
import de.xam.dwzmodel.graph2.visual.VisualLink;
import de.xam.dwzmodel.graph2.visual.VisualLinkType;
import de.xam.dwzmodel.graph2.visual.VisualNode;
import de.xam.dwzmodel.graph2.visual.VisualNodeType;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.xydra.base.XId;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.FastTripleMap;
import org.xydra.index.impl.MapMapSetIndex;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.ITriple;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.KeyKeyEntryTuple;
import org.xydra.index.query.KeyKeyKeyEntryTuple;
import org.xydra.index.query.Pair;
import org.xydra.index.query.Wildcard;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class VisualGraphMaker {
    private static final Logger log = LoggerFactory.getLogger(VisualGraphMaker.class);

    private static List<NodePattern> nodePattern_chooseBest_k(int resultSizeMax, MapSetIndex<NodePattern, LogicalNode> nodePattern2node, MapSetIndex<NodePattern, NodePattern> pattern2excludedPattern) {
        ArrayList<NodePattern> chosenPatterns = new ArrayList<NodePattern>();
        if (nodePattern2node.isEmpty()) {
            return chosenPatterns;
        }
        ArrayList topNodePatterns = new ArrayList(nodePattern2node.keySet());
        Collections.sort(topNodePatterns);
        HashSet<NodePattern> bestPath = null;
        double bestPathScore = 0.0;
        for (NodePattern startPattern : pattern2excludedPattern.keySet()) {
            NodePattern nodePattern;
            double pathScore = 0.0;
            HashSet<NodePattern> path = new HashSet<NodePattern>();
            path.add(startPattern);
            pathScore += startPattern.getScore();
            HashSet<NodePattern> excluded = new HashSet<NodePattern>();
            excluded.addAll(pattern2excludedPattern.lookup((Object)startPattern).toSet());
            while (path.size() < resultSizeMax && (nodePattern = VisualGraphMaker.nodePattern_findBestNext(pattern2excludedPattern, excluded)) != null) {
                assert (nodePattern2node.lookup((Object)nodePattern).size() >= 2) : "size=" + nodePattern2node.lookup((Object)nodePattern).size() + " in " + nodePattern;
                path.add(nodePattern);
                excluded.addAll(pattern2excludedPattern.lookup((Object)nodePattern).toSet());
                double bestNextPatternScore = nodePattern.getScore();
                pathScore += bestNextPatternScore;
            }
            if (!(pathScore > bestPathScore)) continue;
            bestPathScore = pathScore;
            bestPath = path;
        }
        chosenPatterns.addAll(bestPath);
        return chosenPatterns;
    }

    private static void createBestRemainingLinks(IMyBase myBase, XId s, XId o, IEntrySet<LinkInfo> so_linkInfo, IEntrySet<LinkInfo> os_linkInfo, LogicalGraph logicalGraph, VisualGraph visualGraph) {
        boolean reverse;
        LinkInfo best;
        double os_score;
        Iterator it;
        XId p;
        assert (!s.equals((Object)o));
        log.debug("Looking for best links from [" + s + "]--(...)->[" + o + "]");
        TreeSet<LinkInfo> so_stated = new TreeSet<LinkInfo>();
        TreeSet<LinkInfo> os_stated = new TreeSet<LinkInfo>();
        HashSet so_implied = new HashSet();
        HashSet os_implied = new HashSet();
        if (so_linkInfo != null) {
            for (LinkInfo linkInfo : so_linkInfo) {
                p = linkInfo.getRelation();
                it = MyBases.get_S_hasSuperType_X__inf((IMyBase)myBase, (XId)p);
                Iterators.addAll((Iterator)it, so_implied);
            }
        }
        if (os_linkInfo != null) {
            for (LinkInfo linkInfo : os_linkInfo) {
                p = linkInfo.getRelation();
                it = MyBases.get_S_hasSuperType_X__inf((IMyBase)myBase, (XId)p);
                Iterators.addAll((Iterator)it, os_implied);
            }
        }
        if (so_linkInfo != null) {
            for (LinkInfo linkInfo : so_linkInfo) {
                p = linkInfo.getRelation();
                if (so_implied.contains(p)) continue;
                so_stated.add(linkInfo);
            }
        }
        if (os_linkInfo != null) {
            for (LinkInfo linkInfo : os_linkInfo) {
                p = linkInfo.getRelation();
                if (os_implied.contains(p)) continue;
                os_stated.add(linkInfo);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Candidates '->': " + so_stated);
            log.trace("Candidates '<-': " + os_stated);
        }
        if (so_stated.isEmpty() && os_stated.isEmpty()) {
            return;
        }
        double so_score = so_stated.isEmpty() ? 0.0 : ((LinkInfo)so_stated.first()).getScore();
        double d = os_score = os_stated.isEmpty() ? 0.0 : ((LinkInfo)os_stated.first()).getScore();
        if (so_score >= os_score) {
            best = (LinkInfo)so_stated.first();
            reverse = false;
        } else {
            best = (LinkInfo)os_stated.first();
            reverse = true;
        }
        if (reverse) {
            LogicalNode logicalSource = logicalGraph.getNodeById(o);
            LogicalNode logicalTarget = logicalGraph.getNodeById(s);
            visualGraph.createLink(logicalSource, best.getRelation(), logicalTarget);
        } else {
            LogicalNode logicalSource = logicalGraph.getNodeById(s);
            LogicalNode logicalTarget = logicalGraph.getNodeById(o);
            visualGraph.createLink(logicalSource, best.getRelation(), logicalTarget);
        }
    }

    private static void dumpNodes(FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, LogicalGraph logicalGraph) {
        HashSet<LogicalNode> nodes = new HashSet<LogicalNode>();
        Iterator it = triple2linkInfo.tupleIterator((Object)null, null, null);
        while (it.hasNext()) {
            KeyKeyKeyEntryTuple ket = (KeyKeyKeyEntryTuple)it.next();
            XId s = (XId)ket.s();
            LogicalNode sNode = logicalGraph.getNodeById(s);
            nodes.add(sNode);
            XId o = (XId)ket.o();
            LogicalNode oNode = logicalGraph.getNodeById(o);
            nodes.add(oNode);
        }
        int fullyExplored = 0;
        for (LogicalNode node : nodes) {
            fullyExplored += node.isFrontier() ? 0 : 1;
        }
        log.info("Logical nodes: " + nodes.size() + ", " + fullyExplored + " fully explored");
        if (log.isTraceEnabled()) {
            for (LogicalNode node : nodes) {
                if (node.isFrontier()) continue;
                log.trace("  Logical node, fully explored: " + node);
            }
        }
    }

    private static NodePattern nodePattern_findBestNext(MapSetIndex<NodePattern, NodePattern> pattern2excludedPattern, Set<NodePattern> excluded) {
        double bestNextPatternScore = 0.0;
        NodePattern bestNextPattern = null;
        for (NodePattern nextPattern : pattern2excludedPattern.keySet()) {
            double nextScore;
            if (excluded.contains(nextPattern) || !((nextScore = nextPattern.getScore()) > bestNextPatternScore)) continue;
            bestNextPatternScore = nextScore;
            bestNextPattern = nextPattern;
        }
        return bestNextPattern;
    }

    public static Iterable<NodePattern> triple_generateNodePatterns(ITriple<XId, XId, XId> triple) {
        ArrayList<NodePattern> list = new ArrayList<NodePattern>();
        list.add(new NodePattern((XId)triple.s(), (XId)triple.p(), null));
        list.add(new NodePattern(null, (XId)triple.p(), (XId)triple.o()));
        return list;
    }

    private static LinkPattern linkPattern_findBestNext(LogicalGraph logicalGraph, FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, int minLinksPerPattern) {
        HashMap<XId, LinkPattern> id2linkPattern = new HashMap<XId, LinkPattern>();
        Iterator it = triple2linkInfo.keyKeyKeyIterator((Object)null, null, null);
        while (it.hasNext()) {
            ITriple coveredTriple = (ITriple)it.next();
            XId p = (XId)coveredTriple.p();
            LogicalNode sourceNode = logicalGraph.getNodeById((XId)coveredTriple.s());
            LogicalNode targetNode = logicalGraph.getNodeById((XId)coveredTriple.o());
            assert (!sourceNode.isFrontier() || !targetNode.isFrontier()) : "these should never be in triple2linkInfo: " + sourceNode + "--(" + p + ")--" + targetNode;
            if (id2linkPattern.containsKey(p)) continue;
            LinkPattern linkPattern = new LinkPattern(p);
            id2linkPattern.put(p, linkPattern);
            VisualGraphMaker.linkPattern_score(triple2linkInfo, logicalGraph, linkPattern);
        }
        ArrayList bestLinks = new ArrayList();
        bestLinks.addAll(id2linkPattern.values());
        for (LinkPattern linkPattern : id2linkPattern.values()) {
            if (linkPattern.countNonFrontier >= minLinksPerPattern) continue;
            bestLinks.remove(linkPattern);
        }
        if (bestLinks.isEmpty()) {
            return null;
        }
        Collections.sort(bestLinks);
        return (LinkPattern)bestLinks.get(0);
    }

    private static void linkPattern_score(FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, LogicalGraph logicalGraph, LinkPattern linkPattern) {
        if (log.isTraceEnabled()) {
            log.trace("Score link pattern " + linkPattern.p());
        }
        linkPattern.addScore(RelationPreferences.getRelationPreference((XId)linkPattern.p()));
        HashSet<Pair> coveredLinksNonFrontier = new HashSet<Pair>();
        HashSet<Pair> coveredLinksFrontier = new HashSet<Pair>();
        Iterator memberIt = triple2linkInfo.tupleIterator(null, linkPattern.p(), null);
        while (memberIt.hasNext()) {
            KeyKeyKeyEntryTuple ket = (KeyKeyKeyEntryTuple)memberIt.next();
            if (((XId)ket.s()).equals(ket.o())) continue;
            LinkInfo linkInfo = (LinkInfo)ket.getEntry();
            linkPattern.addScore(linkInfo.getScore());
            if (log.isTraceEnabled()) {
                log.trace("Score link pattern " + linkPattern.p() + " with " + ket);
            }
            for (ITriple impliedTriple : Iterators.from((Iterator)MyBases.getSuperAndInverseTriples((XId)((XId)ket.s()), (XId)((XId)ket.p()), (XId)((XId)ket.o()), (IMyBase)logicalGraph.getMyBase()))) {
                LinkInfo impliedLinkInfo;
                if (((XId)impliedTriple.s()).equals(impliedTriple.o()) || (impliedLinkInfo = (LinkInfo)triple2linkInfo.lookup(impliedTriple.s(), impliedTriple.p(), impliedTriple.o())) == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Score link pattern " + linkPattern.p() + " with " + impliedTriple);
                }
                linkPattern.addScore(impliedLinkInfo.getScore());
            }
            XId s = (XId)ket.s();
            XId o = (XId)ket.o();
            LogicalNode sNode = logicalGraph.getNodeById(s);
            LogicalNode oNode = logicalGraph.getNodeById(o);
            if (!s.equals((Object)o)) {
                if (s.compareTo((Object)o) < 0) {
                    XId a = s;
                    s = o;
                    o = a;
                }
                Pair covered = new Pair((Object)s, (Object)o);
                if (sNode.isFrontier() || oNode.isFrontier()) {
                    coveredLinksFrontier.add(covered);
                } else {
                    coveredLinksNonFrontier.add(covered);
                }
            }
            linkPattern.countFrontier(coveredLinksFrontier.size());
            linkPattern.countNonFrontier(coveredLinksNonFrontier.size());
        }
        if (log.isTraceEnabled()) {
            log.trace("Score link pattern " + linkPattern + " as " + linkPattern.getScore());
        }
    }

    private static LogicalNode nodePattern_getCoveredNode(LogicalGraph logicalGraph, NodePattern pattern, XId s, XId p, XId o) {
        return logicalGraph.getNodeById(VisualGraphMaker.nodePattern_getCoveredItemId(pattern, s, p, o));
    }

    private static XId nodePattern_getCoveredItemId(NodePattern pattern, XId s, XId p, XId o) {
        switch (pattern.getType()) {
            case XPO: {
                return s;
            }
            case SPX: {
                return o;
            }
        }
        throw new AssertionError();
    }

    public static GraphEntropy measureEntropy(VisualGraph visualGraph) {
        String label;
        GraphEntropy entropy = new GraphEntropy();
        for (VisualNode node : visualGraph.getNodes()) {
            if (node.hasCssClass("frontier")) continue;
            ++entropy.nodeCount;
            label = node.getLabel();
            entropy.nodeLabelChars += label.length();
        }
        for (VisualLink link : visualGraph.getLinks()) {
            if (link.hasCssClass("frontier")) continue;
            ++entropy.linkCount;
            label = link.getLabel();
            entropy.linkLabelChars += label.length();
        }
        for (CaptionEntry ce : visualGraph.getCaptions()) {
            ++entropy.captionCount;
            for (String label2 : ce.getLabels()) {
                entropy.captionLabelChars += label2.length();
            }
        }
        return entropy;
    }

    private static double score(LogicalLinkContainer linkContainer, XId p) {
        double a;
        double d = a = linkContainer.isFrontier() ? 0.0 : 1.0;
        assert (0.0 <= a && a <= 1.0);
        double b = RelationPreferences.getRelationPreference(p);
        assert (0.0 <= b && b <= 1.0);
        int linkCount = linkContainer.getSource().getLinkCount() + linkContainer.getTarget().getLinkCount();
        double c = Math.min(1.0, (double)linkCount / 100.0);
        assert (0.0 <= c && c <= 1.0) : "c = " + c;
        double score = 100.0 * a + 10.0 * b + c;
        if (log.isTraceEnabled()) {
            log.trace("score " + score + " for " + linkContainer.getSource() + "--" + p + "--" + linkContainer.getTarget() + " from a=" + a + " b=" + b + " c=" + c);
        }
        return score;
    }

    public static VisualGraph toVisualGraph_2(LogicalGraph logicalGraph) {
        LinkPattern linkPattern;
        log.info("====== Creating VisualGraph from " + logicalGraph.getStats());
        if (log.isTraceEnabled()) {
            for (LogicalNode node : logicalGraph.getNodes()) {
                if (node.isFrontier()) continue;
                log.trace("  Fully explored: " + node);
            }
        }
        IMyBase myBase = logicalGraph.getMyBase();
        VisualGraph visualGraph = new VisualGraph(logicalGraph);
        FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo = VisualGraphMaker.logicalGraph_Triple2LinkInfo(logicalGraph);
        MapSetIndex<NodePattern, LogicalNode> nodePattern2node = VisualGraphMaker.triples_nodePattern2logicalNode(myBase, logicalGraph, triple2linkInfo);
        MapSetIndex<NodePattern, NodePattern> nodePattern2excludedNodePattern = VisualGraphMaker.calcNodePattern2excludedNodePattern(myBase, triple2linkInfo, nodePattern2node);
        List<NodePattern> best_k_nodePatterns = VisualGraphMaker.nodePattern_chooseBest_k(4, nodePattern2node, nodePattern2excludedNodePattern);
        VisualGraphMaker.nodePattern_execute(myBase, triple2linkInfo, best_k_nodePatterns, logicalGraph, visualGraph);
        log.debug("=== Link Patterns");
        for (int linkPatternNo = 0; linkPatternNo < 4 && (linkPattern = VisualGraphMaker.linkPattern_findBestNext(logicalGraph, triple2linkInfo, 3)) != null; ++linkPatternNo) {
            VisualLinkType linkType = VisualLinkType.values()[linkPatternNo + 1];
            log.debug("Link pattern " + linkPattern + " type=" + (Object)((Object)linkType));
            VisualGraphMaker.linkPattern_execute(myBase, triple2linkInfo, logicalGraph, visualGraph, linkPattern, linkType);
        }
        VisualGraphMaker.addRemainingNodesAndLinks(myBase, triple2linkInfo, logicalGraph, visualGraph);
        VisualGraphMaker.pruneVisualGraphToSingleLink(myBase, visualGraph);
        return visualGraph;
    }

    private static void addRemainingNodesAndLinks(IMyBase myBase, FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, LogicalGraph logicalGraph, VisualGraph visualGraph) {
        MapMapSetIndex plannedLinks_sop = MapMapSetIndex.createWithFastSets();
        Iterator tupleIt = triple2linkInfo.tupleIterator(null, (Object)null, null);
        while (tupleIt.hasNext()) {
            KeyKeyKeyEntryTuple ket = (KeyKeyKeyEntryTuple)tupleIt.next();
            plannedLinks_sop.index(ket.s(), ket.o(), ket.getEntry());
        }
        for (VisualLink visualLink : visualGraph.getLinks()) {
            for (LogicalNode logicalSource : visualLink.getSource().getLogicalNodes()) {
                for (LogicalNode logicalTarget : visualLink.getTarget().getLogicalNodes()) {
                    plannedLinks_sop.deIndex((Object)logicalSource.getItemId(), (Object)logicalTarget.getItemId());
                    plannedLinks_sop.deIndex((Object)logicalTarget.getItemId(), (Object)logicalSource.getItemId());
                }
            }
        }
        for (KeyEntryTuple ket : Iterators.from((Iterator)plannedLinks_sop.keyKeyIterator((Constraint)new Wildcard(), (Constraint)new Wildcard()))) {
            XId o;
            XId s = (XId)ket.getFirst();
            if (s.equals((Object)(o = (XId)ket.getSecond()))) continue;
            IEntrySet so = plannedLinks_sop.lookup((Object)s, (Object)o);
            IEntrySet os = plannedLinks_sop.lookup((Object)o, (Object)s);
            if (so != null) {
                if (os != null && s.compareTo((Object)o) <= 0) continue;
                VisualGraphMaker.createBestRemainingLinks(myBase, s, o, (IEntrySet<LinkInfo>)so, (IEntrySet<LinkInfo>)os, logicalGraph, visualGraph);
                continue;
            }
            if (os == null) continue;
            VisualGraphMaker.createBestRemainingLinks(myBase, s, o, (IEntrySet<LinkInfo>)so, (IEntrySet<LinkInfo>)os, logicalGraph, visualGraph);
        }
    }

    private static void pruneVisualGraphToSingleLink(IMyBase myBase, VisualGraph visualGraph) {
        for (VisualNode source : visualGraph.getNodes()) {
            for (VisualNode target : visualGraph.getNodes()) {
                TreeSet secondary;
                TreeSet primary;
                TreeSet candidates = new TreeSet();
                Iterators.addAll((Iterator)visualGraph.getLinkIndex().lookup((Object)source, null, (Object)target), candidates);
                TreeSet invCandidates = new TreeSet();
                Iterators.addAll((Iterator)visualGraph.getLinkIndex().lookup((Object)target, null, (Object)source), invCandidates);
                if (candidates.size() + invCandidates.size() <= 1) continue;
                if (candidates.size() >= invCandidates.size()) {
                    primary = candidates;
                    secondary = invCandidates;
                } else {
                    primary = invCandidates;
                    secondary = candidates;
                }
                VisualLink bestLink = (VisualLink)primary.iterator().next();
                HashSet inversePs = new HashSet();
                for (VisualLink link : primary) {
                    XId p = link.getRelationType();
                    Iterators.addAll((Iterator)MyBases.getInverses((IMyBase)myBase, (XId)p), inversePs);
                }
                Iterator it = secondary.iterator();
                while (it.hasNext()) {
                    VisualLink visualLink = (VisualLink)it.next();
                    if (!inversePs.contains(visualLink.getRelationType())) continue;
                    it.remove();
                    visualGraph.remove(visualLink);
                }
                int moreLinks = primary.size() - 1;
                int moreInvLinks = secondary.size();
                String label = VisualGraphs.toLabel(visualGraph, bestLink.getRelationType());
                if (moreLinks > 0 || moreInvLinks > 0) {
                    label = label + " (+" + moreLinks + "/" + moreInvLinks + ")";
                }
                bestLink.setLabel(label);
                for (VisualLink link : candidates) {
                    if (bestLink == link) continue;
                    visualGraph.remove(link);
                }
                for (VisualLink link : invCandidates) {
                    if (bestLink == link) continue;
                    visualGraph.remove(link);
                }
            }
        }
    }

    private static void linkPattern_execute(IMyBase myBase, FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, LogicalGraph logicalGraph, VisualGraph visualGraph, LinkPattern linkPattern, VisualLinkType linkType) {
        XId linkRelation = (XId)linkPattern.p();
        String pLabel = VisualGraphs.toLabel(visualGraph, linkRelation);
        CaptionEntry caption = visualGraph.createCaption(VisualType.Link, pLabel);
        caption.setTypeNumber(linkType.ordinal());
        caption.setLinkedId(linkRelation);
        for (KeyKeyEntryTuple triple : Iterators.toList((Iterator)triple2linkInfo.keyKeyKeyIterator(null, (Object)linkRelation, null))) {
            LogicalNode sourceNode = logicalGraph.getNodeById((XId)triple.s());
            LogicalNode targetNode = logicalGraph.getNodeById((XId)triple.o());
            VisualLink visualLink = visualGraph.createLink(sourceNode, linkRelation, targetNode);
            visualLink.setType(linkType);
        }
        ArrayList<ITriple> toDelete = new ArrayList<ITriple>();
        Iterator it = triple2linkInfo.keyKeyKeyIterator(linkPattern.s(), linkPattern.p(), linkPattern.o());
        while (it.hasNext()) {
            ITriple t = (ITriple)it.next();
            if (log.isTraceEnabled()) {
                log.trace("Link Pattern " + linkPattern + " includes " + t);
            }
            toDelete.add(t);
            Iterator impliedTripleIt = MyBases.getSuperAndInverseTriples((XId)((XId)t.s()), (XId)((XId)t.p()), (XId)((XId)t.o()), (IMyBase)myBase);
            while (impliedTripleIt.hasNext()) {
                ITriple impliedTriple = (ITriple)impliedTripleIt.next();
                if (log.isTraceEnabled()) {
                    log.trace("Link Pattern " + linkPattern + " includes " + impliedTriple);
                }
                toDelete.add(impliedTriple);
            }
        }
        for (ITriple triple : toDelete) {
            triple2linkInfo.deIndex(triple.s(), triple.p(), triple.o());
        }
    }

    private static void nodePattern_execute(IMyBase myBase, FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, List<NodePattern> best_k_nodePatterns, LogicalGraph logicalGraph, VisualGraph visualGraph) {
        int patternCount = Math.min(4, best_k_nodePatterns.size());
        for (int i = 0; i < patternCount; ++i) {
            NodePattern nodePattern = best_k_nodePatterns.get(i);
            VisualNodeType nodeType = VisualNodeType.values()[i + 1];
            if (log.isDebugEnabled()) {
                log.debug("Node pattern: " + nodePattern + " -> type '" + (Object)((Object)nodeType) + "'");
            }
            switch (nodePattern.getType()) {
                case XPO: {
                    String pLabel = VisualGraphs.toLabel(visualGraph, (XId)nodePattern.p());
                    String oLabel = VisualGraphs.toLabel(visualGraph, (XId)nodePattern.o());
                    CaptionEntry caption = visualGraph.createCaption(VisualType.Node, "= " + pLabel + " \u2192 " + oLabel);
                    caption.setTypeNumber(nodeType.ordinal());
                    break;
                }
                case SPX: {
                    String sLabel = VisualGraphs.toLabel(visualGraph, (XId)nodePattern.s());
                    String pLabel = VisualGraphs.toLabel(visualGraph, (XId)nodePattern.p());
                    CaptionEntry caption = visualGraph.createCaption(VisualType.Node, sLabel + "  -(" + pLabel + ")\u2192  X");
                    caption.setTypeNumber(nodeType.ordinal());
                }
            }
            ArrayList<ITriple> toDelete = new ArrayList<ITriple>();
            Iterator it = triple2linkInfo.keyKeyKeyIterator(nodePattern.s(), nodePattern.p(), nodePattern.o());
            while (it.hasNext()) {
                ITriple t = (ITriple)it.next();
                LogicalNode coveredNode = VisualGraphMaker.nodePattern_getCoveredNode(logicalGraph, nodePattern, (XId)t.s(), (XId)t.p(), (XId)t.o());
                VisualNode visualNode = visualGraph.getOrCreateNode(coveredNode);
                visualNode.setType(nodeType);
                if (log.isTraceEnabled()) {
                    log.trace("Pattern " + nodePattern + " includes " + t);
                }
                toDelete.add(t);
                Iterator impliedTripleIt = MyBases.getSuperAndInverseTriples((XId)((XId)t.s()), (XId)((XId)t.p()), (XId)((XId)t.o()), (IMyBase)logicalGraph.getMyBase());
                while (impliedTripleIt.hasNext()) {
                    ITriple impliedTriple = (ITriple)impliedTripleIt.next();
                    if (log.isTraceEnabled()) {
                        log.trace("Pattern " + nodePattern + " includes " + impliedTriple);
                    }
                    toDelete.add(impliedTriple);
                }
            }
            for (ITriple triple : toDelete) {
                triple2linkInfo.deIndex(triple.s(), triple.p(), triple.o());
            }
        }
    }

    private static MapSetIndex<NodePattern, NodePattern> calcNodePattern2excludedNodePattern(IMyBase myBase, FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo, MapSetIndex<NodePattern, LogicalNode> nodePattern2node) {
        MapSetIndex itemId2nodePattern = MapSetIndex.createWithFastEntrySets();
        MapSetIndex nodePattern2excludedNodePattern = MapSetIndex.createWithFastEntrySets();
        for (NodePattern pattern : nodePattern2node.keySet()) {
            VisualGraphMaker.nodePattern_score(pattern);
            int coveredTriples = 0;
            for (KeyKeyKeyEntryTuple tripleInfo : Iterators.from((Iterator)triple2linkInfo.tupleIterator(pattern.s(), pattern.p(), pattern.o()))) {
                LinkInfo linkInfo = (LinkInfo)tripleInfo.getEntry();
                double tripleScore = linkInfo.getScore();
                pattern.addScore(tripleScore);
                ++coveredTriples;
                XId coveredItemId = VisualGraphMaker.nodePattern_getCoveredItemId(pattern, (XId)tripleInfo.s(), (XId)tripleInfo.p(), (XId)tripleInfo.o());
                itemId2nodePattern.index((Object)coveredItemId, (Object)pattern);
                for (ITriple impliedTriple : Iterators.from((Iterator)MyBases.getSuperAndInverseTriples((XId)((XId)tripleInfo.s()), (XId)((XId)tripleInfo.p()), (XId)((XId)tripleInfo.o()), (IMyBase)myBase))) {
                    assert (impliedTriple != null);
                    LinkInfo impliedLinkInfo = (LinkInfo)triple2linkInfo.lookup(impliedTriple.s(), impliedTriple.p(), impliedTriple.o());
                    if (impliedLinkInfo == null) continue;
                    double superTripleScore = impliedLinkInfo.getScore();
                    pattern.addScore(superTripleScore);
                    ++coveredTriples;
                    XId coveredSuperItemId = VisualGraphMaker.nodePattern_getCoveredItemId(pattern, (XId)impliedTriple.s(), (XId)impliedTriple.p(), (XId)impliedTriple.o());
                    itemId2nodePattern.index((Object)coveredSuperItemId, (Object)pattern);
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Scoring pattern " + pattern + " as " + pattern.getScore() + " coveredTriples=" + coveredTriples);
        }
        for (NodePattern pattern : nodePattern2node.keySet()) {
            nodePattern2excludedNodePattern.index((Object)pattern, (Object)pattern);
            for (LogicalNode node : nodePattern2node.lookup((Object)pattern)) {
                for (NodePattern excludedPattern : itemId2nodePattern.lookup((Object)node.getItemId())) {
                    nodePattern2excludedNodePattern.index((Object)pattern, (Object)excludedPattern);
                }
            }
        }
        return nodePattern2excludedNodePattern;
    }

    private static void nodePattern_score(NodePattern pattern) {
        if (pattern.p() == null) {
            pattern.addScore(1.0);
        } else {
            pattern.addScore(RelationPreferences.getRelationPreference((XId)pattern.p()));
        }
        if (pattern.s() == null) {
            pattern.addScore(1.0);
        }
    }

    private static FastTripleMap<XId, XId, XId, LinkInfo> logicalGraph_Triple2LinkInfo(LogicalGraph logicalGraph) {
        FastTripleMap triple2linkInfo = new FastTripleMap();
        int tripleCount = 0;
        for (LogicalLinkContainer linkContainer : Iterators.from(logicalGraph.getOutgoingLinks())) {
            LogicalNode sourceNode = linkContainer.getSource();
            LogicalNode targetNode = linkContainer.getTarget();
            if (sourceNode.isFrontier() && targetNode.isFrontier()) continue;
            for (XId p : linkContainer.getRelationTypes()) {
                LinkInfo linkInfo = new LinkInfo(p);
                triple2linkInfo.index((Object)sourceNode.getItemId(), (Object)p, (Object)targetNode.getItemId(), (Object)linkInfo);
                double score = VisualGraphMaker.score(linkContainer, p);
                linkInfo.addScore(score);
                ++tripleCount;
                if (!log.isTraceEnabled()) continue;
                log.trace("Scoring triple " + linkContainer.getSource() + "," + p + "," + linkContainer.getTarget() + " as " + score);
            }
        }
        log.debug("Indexed " + tripleCount + " triples");
        return triple2linkInfo;
    }

    private static MapSetIndex<NodePattern, LogicalNode> triples_nodePattern2logicalNode(IMyBase myBase, LogicalGraph logicalGraph, FastTripleMap<XId, XId, XId, LinkInfo> triple2linkInfo) {
        MapSetIndex nodePattern2node = MapSetIndex.createWithFastEntrySets();
        for (ITriple triple : Iterators.from((Iterator)triple2linkInfo.keyKeyKeyIterator(null, (Object)null, null))) {
            for (NodePattern nodePattern : VisualGraphMaker.triple_generateNodePatterns((ITriple<XId, XId, XId>)triple)) {
                if (nodePattern2node.containsKey((Object)nodePattern)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Found new, unscored node pattern " + nodePattern);
                }
                for (ITriple matchingTriple : Iterators.from((Iterator)triple2linkInfo.keyKeyKeyIterator(nodePattern.s(), nodePattern.p(), nodePattern.o()))) {
                    boolean indexed;
                    if (log.isTraceEnabled()) {
                        log.trace("Pattern includes " + matchingTriple);
                    }
                    if (!(indexed = VisualGraphMaker.triples_nodePattern2logicalNode_index(logicalGraph, nodePattern, (ITriple<XId, XId, XId>)matchingTriple, (MapSetIndex<NodePattern, LogicalNode>)nodePattern2node))) continue;
                    for (ITriple impliedTriple : Iterators.from((Iterator)MyBases.getSuperAndInverseTriples((XId)((XId)matchingTriple.s()), (XId)((XId)matchingTriple.p()), (XId)((XId)matchingTriple.o()), (IMyBase)logicalGraph.getMyBase()))) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Pattern includes implied " + impliedTriple);
                        VisualGraphMaker.triples_nodePattern2logicalNode_index(logicalGraph, nodePattern, (ITriple<XId, XId, XId>)impliedTriple, (MapSetIndex<NodePattern, LogicalNode>)nodePattern2node);
                    }
                }
            }
        }
        log.debug("Patterns with at least 1 node:  " + nodePattern2node.size());
        Iterator it = nodePattern2node.getEntries().iterator();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            if (((IEntrySet)e.getValue()).size() >= 2) continue;
            it.remove();
        }
        log.debug("Patterns with at least 2 nodes: " + nodePattern2node.size());
        return nodePattern2node;
    }

    private static boolean triples_nodePattern2logicalNode_index(LogicalGraph logicalGraph, NodePattern nodePattern, ITriple<XId, XId, XId> triple, MapSetIndex<NodePattern, LogicalNode> nodePattern2node) {
        LogicalNode coveredNode = VisualGraphMaker.nodePattern_getCoveredNode(logicalGraph, nodePattern, (XId)triple.s(), (XId)triple.p(), (XId)triple.o());
        if (coveredNode.isFrontier()) {
            return false;
        }
        nodePattern2node.index((Object)nodePattern, (Object)coveredNode);
        return true;
    }

    public static VisualGraph toVisualGraph_naive(LogicalGraph logicalGraph) {
        VisualGraph visualGraph = new VisualGraph(logicalGraph);
        for (LogicalNode logicalNode : logicalGraph.getNodes()) {
            VisualNode visualNode = visualGraph.getOrCreateNode(logicalNode);
            for (LogicalLinkContainer logicalLink : logicalNode.getOutgoingLinks()) {
                XId relationType = logicalLink.getRelationTypes().iterator().next();
                LogicalNode logicalSource = logicalLink.getSource();
                LogicalNode logicalTarget = logicalLink.getTarget();
                VisualLink visualLink = visualGraph.createLink(logicalSource, relationType, logicalTarget);
            }
        }
        return visualGraph;
    }

    public static VisualGraph tryToShrinkNodeNumberDownTo(VisualGraph visualGraph, int maxTotalNodes) {
        return visualGraph;
    }
}

