/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.visual.impl;

import com.google.common.collect.Sets;
import de.xam.dwzmodel.graph.VisualType;
import de.xam.dwzmodel.graph.logical.LogicalNode;
import de.xam.dwzmodel.graph.visual.IVisualNode;
import de.xam.dwzmodel.graph.visual.impl.VisualEntity;
import de.xam.dwzmodel.graph.visual.impl.VisualGraph;
import de.xam.json.JON;
import de.xam.mybase.model.content.UriFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import org.fest.util.Collections;
import org.xydra.base.XId;

class VisualNode
extends VisualEntity
implements IVisualNode {
    private int linkCount = 0;
    private final SortedSet<LogicalNode> logicalNodes;

    public VisualNode(VisualGraph graph, LogicalNode logicalNode, JON jsonAttributes) {
        super(graph);
        this.logicalNodes = Sets.newTreeSet((Iterable)Collections.list((Object)logicalNode));
        if (jsonAttributes != null) {
            this.jsonAttributes.putAll(jsonAttributes);
        }
    }

    public VisualNode(VisualGraph graph, Collection<LogicalNode> logicalNodes, JON jsonAttributes) {
        super(graph);
        this.logicalNodes = Sets.newTreeSet(logicalNodes);
        if (jsonAttributes != null) {
            this.jsonAttributes.putAll(jsonAttributes);
        }
    }

    public boolean contains(XId id) {
        for (LogicalNode logicalNode : this.getLogicalNodes()) {
            if (!logicalNode.getBaseEntity().getId().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public VisualType getVisualType() {
        return VisualType.Node;
    }

    public int hashCode() {
        int hash = 31;
        for (LogicalNode logicalNode : this.logicalNodes) {
            hash *= logicalNode.hashCode();
        }
        return hash;
    }

    @Override
    public LogicalNode getPrimaryLogicalNode() {
        return this.logicalNodes.first();
    }

    public boolean equals(Object o) {
        if (o instanceof VisualNode) {
            return ((VisualNode)o).getPrimaryLogicalNode().equals(this.getPrimaryLogicalNode());
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[NODE " + this.getPrimaryLogicalNode() + "]==" + this.logicalNodes);
        return b.toString();
    }

    @Override
    public int getLinkCount() {
        return this.linkCount;
    }

    @Override
    public void setLinkCount(int i) {
        this.linkCount = i;
    }

    @Override
    public SortedSet<LogicalNode> getLogicalNodes() {
        return this.logicalNodes;
    }

    public String getLabel() {
        if (this.logicalNodes.size() == 1) {
            return this.getPrimaryLogicalNode().getLabel();
        }
        StringBuilder b = new StringBuilder();
        Iterator it = this.logicalNodes.iterator();
        while (it.hasNext()) {
            LogicalNode logicalNode = (LogicalNode)it.next();
            String label = logicalNode.getLabel();
            b.append(label);
            if (!it.hasNext()) continue;
            b.append(" / ");
        }
        return UriFormatter.toShortAndRelevantString((String)b.toString(), this.getGraph().getLogicalGraph().getNamespaces(), (boolean)true);
    }
}

