/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.logical;

import de.xam.dwzmodel.graph.GraphJob;
import de.xam.dwzmodel.graph.logical.LogicalGraph;
import de.xam.dwzmodel.graph.logical.LogicalLink;
import de.xam.itemset.CDS;
import de.xam.itemset.IStatement;
import de.xam.mybase.model.api.IMyBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.index.query.ITriple;

public class LogicalGraphs {
    public static List<LogicalLink> explore(IMyBase myBase, GraphJob job, LogicalGraph logicalGraph, XId entityId, int depth) {
        ArrayList<LogicalLink> links = new ArrayList<LogicalLink>();
        Iterator forwardIt = myBase.infModel().getTriples(entityId, null, null);
        while (forwardIt.hasNext()) {
            ITriple triple = (ITriple)forwardIt.next();
            if (!LogicalGraphs.shouldIndexTriple((ITriple<XId, XId, XId>)triple, depth)) continue;
            LogicalGraphs.indexLink(myBase, job, logicalGraph, (ITriple<XId, XId, XId>)triple, links, false);
        }
        Iterator backwardIt = myBase.infModel().getTriples(null, null, entityId);
        while (backwardIt.hasNext()) {
            ITriple triple = (ITriple)backwardIt.next();
            if (!LogicalGraphs.shouldIndexTriple((ITriple<XId, XId, XId>)triple, depth)) continue;
            LogicalGraphs.indexLink(myBase, job, logicalGraph, (ITriple<XId, XId, XId>)triple, links, true);
        }
        return links;
    }

    private static boolean shouldIndexTriple(ITriple<XId, XId, XId> triple, int depth) {
        boolean b = depth < 1 || !LogicalGraphs.isAutoLinkRelation((XId)triple.p()) && !LogicalGraphs.isLinkRelation((XId)triple.p()) && !LogicalGraphs.isLinkRelation((XId)triple.p()) && !LogicalGraphs.isRelatedLinkRelation((XId)triple.p());
        return b;
    }

    private static boolean isAutoLinkRelation(XId p) {
        return p.equals(CDS.INSTANCE.hasAutoLinkTarget) || p.equals(CDS.INSTANCE.hasAutoLinkSource);
    }

    private static boolean isManualLinkRelation(XId p) {
        return p.equals(CDS.INSTANCE.hasManualLinkTarget) || p.equals(CDS.INSTANCE.hasManualLinkSource);
    }

    private static boolean isLinkRelation(XId p) {
        return p.equals(CDS.INSTANCE.hasTarget) || p.equals(CDS.INSTANCE.hasSource);
    }

    private static boolean isRelatedLinkRelation(XId p) {
        return p.equals(CDS.INSTANCE.hasRelated);
    }

    private static boolean isTypeInstanceRelation(XId p) {
        return p.equals(CDS.INSTANCE.hasType) || p.equals(CDS.INSTANCE.hasInstance);
    }

    private static void indexLink(IMyBase myBase, GraphJob job, LogicalGraph logicalGraph, ITriple<XId, XId, XId> triple, List<LogicalLink> links, boolean reversed) {
        XId s = (XId)triple.s();
        XId p = (XId)triple.p();
        XId o = (XId)triple.o();
        if (s.equals((Object)o) && !job.showSelfLinks) {
            return;
        }
        Set stmts = myBase.itemSet().getStatementsFor(s, p, o);
        if (stmts.isEmpty()) {
            LogicalLink link = new LogicalLink(logicalGraph, triple, reversed);
            links.add(link);
        } else {
            for (IStatement stmt : stmts) {
                LogicalLink link = new LogicalLink(logicalGraph, stmt, reversed);
                links.add(link);
            }
        }
    }
}

