/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.graph.logical;

import com.calpano.kgif.io.common.IKgifImporterExporter;
import de.xam.cmodel.fact.impl.mem.MemoryCTriple;
import de.xam.dwzmodel.api.VocabularyContextGraph;
import de.xam.dwzmodel.graph.logical.LogicalLink;
import de.xam.dwzmodel.graph.logical.LogicalNode;
import de.xam.itemset.Attributes;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.content.UriFormatter;
import de.xam.vocabulary.Vocabularies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.xydra.base.XId;
import org.xydra.core.XX;
import org.xydra.index.EnumUtils;
import org.xydra.index.query.ITriple;

public class LogicalGraph {
    private final Map<XId, LogicalNode> id2node = new HashMap<XId, LogicalNode>();
    private final List<XId> centralNodeIds = new ArrayList<XId>();
    private final Set<LogicalNode> nodes = new HashSet<LogicalNode>();
    private transient IMyBase myBase;
    private transient Map<String, String> myBaseNamespaceMap;
    private static final XId ID_SEMANTICS = XX.toId((String)"id-semantics");
    static final XId contextHidden = VocabularyContextGraph.ATTRIBUTE_HIDDEN;
    static final XId contextHiddenLevel = Vocabularies.addModifier((XId)VocabularyContextGraph.ATTRIBUTE_HIDDEN, (String)"level");

    public static ITriple<XId, XId, XId> reverse(ITriple<XId, XId, XId> t) {
        return new MemoryCTriple((XId)t.o(), (XId)t.p(), (XId)t.s());
    }

    public Map<String, String> getNamespaces() {
        if (this.myBaseNamespaceMap == null) {
            this.myBaseNamespaceMap = ItemSets.getNamespaces((IItemSet)this.myBase.itemSet());
        }
        return this.myBaseNamespaceMap;
    }

    public String toDisplayString(IItem item) {
        IKgifImporterExporter.IdSemantics idSemantics;
        String idSemanticsStr = Attributes.getStringAttribute((IEntity)item, (XId)ID_SEMANTICS);
        if (idSemanticsStr != null && (idSemantics = (IKgifImporterExporter.IdSemantics)EnumUtils.valueOf(IKgifImporterExporter.IdSemantics.class, (String)idSemanticsStr)) != null && idSemantics == IKgifImporterExporter.IdSemantics.bnode) {
            return "_";
        }
        String label = item.getDisplayString();
        boolean shorten = true;
        return UriFormatter.toShortAndRelevantString((String)label, this.getNamespaces(), (boolean)true);
    }

    public boolean indexLink(LogicalLink link, boolean indexSelfLinks) {
        XId unifiedO;
        ITriple<XId, XId, XId> t = link.asTriple();
        XId s = (XId)t.s();
        LogicalNode start = this.getNode(s);
        XId o = (XId)t.o();
        LogicalNode end = this.getNode(o);
        XId unifiedS = start.getBaseEntity().getId();
        if (unifiedS.equals((Object)(unifiedO = end.getBaseEntity().getId())) && !indexSelfLinks) {
            return false;
        }
        if (unifiedS.compareTo((Object)unifiedO) < 0) {
            link.setReversed(false);
            return start.indexLink(this, link);
        }
        link.setReversed(true);
        return end.indexLink(this, link);
    }

    public LogicalNode getNode(XId entityId) {
        LogicalNode node = this.id2node.get(entityId);
        assert (node != null) : entityId;
        return node;
    }

    public LogicalNode getOrCreateAndAddNode(XId entityId, int depth) {
        LogicalNode node = this.id2node.get(entityId);
        if (node == null) {
            IEntity entity = this.getMyBase().itemSet().getEntityById(entityId);
            node = new LogicalNode(this, entity, depth);
            this.id2node.put(entityId, node);
            this.nodes.add(node);
        } else assert (node.getBaseEntity().getId().equals((Object)entityId));
        return node;
    }

    public boolean isShowTriple(XId s, XId p, XId o) {
        boolean hiddenRelation = false;
        if (MyBases.hasInheritedFlag((IMyBase)this.getMyBase(), (XId)p, (XId)contextHidden) || MyBases.hasInheritedFlag((IMyBase)this.getMyBase(), (XId)p, (XId)contextHiddenLevel)) {
            hiddenRelation = true;
        }
        return hiddenRelation;
    }

    public IMyBase getMyBase() {
        return this.myBase;
    }

    public LogicalGraph(IMyBase myBase) {
        this.myBase = myBase;
    }

    public List<XId> getCentralNodes() {
        return this.centralNodeIds;
    }

    public Set<LogicalNode> getNodes() {
        return this.nodes;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("=== LogicalGraph around central nodes ");
        b.append(this.getCentralNodes());
        b.append("\n");
        for (LogicalNode ln : this.nodes) {
            b.append("\n" + ln.toString());
        }
        return b.toString();
    }

    public void getOrCreateAndAddNode(SortedSet<XId> sorted, int depth) {
    }
}

