/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwzmodel.api;

import com.calpano.common.server.util.ConfParamsDebugMode;
import com.google.common.base.Joiner;
import de.xam.cmodel.value.impl.ByteBasedIdProvider;
import de.xam.desktop.Desktop;
import de.xam.dwzmodel.api.ConfParamsLocalFiles;
import de.xam.itemset.ConfParamsItemSet;
import de.xam.kfacet.impl.wiki.spi.IEntity2Href;
import de.xam.mybase.ConfParamsMyBase;
import de.xam.p13n.shared.ConfParamsP13n;
import de.xam.tokenpipe.ConfParamsTokenPipe;
import de.xam.velocity.ConfParamsTemplate;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.xydra.base.BaseRuntime;
import org.xydra.base.XId;
import org.xydra.base.XIdProvider;
import org.xydra.base.id.UUID;
import org.xydra.conf.IConfig;
import org.xydra.conf.IConfigProvider;
import org.xydra.conf.annotations.ConfDoc;
import org.xydra.conf.annotations.ConfType;
import org.xydra.conf.annotations.RequireConfInstance;
import org.xydra.log.api.LoggerFactory;
import org.xydra.log.impl.universal.ConfParamsXydrdaUniversalLog;
import org.xydra.log.spi.ILoggerFactorySPI;
import org.xydra.restless.utils.HostUtils;
import org.xydra.server.ConfParamsXydraServer;

@RequireConfInstance(value={IEntity2Href.class})
public class ConfParamsDwzModel
implements IConfigProvider {
    public static final String[] MESSAGE_PACKAGES = new String[]{"de.xam.dwz1.messages"};
    @ConfDoc(value="Root dir for local knowledge files")
    @ConfType(value=String.class)
    public static final String knowledgeFileRootDir = "knowledgeFileRootDir";
    @ConfDoc(value="Verbose mode")
    @ConfType(value=Boolean.class)
    public static final String verbose = "verbose";
    public static final String defaultAppName = "denkwerkzeug";
    @ConfDoc(value="some file-system friendly string")
    @ConfType(value=String.class)
    public static final String appName = "appName";
    @ConfDoc(value="local hostname")
    @ConfType(value=String.class)
    public static final String id_hostName = "id-hostName";
    @ConfDoc(value="local username")
    @ConfType(value=String.class)
    public static final String id_userName = "id-userName";
    @ConfDoc(value="comma-separated, sorted list of hex-represented MAC addresses")
    @ConfType(value=String.class)
    public static final String id_macAdresses = "id-macAdresses";
    @ConfDoc(value="local uuid")
    @ConfType(value=String.class)
    public static final String id_uuid = "id-uuid";

    public void configureDefaults(IConfig conf) {
        new ConfParamsXydrdaUniversalLog().configureDefaults(conf);
        new ConfParamsXydraServer().configureDefaults(conf);
        new ConfParamsDebugMode().configureDefaults(conf);
        new ConfParamsP13n().configureDefaults(conf);
        new ConfParamsTemplate().configureDefaults(conf);
        new ConfParamsLocalFiles().configureDefaults(conf);
        new ConfParamsTokenPipe().configureDefaults(conf);
        new ConfParamsItemSet().configureDefaults(conf);
        new ConfParamsMyBase().configureDefaults(conf);
        ConfParamsDwzModel.setLocalDefaults(conf);
    }

    private static void setLocalDefaults(IConfig conf) {
        conf.setInstance(ILoggerFactorySPI.class, (Object)LoggerFactory.getLoggerFactorySPI());
        conf.setDefault(verbose, (Object)false, true);
        BaseRuntime.setIdProvider((XIdProvider)new ByteBasedIdProvider());
        conf.setDefault(IEntity2Href.class, (Object)new IEntity2Href(){

            public String getViewItemUrl(XId itemId) {
                return "#" + itemId;
            }

            public String getDisambiguateItemsUrl(String name) {
                throw new RuntimeException("Disambiguate '" + name + "'");
            }
        }, true);
        String knowledgeFileDirName = "Denkwerkzeug Knowledge Files";
        File knowledgeFileRootDir = new File(Desktop.getUserHome(), "Denkwerkzeug Knowledge Files");
        knowledgeFileRootDir.mkdirs();
        conf.set(knowledgeFileRootDir, (Object)knowledgeFileRootDir.getAbsolutePath());
        ConfParamsDwzModel.ensureUserIds(conf);
    }

    public static void ensureUserIds(IConfig conf) {
        ConfParamsDwzModel.ensureUserIds_(conf, id_hostName, String.class, new ICreate<String>(){

            @Override
            public String create() {
                return HostUtils.getLocalHostnameOrNull();
            }
        });
        ConfParamsDwzModel.ensureUserIds_(conf, id_userName, String.class, new ICreate<String>(){

            @Override
            public String create() {
                return Desktop.getUserName();
            }
        });
        ConfParamsDwzModel.ensureUserIds_(conf, id_macAdresses, String.class, new ICreate<String>(){

            @Override
            public String create() {
                List list = Desktop.getLocalMacAddresses();
                Collections.sort(list);
                return Joiner.on((char)',').join((Iterable)list);
            }
        });
        ConfParamsDwzModel.ensureUserIds_(conf, id_uuid, String.class, new ICreate<String>(){

            @Override
            public String create() {
                return UUID.uuid();
            }
        });
    }

    private static <T> void ensureUserIds_(IConfig conf, String confKey, Class<T> confType, ICreate<T> create) {
        Object confValue = conf.tryToGetAs(confKey, confType);
        if (confValue == null && (confValue = create.create()) != null) {
            conf.set(confKey, confValue);
        }
    }

    private static interface ICreate<T> {
        public T create();
    }
}

