/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import de.xam.texthtml.text.CamelCase;
import de.xam.texthtml.text.TextRenderer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JspWikiSyntax {
    public static final String _AUTOLINKABLE_CHARS_NO_WHITESPACE = "\\w";
    public static final String _AUTOLINKABLE_WHITESPACE_CHARS = "\\-_.";
    public static final String AUTOLINKABLE_CHARS_WITH_WHITESPACE = "\\w\\-_.";
    public static final Pattern pattern_AUTOLINKABLE_EXPRESSION = Pattern.compile("(?:^|[^\\w\\-_.]+)([\\w]+([\\w\\-_. ]+[\\w]+)+)(?:$|(?![\\w\\-_.]+))", 256);
    public static final Pattern pattern_AUTOLINKABLE_WHITESPACE = Pattern.compile("[\\-_.]");
    public static final Pattern pattern_EMAIL = Pattern.compile("(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF._~!$&()*+;=:-]+)@(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost))");
    public static final Pattern pattern_FIND_BRACED_LINK = Pattern.compile("\\[([a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-%#??#| &&[^\\]\\[]]+)\\]");
    public static final Pattern pattern_FIND_EMAIL = Pattern.compile(TextRenderer.FIND_EMAIL);
    public static final Pattern pattern_FIND_FULL_HTTP_URL = Pattern.compile(TextRenderer.FIND_HTTP_URL);
    public static final Pattern pattern_FIND_FILE_URL = Pattern.compile(TextRenderer.FIND_FILE_URL);
    public static final Pattern pattern_FIND_PARTIAL_URL = Pattern.compile(TextRenderer.FIND_PARTIAL_URL);
    public static final Pattern pattern_FOOTNOTE = Pattern.compile("[0-9]{1,3}");
    public static final Pattern pattern_FULL_HTTP_URL = Pattern.compile("(?:(?:(http|https):\\/\\/)(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)(?::[0-9]+)?(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)");
    public static final Pattern pattern_FILE_URL = Pattern.compile("(?:file:\\/\\/(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)");
    public static final Pattern pattern_MINIMAL_URL_CONTAINS = Pattern.compile("[:.]|localhost");
    public static final Pattern pattern_PARTIAL_URL = Pattern.compile("(?:(?:(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF](?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF-]*[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF])?\\.)+(?:[a-z]{2,}|[A-Z]{2,})|localhost)(?::[0-9]+)?(?:\\/(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:\\?(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?(?:#(?:[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-]|(?:%[0-9a-fA-F][0-9a-fA-F]))*)?)");
    public static final Pattern pattern_WIKILINK = Pattern.compile("\\[[^\\[\\]\\n\\t\\r]+\\]", 256);
    public static final Pattern pattern_WIKILINK_LINKTARGET_NAMESPACE = Pattern.compile("([a-zA-Z]:)([a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-%#?])", 256);
    public static final Pattern pattern_WIKILINK_TARGET = Pattern.compile("[a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-%#? ]+");
    public static final Pattern pattern_WIKILINK_TARGET_LABELED = Pattern.compile("([a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-%#? &&[^|\\]\\[]]+)[ ]*[|][ ]*([a-zA-Z0-9\\u0080-\\u024F\\u1E00-\\u1EFF\\u2C60-\\u2C7F\\uA720-\\uA7FF\\u0370-\\u1FFF\\u3040-\\u30FF\\/._~!$&'()*+,;=:@\\-%#? &&[^|\\]\\[]]+)", 256);

    public static boolean couldBeEmail(String s) {
        return s.indexOf(64) > 0;
    }

    public static boolean couldBeURI(String t) {
        return t.indexOf(46) >= 0 || t.indexOf(58) >= 0 || t.contains("localhost");
    }

    public static String getHeadlineText(String line) {
        String s = line;
        while (s.startsWith("!")) {
            s = s.substring(1);
        }
        return s.trim();
    }

    public static String getWikiLinkText(String t) {
        assert (JspWikiSyntax.isWikiLink(t));
        return t.substring(1, t.length() - 1);
    }

    public static boolean isEmailAddress(String s) {
        return pattern_EMAIL.matcher(s).matches();
    }

    public static boolean isFootnote(String s) {
        return pattern_FOOTNOTE.matcher(s).matches();
    }

    public static boolean isPluginCall(String s) {
        return s.startsWith("{INSERT") && s.endsWith("}");
    }

    public static boolean isHeadline(String line) {
        return line.startsWith("!");
    }

    public static boolean isFileLink(String t) {
        assert (t != null);
        return pattern_FILE_URL.matcher(t).matches();
    }

    public static boolean isHttpLink(String t) {
        assert (t != null);
        return pattern_FULL_HTTP_URL.matcher(t).matches();
    }

    public static boolean isIri(String s) {
        assert (s != null);
        return JspWikiSyntax.isHttpLink(s) || JspWikiSyntax.isEmailAddress(s) || JspWikiSyntax.isFileLink(s);
    }

    public static boolean isWikiLink(String t) {
        assert (t != null);
        return t.startsWith("[") && t.endsWith("]");
    }

    public static boolean isWikiWord(String t) {
        assert (t != null);
        return CamelCase.isCamelCase(t);
    }

    public static void main(String[] args) {
        System.out.println(pattern_FIND_BRACED_LINK.toString());
        System.out.println(pattern_AUTOLINKABLE_EXPRESSION);
        Matcher m = pattern_AUTOLINKABLE_EXPRESSION.matcher("'Blup Foobar'");
        while (m.find()) {
            System.out.println(m.group(1));
        }
    }
}

