/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import de.xam.p13n.server.LocaleUtils;
import de.xam.p13n.shared.MiniLocale;
import de.xam.p13n.shared.Personalisation;
import de.xam.p13n.shared.PersonalisedMessageBundle;
import de.xam.p13n.shared.time.TimeProvider;
import de.xam.resourceloader.p13n.P13nUtils;
import de.xam.resourceloader.p13n.PersonalisedMessageBundleIO;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class HumanReadableText {
    private static final Logger log = LoggerFactory.getLogger(HumanReadableText.class);
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;

    public static String fullDateTime(long datetime) {
        DateTime dt = new DateTime(datetime, DateTimeZone.UTC);
        return dt.toString("yyyy'-'MM'-'dd'--'HH'-'mm'-'ss','SSS'-Z'ZZZZZ");
    }

    public static String fullDate_HH_MM(long datetime) {
        DateTime dt = new DateTime(datetime, DateTimeZone.UTC);
        return dt.toString("yyyy'-'MM'-'dd'--'HH'-'mm'");
    }

    public static String fullDate(long datetime) {
        if (datetime == 0L) {
            return "-";
        }
        DateTime dt = new DateTime(datetime, DateTimeZone.UTC);
        return dt.toString("yyyy'-'MM'-'dd'");
    }

    public static String fullDateTimeIso(long datetime) {
        if (datetime == 0L) {
            return "-";
        }
        DateTime dt = new DateTime(datetime, DateTimeZone.UTC);
        return dt.toString(ISODateTimeFormat.dateTime());
    }

    public static long parseIsoDatetime(String fullDateTimeIso) {
        DateTimeFormatter dtf = ISODateTimeFormat.dateTimeParser();
        DateTime dt = dtf.parseDateTime(fullDateTimeIso);
        return dt.getMillis();
    }

    public static int weeksSinceStart(long date, long start) {
        return new Interval(start, date, (Chronology)ISOChronology.getInstanceUTC()).toPeriod().getWeeks();
    }

    public static String fullDateTime(long datetime, Personalisation p13n) {
        int offset = p13n.getUtcOffset();
        DateTimeZone p13nZimeZone = DateTimeZone.forOffsetHours((int)offset);
        DateTime dt = new DateTime(datetime, p13nZimeZone);
        return dt.toString("yyyy'-'MM'-'dd'--'HH'-'mm'-'ss','SSS'-Z'ZZZZZ");
    }

    public static String commonDateTime(long datetime, Personalisation p13n) {
        int offset = p13n.getUtcOffset();
        DateTimeZone p13nZimeZone = DateTimeZone.forOffsetHours((int)offset);
        DateTime dt = new DateTime(datetime, p13nZimeZone);
        Locale javaLocale = LocaleUtils.toJavaLocale((MiniLocale)p13n.getLocale());
        DateTimeFormatter dtf = DateTimeFormat.mediumDateTime().withLocale(javaLocale);
        return dtf.print((ReadableInstant)dt);
    }

    public static boolean isToday(long now, long datetime) {
        LocalDate _now = new LocalDate(now);
        LocalDate _datetime = new LocalDate(datetime);
        return _datetime.isEqual((ReadablePartial)_now);
    }

    public static String niceDay(long now, long datetime, Personalisation p13n) {
        if (p13n == null) {
            return "p13n missing";
        }
        int offset = p13n.getUtcOffset();
        DateTimeZone p13nZimeZone = DateTimeZone.forOffsetHours((int)offset);
        DateTime dt = new DateTime(datetime, p13nZimeZone);
        LocalDate _now = new LocalDate(now, p13nZimeZone);
        LocalDate _datetime = dt.toLocalDate();
        log.debug("Difference in hours is: " + (now - dt.getMillis()) / 3600000L);
        log.debug("Now: " + _now.toString() + " Date: " + _datetime.toString());
        PersonalisedMessageBundle msg = PersonalisedMessageBundleIO.instance((Personalisation)p13n, (String[])new String[0]);
        Locale locale = P13nUtils.toJavaLocale((MiniLocale)p13n.getLocale());
        if (_datetime.isEqual((ReadablePartial)_now)) {
            return msg.get((Object)"time-today");
        }
        if (_datetime.plusDays(1).equals((Object)_now)) {
            return msg.get((Object)"time-yesterday");
        }
        if (_datetime.plusDays(2).equals((Object)_now)) {
            return msg.get((Object)"time-beforeYesterday");
        }
        if (_datetime.minusDays(1).equals((Object)_now)) {
            return msg.get((Object)"time-tomorrow");
        }
        if (Days.daysBetween((ReadablePartial)_now, (ReadablePartial)_datetime).getDays() <= 90) {
            String weekday = _datetime.dayOfWeek().getAsText(locale);
            String dayAndMonth = _datetime.toString("d'. 'MMMM", locale);
            return weekday + ", " + dayAndMonth;
        }
        return _datetime.toString("d'. 'MMMM' 'yyyy", locale);
    }

    public static String niceTimespan(long milliseconds) {
        long secsTotal = milliseconds / 1000L;
        long minsTotal = secsTotal / 60L;
        long hoursTotal = minsTotal / 60L;
        long daysTotal = hoursTotal / 24L;
        long weeksTotal = daysTotal / 7L;
        long yearsTotal = daysTotal / 365L;
        long weeks = weeksTotal - yearsTotal * 52L;
        long days = daysTotal - weeksTotal * 7L;
        long hours = hoursTotal - daysTotal * 24L;
        long mins = minsTotal - hoursTotal * 60L;
        long secs = secsTotal - minsTotal * 60L;
        StringBuffer buf = new StringBuffer();
        boolean needComma = false;
        int scalesShown = 0;
        int showScalesMax = 2;
        if (yearsTotal > 0L) {
            buf.append(yearsTotal + " year" + (yearsTotal > 1L ? "s" : ""));
            needComma = true;
            ++scalesShown;
        }
        if (weeks > 0L && scalesShown < 2) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(weeks + " week" + (weeks > 1L ? "s" : ""));
            needComma = true;
            ++scalesShown;
        }
        if (days > 0L && scalesShown < 2) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(days + " day" + (days > 1L ? "s" : ""));
            needComma = true;
            ++scalesShown;
        }
        if (hours > 0L && scalesShown < 2) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(hours + " hour" + (hours > 1L ? "s" : ""));
            needComma = true;
            ++scalesShown;
        }
        if (mins > 0L && scalesShown < 2) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(mins + " min" + (mins > 1L ? "s" : ""));
            needComma = true;
            ++scalesShown;
        }
        if (secs > 0L && scalesShown < 2) {
            if (needComma) {
                buf.append(", ");
            }
            buf.append(secs + " sec" + (secs > 1L ? "s" : ""));
            needComma = true;
            ++scalesShown;
        }
        if (buf.length() == 0) {
            buf.append("instant");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        Personalisation p13n = Personalisation.GERMANY;
        System.out.println("GERMANY = " + HumanReadableText.commonDateTime(TimeProvider.getCurrentTimeInMillis(), p13n));
        System.out.println("EN_US__SAN_FRANCISCO = " + HumanReadableText.commonDateTime(TimeProvider.getCurrentTimeInMillis(), Personalisation.EN_US__SAN_FRANCISCO));
        System.out.println(HumanReadableText.niceTimespan(1000000000L));
        System.out.println(HumanReadableText.weeksSinceStart(TimeProvider.getCurrentTimeInMillis() + 2000000000L, TimeProvider.getCurrentTimeInMillis()));
        long now = TimeProvider.getCurrentTimeInMillis();
        System.out.println(HumanReadableText.fullDateTime(now));
        System.out.println("now = " + now + " =?= " + HumanReadableText.parseIsoDatetime(HumanReadableText.fullDateTimeIso(now)));
        System.out.println(HumanReadableText.parseIsoDatetime("2011-10-11T19:00:00.000Z"));
        System.out.println(HumanReadableText.largeNumber(10000000L));
    }

    public static int daysSince(long t) {
        long now = System.currentTimeMillis();
        long ago = now - t;
        int days = (int)(ago / 86400000L);
        return days;
    }

    public static String largeNumber(long n) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.GERMANY);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(n);
    }

    public static String fileSize(long length) {
        if (length == -1L) {
            return "n/a";
        }
        if (length == 0L) {
            return "Empty";
        }
        if (length < 1024L) {
            return length + " B";
        }
        if (length < 0x100000L) {
            return length / 1024L + " KB";
        }
        long length_in_mb = length / 0x100000L;
        if (length_in_mb < 1024L) {
            return length_in_mb + " MB";
        }
        if (length_in_mb < 0x100000L) {
            return length_in_mb / 1024L + " GB";
        }
        return length_in_mb / 0x100000L + " TB";
    }

    public static String year(long datetime) {
        DateTime dt = new DateTime(datetime, DateTimeZone.UTC);
        return dt.toString("yyyy");
    }
}

