/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xydra.base.util.DumpUtilsBase;
import org.xydra.index.impl.IntegerRangeIndex;

public class AnnotatedString<A> {
    IntegerRangeIndex rangeIndex = new IntegerRangeIndex();
    Map<Integer, AnnotatedSpan<A>> annotations = new HashMap<Integer, AnnotatedSpan<A>>();
    private final String s;

    public AnnotatedString(String s) {
        this.s = s;
    }

    public String getString() {
        return this.s;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getString());
        b.append("\n");
        for (int i = 0; i < this.s.length(); ++i) {
            b.append(this.isAnnotated(i) ? (char)'A' : '-');
        }
        return b.toString();
    }

    public void addAnnotation(int startInclusive, int endInclusive, A annotation) {
        AnnotatedSpan<A> ann = new AnnotatedSpan<A>(startInclusive, endInclusive, annotation);
        this.addAnnotation(ann);
    }

    public void addAnnotation(AnnotatedSpan<A> ann) {
        this.rangeIndex.index(((AnnotatedSpan)ann).startInclusive, ((AnnotatedSpan)ann).endInclusive);
        this.annotations.put(((AnnotatedSpan)ann).startInclusive, ann);
    }

    public boolean isAnnotated(int index) {
        return this.rangeIndex.isInInterval(index);
    }

    public Iterator<IntegerRangeIndex.Span> spanIterator(int maxValueInclusive) {
        return this.rangeIndex.spanIterator(maxValueInclusive);
    }

    public Iterator<IntegerRangeIndex.Span> spanIterator() {
        return this.rangeIndex.spanIterator(0, this.s.length() - 1);
    }

    public Iterator<IntegerRangeIndex.Span> spanIterator(int startInvlusive, int maxValueInclusive) {
        return this.rangeIndex.spanIterator(startInvlusive, maxValueInclusive);
    }

    public AnnotatedSpan<A> getAnnotationStartingAt(int startInclusive) {
        return this.annotations.get(startInclusive);
    }

    public void dump() {
        this.rangeIndex.dump();
        DumpUtilsBase.dump(this.annotations);
    }

    public String getString(AnnotatedSpan<A> annSpan) {
        return this.getString().substring(annSpan.getStartInclusive(), annSpan.getEndInclusive() + 1);
    }

    public String getString(IntegerRangeIndex.Span span) {
        return this.getString().substring(span.getStartInclusive(), span.getEndInclusive() + 1);
    }

    public List<IntegerRangeIndex.Span> spansNotInRangeList() {
        ArrayList<IntegerRangeIndex.Span> list = new ArrayList<IntegerRangeIndex.Span>();
        Iterator<IntegerRangeIndex.Span> spanIt = this.spanIterator();
        while (spanIt.hasNext()) {
            IntegerRangeIndex.Span span = spanIt.next();
            if (span.isInRange()) continue;
            list.add(span);
        }
        return list;
    }

    public static class AnnotatedSpan<A> {
        private final int startInclusive;
        private final int endInclusive;
        private final A annotation;

        public AnnotatedSpan(int startInclusive, int endInclusive, A annotation) {
            this.startInclusive = startInclusive;
            this.endInclusive = endInclusive;
            this.annotation = annotation;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public int getStartInclusive() {
            return this.startInclusive;
        }

        public int getEndInclusive() {
            return this.endInclusive;
        }
    }
}

