/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_1_0.read;

import com.calpano.kgif.io.FileFormats;
import com.calpano.kgif.io.IFileFormat;
import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.io.IoContext;
import com.calpano.kgif.util.XmlReaderTools;
import com.calpano.kgif.v1_1_0.IEntityHandler;
import com.calpano.kgif.v1_1_0.gen.Header;
import com.calpano.kgif.v1_1_0.gen.Kgif;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import com.calpano.kgif.v1_1_0.read.KgifReadWriteException;
import java.io.IOException;
import java.io.Reader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class KgifReader
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KgifReader.class);
    protected IStreamProcessProgressReporter progress;
    protected IEntityHandler entityHandler;
    protected String sourceName;
    private Reader reader;
    private Unmarshaller unmarshaller;

    private IIoContext ioContext(XMLStreamReader xmlreader) {
        final String parseLocation = KgifReader.parseLocation(xmlreader.getLocation());
        return new IIoContext(){

            @Override
            public IStreamProcessProgressReporter getProcessProgressReporter() {
                return KgifReader.this.progress;
            }

            @Override
            public String getParseLocation() {
                return parseLocation;
            }

            @Override
            public IIoContext refine(String parseLocation2) {
                return new IoContext(this.getProcessProgressReporter(), parseLocation2);
            }

            @Override
            public void setProgressReporter(IStreamProcessProgressReporter progress) {
                KgifReader.this.progress = progress;
            }
        };
    }

    private static String parseLocation(Location location) {
        if (location == null) {
            return "n/a";
        }
        return location.getLineNumber() + ":" + location.getColumnNumber();
    }

    private static String parseLocation(XMLStreamException e) {
        return KgifReader.parseLocation(e.getLocation());
    }

    public KgifReader(Reader reader, IEntityHandler entityHandler) {
        this(reader);
        this.setEntityHandler(entityHandler);
    }

    public KgifReader(Reader reader) {
        try {
            this.setReader(reader);
        }
        catch (JAXBException e) {
            throw new KgifReadWriteException("Internal Error", "beforeDocumentStart", e);
        }
    }

    public void setEntityHandler(IEntityHandler entityHandler) {
        this.entityHandler = entityHandler;
    }

    public IFileFormat getFileFormat() {
        return FileFormats.KGIF_1_1_0;
    }

    private void progress(String progressMessage) {
        if (log.isTraceEnabled()) {
            log.trace("Progress: " + progressMessage);
        }
        if (this.progress != null) {
            this.progress.reportProgress(progressMessage);
        }
    }

    public void read() throws KgifReadWriteException, IOException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader xmlreader = null;
        try {
            xmlreader = xmlInputFactory.createXMLStreamReader(this.reader);
            XmlReaderTools.skipEvents(xmlreader, 11, 7, 5, 3);
            this.entityHandler.onDocumentStart(this.ioContext(xmlreader));
            this.progress("Found document start");
            XmlReaderTools.skipUntilElementStart(xmlreader, null, "header");
            Header header = (Header)this.unmarshaller.unmarshal(xmlreader, Header.class).getValue();
            this.entityHandler.onHeader(this.ioContext(xmlreader), header);
            this.progress("Parsed header");
            XmlReaderTools.skipUntilElementStart(xmlreader, null, "graph");
            this.progress("Graph start");
            XmlReaderTools.skipUntilEvent(xmlreader, 1);
            if (xmlreader.getLocalName() == "metadata") {
                Metadata metadata = (Metadata)this.unmarshaller.unmarshal(xmlreader, Metadata.class).getValue();
                if (log.isTraceEnabled()) {
                    log.trace("Now at " + xmlreader.getLocation().getLineNumber() + ":" + xmlreader.getLocation().getColumnNumber() + " = " + xmlreader.getLocation().getCharacterOffset());
                }
                this.entityHandler.onGraphStart(this.ioContext(xmlreader), metadata);
            } else {
                this.entityHandler.onGraphStart(this.ioContext(xmlreader), null);
            }
            long nodes = 0L;
            long links = 0L;
            long properties = 0L;
            String name = "";
            do {
                boolean stats = false;
                if (log.isTraceEnabled()) {
                    log.trace("Parsing at line:col " + this.ioContext(xmlreader) + " = char " + xmlreader.getLocation().getCharacterOffset());
                }
                if (!XmlReaderTools.skipUntilElementStart(xmlreader, "graph", "node", "link", "property")) break;
                name = xmlreader.getLocalName();
                if (name.equals("node")) {
                    JAXBElement unNode = this.unmarshaller.unmarshal(xmlreader, Node.class);
                    Node node = (Node)unNode.getValue();
                    this.entityHandler.onNode(this.ioContext(xmlreader), node);
                    if (++nodes % 1000L == 0L) {
                        stats = true;
                    }
                } else if (name.equals("link")) {
                    Link link = (Link)this.unmarshaller.unmarshal(xmlreader, Link.class).getValue();
                    this.entityHandler.onLink(this.ioContext(xmlreader), link);
                    if (++links % 1000L == 0L) {
                        stats = true;
                    }
                } else {
                    assert (name.equals("property"));
                    Property property = (Property)this.unmarshaller.unmarshal(xmlreader, Property.class).getValue();
                    this.entityHandler.onProperty(this.ioContext(xmlreader), property);
                    if (++properties % 1000L == 0L) {
                        stats = true;
                    }
                }
                if (!stats) continue;
                this.progress("Read " + nodes + " nodes, " + links + " links, and " + properties + " properties " + " ...");
            } while (name.equals("node") || name.equals("link") || name.equals("property"));
            XmlReaderTools.skipUntilElementEnd(xmlreader, "graph");
            this.progress("Graph end");
            this.entityHandler.onGraphEnd(this.ioContext(xmlreader));
            this.progress("Document end");
            this.entityHandler.onDocumentEnd(this.ioContext(xmlreader));
            this.progress("Read " + nodes + " nodes, " + links + " links, and " + properties + " properties");
            xmlreader.close();
        }
        catch (XMLStreamException e) {
            throw new KgifReadWriteException("Internal Error", "beforeDocumentStart/" + KgifReader.parseLocation(e), e);
        }
        catch (JAXBException e) {
            throw new KgifReadWriteException("Internal Error", xmlreader != null ? KgifReader.parseLocation(xmlreader.getLocation()) : "n/a", e);
        }
    }

    private void setReader(Reader r) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Kgif.class});
        this.unmarshaller = context.createUnmarshaller();
        this.reader = r;
    }

    @Override
    public void close() throws IOException {
        this.entityHandler.close();
        this.reader.close();
    }

    public void setProgressHandler(IStreamProcessProgressReporter progress) {
        this.progress = progress;
    }

    public void setSourceName(String sourceFileName) {
        this.sourceName = sourceFileName;
    }
}

