/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_1_0.ioutils;

import com.calpano.kgif.v1_1_0.gen.Attachment;
import com.calpano.kgif.v1_1_0.gen.Attribute;
import com.calpano.kgif.v1_1_0.gen.Attributes;
import com.calpano.kgif.v1_1_0.gen.Content;
import com.calpano.kgif.v1_1_0.gen.Extension;
import com.calpano.kgif.v1_1_0.gen.Graph;
import com.calpano.kgif.v1_1_0.gen.Kgif;
import com.calpano.kgif.v1_1_0.gen.Link;
import com.calpano.kgif.v1_1_0.gen.Metadata;
import com.calpano.kgif.v1_1_0.gen.Node;
import com.calpano.kgif.v1_1_0.gen.Property;
import java.util.List;

public class KgifDump {
    public static void dump(Kgif kgif) {
        System.out.println(kgif.getHeader().getSchemaVersionNumber());
        System.out.println(kgif.getHeader().getSchemaVersionDate());
        List<Graph> graphs = kgif.getGraph();
        for (Graph graph : graphs) {
            System.out.println("Graph ------------------");
            List<Object> list = graph.getNodeOrLinkOrProperty();
            for (Object o : list) {
                if (o instanceof Node) {
                    KgifDump.dump((Node)o);
                }
                if (o instanceof Link) {
                    KgifDump.dump((Link)o);
                }
                if (!(o instanceof Property)) continue;
                KgifDump.dump((Property)o);
            }
        }
    }

    private static void dump(Link link) {
        System.out.println("LINK [" + link.getId() + "] " + link.getFrom() + "--(" + link.getType() + ")-->" + link.getTo());
        KgifDump.dump(link.getMetadata());
    }

    private static void dump(Property property) {
        System.out.println("PROPERTY [" + property.getId() + "] " + property.getKey() + "= '" + property.getContent().getContent() + "'");
        KgifDump.dump(property.getMetadata());
    }

    static void dump(Metadata metadata) {
        List<Extension> extensions;
        List<Attachment> attachments;
        if (metadata == null) {
            return;
        }
        Attributes atts = metadata.getAttributes();
        if (atts != null) {
            for (Attribute att : atts.getAttribute()) {
                System.out.println(att.getName() + " = " + att.getContent());
            }
        }
        if ((attachments = metadata.getAttachment()) != null) {
            for (Attachment attachment : attachments) {
                KgifDump.dump(attachment);
            }
        }
        if ((extensions = metadata.getExtension()) != null) {
            for (Extension extension : extensions) {
                KgifDump.dump(extension);
            }
        }
    }

    private static void dump(Node node) {
        System.out.println("NODE [" + node.getId() + "] '" + node.getLabel().getContent() + "'");
        KgifDump.dump(node.getMetadata());
        KgifDump.dump(node.getContent());
    }

    private static void dump(Content content) {
        if (content != null) {
            System.out.println("CONTENT " + content.getContentType());
            System.out.println("'" + content.getContent() + "'");
        }
    }

    public static void dump(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            KgifDump.dump(node);
        } else if (o instanceof Link) {
            Link link = (Link)o;
            KgifDump.dump(link);
        } else {
            System.out.println(o.toString());
        }
    }
}

