/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_1.read;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.v1_0_1.IEntityHandler;
import com.calpano.kgif.v1_0_1.KgifJob;
import com.calpano.kgif.v1_0_1.gen.Content;
import com.calpano.kgif.v1_0_1.gen.Header;
import com.calpano.kgif.v1_0_1.gen.Label;
import com.calpano.kgif.v1_0_1.gen.Link;
import com.calpano.kgif.v1_0_1.gen.Metadata;
import com.calpano.kgif.v1_0_1.gen.Node;
import com.calpano.kgif.v1_0_1.gen.Property;
import com.calpano.kgif.v1_0_1.ioutils.KgifDump;
import com.calpano.kgif.v1_0_1.read.KgifReadWriteException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xydra.index.iterator.Iterators;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public final class ValidatingEntityHandler
implements IEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(ValidatingEntityHandler.class);
    private final Map<String, Object> ids = new HashMap<String, Object>();
    private boolean inDocument = false;
    private boolean inGraph = false;
    private final KgifJob job;
    private final Set<String> link_oIds = new HashSet<String>();
    private final Set<String> linkAndProp_pIds = new HashSet<String>();
    private final Set<String> linkAndProp_sIds = new HashSet<String>();
    private HashSet<String> allowedContentTypes = null;
    private boolean throwExceptions;
    private boolean valid = true;

    public ValidatingEntityHandler(KgifJob job) {
        this.job = job;
    }

    @Override
    public void close() throws IOException {
    }

    public Set<String> getMissingNodeIds() {
        HashSet<String> idsUsedInLinks = new HashSet<String>();
        idsUsedInLinks.addAll(this.linkAndProp_sIds);
        idsUsedInLinks.addAll(this.linkAndProp_pIds);
        idsUsedInLinks.addAll(this.link_oIds);
        idsUsedInLinks.removeAll(this.ids.keySet());
        return idsUsedInLinks;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void markAsInvalid(IIoContext ioContext, String msg) {
        this.valid = false;
        log.warn(msg + " at " + ioContext);
        if (this.throwExceptions) {
            throw new KgifReadWriteException("Invalid: " + msg, ioContext.getParseLocation());
        }
    }

    @Override
    public void onDocumentEnd(IIoContext ioContext) throws IOException {
        if (this.inGraph) {
            throw new KgifReadWriteException("Still in a graph - close it", ioContext.getParseLocation());
        }
        if (!this.inDocument) {
            throw new KgifReadWriteException("Not in a document - start it", ioContext.getParseLocation());
        }
        this.inDocument = false;
    }

    @Override
    public void onDocumentStart(IIoContext ioContext) throws IOException {
        this.inDocument = true;
    }

    @Override
    public void onGraphEnd(IIoContext ioContext) {
        if (!this.inGraph) {
            throw new KgifReadWriteException("Not in a graph - start it", ioContext.getParseLocation());
        }
        this.inGraph = false;
        if (this.job.isRequireUseOnlyIdsWithEntities()) {
            this.validateLinksUseKnownNodes(ioContext);
        }
    }

    @Override
    public void onGraphStart(IIoContext ioContext, Metadata metadata) {
        this.inGraph = true;
    }

    @Override
    public void onHeader(IIoContext ioContext, Header header) {
        if (!this.inDocument) {
            throw new KgifReadWriteException("Not in a document- start it", ioContext.getParseLocation());
        }
        if (this.inGraph) {
            throw new KgifReadWriteException("Already started a graph - put header before", ioContext.getParseLocation());
        }
        this.validateSomeValue(ioContext.refine("header.schemaVersionDate"), header.getSchemaVersionDate());
        this.validateSomeValue(ioContext.refine("header.schemaVersionNumber"), header.getSchemaVersionNumber());
    }

    @Override
    public void onLink(IIoContext ioContext, Link link) {
        if (link.getId() != null) {
            this.validateIdNotUsedYet(ioContext, link.getId(), link);
        }
        this.linkAndProp_sIds.add(link.getFrom());
        this.linkAndProp_pIds.add(link.getType());
        this.link_oIds.add(link.getTo());
    }

    @Override
    public void onProperty(IIoContext ioContext, Property property) {
        if (property.getId() != null) {
            this.validateIdNotUsedYet(ioContext, property.getId(), property);
        }
    }

    @Override
    public void onNode(IIoContext ioContext, Node node) {
        Content content;
        this.validateIdNotUsedYet(ioContext, node.getId(), node);
        Label label = node.getLabel();
        if (this.job.isRequireNodeLabels() && label == null) {
            this.markAsInvalid(ioContext, "Node with id '" + node.getId() + "' has no label.");
        }
        if (label != null) {
            if (label.getContent() == null) {
                this.markAsInvalid(ioContext, "Node with id '" + node.getId() + "' has no label content.");
            }
            if (label.getContentType() == null) {
                this.markAsInvalid(ioContext, "Node with id '" + node.getId() + "' has no label content type.");
            } else {
                String contentType = label.getContentType();
                this.validateContentType(ioContext, contentType);
            }
        }
        if ((content = node.getContent()) != null) {
            if (content.getContentType() == null) {
                this.markAsInvalid(ioContext, "Node with id '" + node.getId() + "' has no content content type.");
            } else {
                String contentType = content.getContentType();
                this.validateContentType(ioContext, contentType);
            }
        }
    }

    public void setAllowedContentTypes(Collection<String> contentTypeStrings) {
        if (contentTypeStrings != null) {
            this.allowedContentTypes = new HashSet();
            this.allowedContentTypes.addAll(contentTypeStrings);
        } else {
            this.allowedContentTypes = null;
        }
    }

    public void setThrowExceptions(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    private void validateContentType(IIoContext ioContext, String contentType) {
        if (this.allowedContentTypes != null && !this.allowedContentTypes.contains(contentType)) {
            this.markAsInvalid(ioContext, "Content type not set as allowed type: '" + contentType + "'");
        }
    }

    private void validateIdNotUsedYet(IIoContext ioContext, String id, Object o) {
        Object existing = this.ids.put(id, o);
        if (existing != null) {
            System.out.println("Existing entity: ");
            KgifDump.dump(existing);
            this.markAsInvalid(ioContext, "Invalid, id '" + id + "' was already used for another element ");
        }
    }

    private void validateLinksUseKnownNodes(IIoContext ioContext) {
        Set<String> missingIds = this.getMissingNodeIds();
        if (!missingIds.isEmpty()) {
            this.markAsInvalid(ioContext, "Found ids used in links but not defined as entites (like a 404). Missing ids are " + Iterators.toText(missingIds));
        }
    }

    private void validateSomeValue(IIoContext ioContext, String s) {
        if (s == null || s.length() == 0) {
            this.markAsInvalid(ioContext, "Invalid, value is missing");
        }
    }
}

