/*
 * Decompiled with CFR 0.152.
 */
package com.calpano.kgif.v1_0_1.ioutils;

import com.calpano.kgif.io.IIoContext;
import com.calpano.kgif.io.IStreamProcessProgressReporter;
import com.calpano.kgif.v1_0_1.IEntityHandler;
import com.calpano.kgif.v1_0_1.gen.Header;
import com.calpano.kgif.v1_0_1.gen.Link;
import com.calpano.kgif.v1_0_1.gen.Metadata;
import com.calpano.kgif.v1_0_1.gen.Node;
import com.calpano.kgif.v1_0_1.gen.Property;
import com.calpano.kgif.v1_0_1.read.KgifReadWriteException;
import com.calpano.kgif.v1_0_1.read.KgifReader;
import com.calpano.kgif.v1_0_1.write.KgifWrites;
import com.calpano.kgif.v1_0_1.write.WritingEntityHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.bind.JAXBException;

public class KgifTool {
    public static void transform(File kgifIn, File kgifOut, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        FileInputStream fis = new FileInputStream(kgifIn);
        kgifOut.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(kgifOut);
        KgifTool.transform(fis, fos, processor, progress);
        fos.close();
        fis.close();
    }

    public static void transform(InputStream is, OutputStream os, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        InputStreamReader r = new InputStreamReader(is, "utf-8");
        OutputStreamWriter w = new OutputStreamWriter(os, "utf-8");
        KgifTool.transform(r, w, processor, progress);
        ((Reader)r).close();
    }

    public static void transform(Reader r, Writer w, TransformingEntityHandler processor, IStreamProcessProgressReporter progress) throws KgifReadWriteException, IOException, JAXBException {
        WritingEntityHandler weh = new WritingEntityHandler(w);
        processor.setBase(weh);
        try (KgifReader kr = new KgifReader(r, processor);){
            kr.setProgressHandler(progress);
            kr.read();
        }
        weh.close();
    }

    public static TransformingEntityHandler addMetadataAttributeToNodesAndLinks(final String attName, final String attValue) {
        return new TransformingEntityHandler(){

            @Override
            public void onLink(IIoContext ioContext, Link link) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute(link, attName, attValue);
                this.base.onLink(ioContext, link);
            }

            @Override
            public void onNode(IIoContext ioContext, Node node) throws IOException, KgifReadWriteException {
                KgifWrites.setMetadataAttribute(node, attName, attValue);
                this.base.onNode(ioContext, node);
            }
        };
    }

    public static class TransformingEntityHandler
    implements IEntityHandler {
        protected IEntityHandler base;

        public void setBase(IEntityHandler base) {
            this.base = base;
        }

        @Override
        public void close() throws IOException, KgifReadWriteException {
            this.base.close();
        }

        @Override
        public void onDocumentEnd(IIoContext ioContext) throws IOException, KgifReadWriteException {
            this.base.onDocumentEnd(ioContext);
        }

        @Override
        public void onDocumentStart(IIoContext ioContext) throws IOException, KgifReadWriteException {
            this.base.onDocumentStart(ioContext);
        }

        @Override
        public void onGraphEnd(IIoContext ioContext) throws IOException, KgifReadWriteException {
            this.base.onGraphEnd(ioContext);
        }

        @Override
        public void onGraphStart(IIoContext ioContext, Metadata metadata) throws IOException, KgifReadWriteException {
            this.base.onGraphStart(ioContext, metadata);
        }

        @Override
        public void onHeader(IIoContext ioContext, Header header) throws IOException, KgifReadWriteException {
            this.base.onHeader(ioContext, header);
        }

        @Override
        public void onLink(IIoContext ioContext, Link link) throws IOException, KgifReadWriteException {
            this.base.onLink(ioContext, link);
        }

        @Override
        public void onNode(IIoContext ioContext, Node node) throws IOException, KgifReadWriteException {
            this.base.onNode(ioContext, node);
        }

        @Override
        public void onProperty(IIoContext ioContext, Property property) throws IOException, KgifReadWriteException {
            this.base.onProperty(ioContext, property);
        }
    }
}

